/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind.annotation;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AnnotatedArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractAnnotatedArgumentBinder<A extends Annotation, T, S>
implements AnnotatedArgumentBinder<A, T, S> {
    private static final String DEFAULT_VALUE_MEMBER = "defaultValue";
    private final ConversionService<?> conversionService;

    protected AbstractAnnotatedArgumentBinder(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        return this.doConvert(this.doResolve(context, values, annotationValue), context);
    }

    @Nullable
    protected Object doResolve(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        String fallbackName;
        Object value = this.resolveValue(context, values, annotationValue);
        if (value == null && !annotationValue.equals(fallbackName = this.getFallbackFormat(context.getArgument()))) {
            annotationValue = fallbackName;
            value = this.resolveValue(context, values, annotationValue);
        }
        return value;
    }

    protected String getFallbackFormat(Argument argument) {
        return NameUtils.hyphenate(argument.getName());
    }

    private Object resolveValue(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        Argument<T> argument = context.getArgument();
        if (StringUtils.isEmpty(annotationValue)) {
            annotationValue = argument.getName();
        }
        return values.get(annotationValue, context).orElseGet(() -> this.conversionService.convert(argument.getAnnotationMetadata().stringValue(Bindable.class, DEFAULT_VALUE_MEMBER).orElse(null), context).orElse(null));
    }

    protected ArgumentBinder.BindingResult<T> doConvert(Object value, ArgumentConversionContext<T> context) {
        Optional result = this.conversionService.convert(value, context);
        if (result.isPresent() && context.getArgument().getType() == Optional.class) {
            return () -> (Optional)result.get();
        }
        return () -> result;
    }
}

