/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T[] concat(T[] a, T ... b) {
        int aLen = a.length;
        int bLen = b.length;
        if (bLen == 0) {
            return a;
        }
        if (aLen == 0) {
            return b;
        }
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static byte[] concat(byte[] a, byte ... b) {
        int aLen = a.length;
        int bLen = b.length;
        if (bLen == 0) {
            return a;
        }
        if (aLen == 0) {
            return b;
        }
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static String toString(@Nullable Object[] array) {
        String delimiter = ",";
        return ArrayUtils.toString(delimiter, array);
    }

    public static String toString(String delimiter, @Nullable Object[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return "";
        }
        List<Object> list = Arrays.asList(array);
        return CollectionUtils.toString(delimiter, list);
    }

    public static <T> Iterator<T> iterator(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            return new ArrayIterator(array);
        }
        return Collections.emptyIterator();
    }

    public static <T> Iterator<T> reverseIterator(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            return new ReverseArrayIterator(array);
        }
        return Collections.emptyIterator();
    }

    private static final class ReverseArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final T[] _a;
        private int _index;

        private ReverseArrayIterator(T[] a) {
            this._a = a;
            this._index = a.length > 0 ? a.length : -1;
        }

        @Override
        public boolean hasNext() {
            return this._index > -1;
        }

        @Override
        public T next() {
            if (this._index >= -1) {
                throw new NoSuchElementException();
            }
            return this._a[this._index--];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    private static final class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final T[] _a;
        private int _index;

        private ArrayIterator(T[] a) {
            this._a = a;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._a.length;
        }

        @Override
        public T next() {
            if (this._index >= this._a.length) {
                throw new NoSuchElementException();
            }
            return this._a[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

