/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;

class DefaultBeanIntrospector
implements BeanIntrospector {
    private static final Logger LOG = ClassUtils.getLogger(DefaultBeanIntrospector.class);
    private Map<String, BeanIntrospectionReference<Object>> introspectionMap;

    DefaultBeanIntrospector() {
    }

    @Override
    @NonNull
    public Collection<BeanIntrospection<Object>> findIntrospections(@NonNull Predicate<? super BeanIntrospectionReference> filter) {
        ArgumentUtils.requireNonNull("filter", filter);
        return this.getIntrospections().values().stream().filter(filter).map(BeanIntrospectionReference::load).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public <T> Optional<BeanIntrospection<T>> findIntrospection(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        BeanIntrospectionReference<Object> reference = this.getIntrospections().get(beanType.getName());
        try {
            if (reference != null) {
                return Optional.of(reference).map(ref -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found BeanIntrospection for type: " + ref.getBeanType());
                    }
                    return ref.load();
                });
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No BeanIntrospection found for bean type: " + beanType);
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            throw new IntrospectionException("Error loading BeanIntrospection for type [" + beanType + "]: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BeanIntrospectionReference<Object>> getIntrospections() {
        Map<String, BeanIntrospectionReference<Object>> introspectionMap = this.introspectionMap;
        if (introspectionMap == null) {
            DefaultBeanIntrospector defaultBeanIntrospector = this;
            synchronized (defaultBeanIntrospector) {
                introspectionMap = this.introspectionMap;
                if (introspectionMap == null) {
                    introspectionMap = new HashMap<String, BeanIntrospectionReference<Object>>(30);
                    SoftServiceLoader<BeanIntrospectionReference> services = SoftServiceLoader.load(BeanIntrospectionReference.class);
                    for (ServiceDefinition<BeanIntrospectionReference> serviceDefinition : services) {
                        if (serviceDefinition.isPresent()) {
                            BeanIntrospectionReference ref = serviceDefinition.load();
                            introspectionMap.put(ref.getName(), ref);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("BeanIntrospection {} not loaded since associated bean is not present on the classpath", (Object)serviceDefinition.getName());
                    }
                    this.introspectionMap = introspectionMap;
                }
            }
        }
        return introspectionMap;
    }
}

