/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.version;

import io.micronaut.core.version.SemanticVersion;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionUtils {
    public static final String MICRONAUT_VERSION = VersionUtils.computeMicronautVersion();

    public static boolean isAtLeastMicronautVersion(String requiredVersion) {
        return MICRONAUT_VERSION == null || SemanticVersion.isAtLeast(MICRONAUT_VERSION, requiredVersion);
    }

    private static String computeMicronautVersion() {
        String classPath;
        String className;
        URL res;
        String micronautVersion = VersionUtils.class.getPackage().getImplementationVersion();
        if (micronautVersion == null && (res = VersionUtils.class.getResource(className = VersionUtils.class.getSimpleName() + ".class")) != null && (classPath = res.toString()).startsWith("jar")) {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            try {
                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                Attributes attr = manifest.getMainAttributes();
                micronautVersion = attr.getValue("Implementation-Version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return micronautVersion;
    }
}

