/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.attr;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.StringUtils;
import java.util.Optional;

public interface MutableAttributeHolder
extends AttributeHolder {
    @NonNull
    public MutableConvertibleValues<Object> getAttributes();

    @NonNull
    default public MutableAttributeHolder setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (StringUtils.isNotEmpty(name)) {
            if (value == null) {
                this.getAttributes().remove(name.toString());
            } else {
                this.getAttributes().put(name.toString(), value);
            }
        }
        return this;
    }

    @NonNull
    default public <T> Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        if (StringUtils.isNotEmpty(name)) {
            String key = name.toString();
            Optional<Object> value = this.getAttribute(key, type);
            value.ifPresent(o -> this.getAttributes().remove(key));
            return value;
        }
        return Optional.empty();
    }
}

