/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.DefaultArgumentConversionContext;
import io.micronaut.core.convert.ErrorsContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public interface ConversionContext
extends AnnotationMetadataProvider,
TypeVariableResolver,
ErrorsContext {
    public static final ConversionContext DEFAULT = new ConversionContext(){};
    public static final ArgumentConversionContext<Boolean> BOOLEAN = ConversionContext.of(Argument.BOOLEAN);
    public static final ArgumentConversionContext<Integer> INT = ConversionContext.of(Argument.INT);
    public static final ArgumentConversionContext<Long> LONG = ConversionContext.of(Argument.LONG);
    public static final ArgumentConversionContext<String> STRING = ConversionContext.of(Argument.STRING);
    public static final ArgumentConversionContext<List<String>> LIST_OF_STRING = ConversionContext.of(Argument.LIST_OF_STRING);
    public static final ArgumentConversionContext<Map> MAP = ConversionContext.of(Argument.of(Map.class));

    @Override
    default public Map<String, Argument<?>> getTypeVariables() {
        return Collections.emptyMap();
    }

    default public Locale getLocale() {
        return Locale.getDefault();
    }

    default public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    default public <T> ArgumentConversionContext<T> with(Argument<T> argument) {
        final ArgumentConversionContext<T> childContext = ConversionContext.of(argument);
        final ConversionContext thisContext = this;
        return new DefaultArgumentConversionContext(argument, thisContext.getLocale(), thisContext.getCharset()){

            @Override
            public <T extends Annotation> T synthesize(Class<T> annotationClass) {
                T annotation = childContext.synthesize(annotationClass);
                if (annotation == null) {
                    return thisContext.synthesize(annotationClass);
                }
                return annotation;
            }

            @Override
            public Annotation[] synthesizeAll() {
                return ArrayUtils.concat(childContext.synthesizeAll(), thisContext.synthesizeAll());
            }

            @Override
            public Annotation[] synthesizeDeclared() {
                return ArrayUtils.concat(childContext.synthesizeDeclared(), thisContext.synthesizeDeclared());
            }

            @Override
            public void reject(Exception exception) {
                thisContext.reject(exception);
            }

            @Override
            public void reject(Object value, Exception exception) {
                thisContext.reject(value, exception);
            }

            @Override
            public Iterator<ConversionError> iterator() {
                return thisContext.iterator();
            }

            @Override
            public Optional<ConversionError> getLastError() {
                return thisContext.getLastError();
            }
        };
    }

    public static ConversionContext of(final Map<String, Argument<?>> typeVariables) {
        return new ConversionContext(){

            @Override
            public Map<String, Argument<?>> getTypeVariables() {
                return typeVariables;
            }
        };
    }

    public static <T> ArgumentConversionContext<T> of(Argument<T> argument) {
        return ConversionContext.of(argument, null, null);
    }

    public static <T> ArgumentConversionContext<T> of(Class<T> argument) {
        ArgumentUtils.requireNonNull("argument", argument);
        return ConversionContext.of(Argument.of(argument), null, null);
    }

    public static <T> ArgumentConversionContext of(Argument<T> argument, @Nullable Locale locale) {
        return ConversionContext.of(argument, locale, null);
    }

    public static <T> ArgumentConversionContext<T> of(Argument<T> argument, @Nullable Locale locale, @Nullable Charset charset) {
        ArgumentUtils.requireNonNull("argument", argument);
        Charset finalCharset = charset != null ? charset : StandardCharsets.UTF_8;
        Locale finalLocale = locale != null ? locale : Locale.getDefault();
        return new DefaultArgumentConversionContext<T>(argument, finalLocale, finalCharset);
    }
}

