/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.scan.ClassPathAnnotationScanner;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Internal
public class CachingClassPathAnnotationScanner
extends ClassPathAnnotationScanner {
    private static final int CACHE_MAX = 5;
    private final Map<CacheKey, List<Class>> initializedObjectsByType = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(5L).build();

    public CachingClassPathAnnotationScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    public CachingClassPathAnnotationScanner() {
    }

    @Override
    protected List<Class> doScan(String annotation, String pkg) {
        return this.initializedObjectsByType.computeIfAbsent(new CacheKey(annotation, pkg), key -> super.doScan(annotation, pkg));
    }

    private static final class CacheKey
    implements Serializable {
        final String annotation;
        final String pkg;

        public CacheKey(String annotation, String pkg) {
            this.annotation = annotation;
            this.pkg = pkg;
        }
    }
}

