/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.Blocking;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    private static final int BUFFER_MAX = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static String readText(BufferedReader reader) throws IOException {
        StringBuilder answer = new StringBuilder();
        if (reader == null) {
            return answer.toString();
        }
        char[] charBuffer = new char[8192];
        try {
            int nbCharRead;
            while ((nbCharRead = reader.read(charBuffer)) != -1) {
                answer.append(charBuffer, 0, nbCharRead);
            }
            BufferedReader temp = reader;
            reader = null;
            ((Reader)temp).close();
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn("Failed to close reader: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer.toString();
    }
}

