/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.graal.GraalReflectionConfigurer;
import io.micronaut.core.graal.StaticServiceDefinitions;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class ServiceLoaderFeature
implements Feature {
    ServiceLoaderFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.configureForReflection(access);
        StaticServiceDefinitions staticServiceDefinitions = this.buildStaticServiceDefinitions(access);
        Collection<Set<String>> allTypeNames = staticServiceDefinitions.serviceTypeMap.values();
        for (Set<String> typeNameSet : allTypeNames) {
            for (String typeName : typeNameSet) {
                try {
                    Class c = access.findClassByName(typeName);
                    if (c == null) continue;
                    RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{c});
                    RuntimeReflection.register((Class[])new Class[]{c});
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        ImageSingletons.add(StaticServiceDefinitions.class, (Object)staticServiceDefinitions);
    }

    @NonNull
    private StaticServiceDefinitions buildStaticServiceDefinitions(Feature.BeforeAnalysisAccess access) {
        StaticServiceDefinitions staticServiceDefinitions = new StaticServiceDefinitions();
        String path = "META-INF/micronaut/";
        try {
            Enumeration<URL> micronautResources = access.getApplicationClassLoader().getResources("META-INF/micronaut/");
            while (micronautResources.hasMoreElements()) {
                HashSet servicePaths = new HashSet();
                URL url = micronautResources.nextElement();
                IOUtils.eachFile(url, "META-INF/micronaut/", servicePath -> {
                    String serviceName;
                    if (Files.isDirectory(servicePath, new LinkOption[0]) && (serviceName = servicePath.toString()).startsWith("META-INF/micronaut/")) {
                        servicePaths.add(serviceName);
                    }
                });
                for (String servicePath2 : servicePaths) {
                    IOUtils.eachFile(url, servicePath2, serviceTypePath -> {
                        if (Files.isRegularFile(serviceTypePath, new LinkOption[0])) {
                            Set serviceTypeNames = staticServiceDefinitions.serviceTypeMap.computeIfAbsent(servicePath2, key -> new HashSet());
                            String serviceTypeName = serviceTypePath.getFileName().toString();
                            serviceTypeNames.add(serviceTypeName);
                        }
                    });
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return staticServiceDefinitions;
    }

    private void configureForReflection(final Feature.BeforeAnalysisAccess access) {
        ArrayList configurers = new ArrayList();
        SoftServiceLoader.load(GraalReflectionConfigurer.class, access.getApplicationClassLoader()).collectAll(configurers);
        GraalReflectionConfigurer.ReflectionConfigurationContext context = new GraalReflectionConfigurer.ReflectionConfigurationContext(){

            @Override
            public Class<?> findClassByName(@NonNull String name) {
                return access.findClassByName(name);
            }

            @Override
            public void register(Class<?> ... types) {
                RuntimeReflection.register((Class[])types);
            }

            @Override
            public void register(Method ... methods) {
                RuntimeReflection.register((Executable[])methods);
            }

            @Override
            public void register(Field ... fields) {
                RuntimeReflection.register((Field[])fields);
            }

            @Override
            public void register(Constructor<?> ... constructors) {
                RuntimeReflection.register((Executable[])constructors);
            }
        };
        for (GraalReflectionConfigurer configurer : configurers) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{configurer.getClass()});
            configurer.configure(context);
        }
    }
}

