/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.FileReadable;
import io.micronaut.core.io.UrlReadable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.ArgumentUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Readable
extends Named {
    @NonNull
    public InputStream asInputStream() throws IOException;

    public boolean exists();

    default public Reader asReader() throws IOException {
        return this.asReader(StandardCharsets.UTF_8);
    }

    default public Reader asReader(Charset charset) throws IOException {
        ArgumentUtils.requireNonNull("charset", charset);
        return new InputStreamReader(this.asInputStream(), charset);
    }

    @NonNull
    public static Readable of(@NonNull URL url) {
        return new UrlReadable(url);
    }

    @NonNull
    public static Readable of(@NonNull File file) {
        ArgumentUtils.requireNonNull("file", file);
        return new FileReadable(file);
    }

    @NonNull
    public static Readable of(@NonNull Path path) {
        ArgumentUtils.requireNonNull("path", path);
        return new FileReadable(path.toFile());
    }
}

