/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.service.DefaultServiceDefinition;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.reflect.ClassUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SoftServiceLoader<S>
implements Iterable<ServiceDefinition<S>> {
    public static final String META_INF_SERVICES = "META-INF/services";
    private static final Map<String, StaticServiceLoader<?>> STATIC_SERVICES = StaticOptimizations.get(Optimizations.class).map(Optimizations::getServiceLoaders).orElse(Collections.emptyMap());
    private final Class<S> serviceType;
    private final ClassLoader classLoader;
    private final Map<String, ServiceDefinition<S>> loadedServices = new LinkedHashMap<String, ServiceDefinition<S>>();
    private final Iterator<ServiceDefinition<S>> unloadedServices;
    private final Predicate<String> condition;

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader) {
        this(serviceType, classLoader, name -> true);
    }

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader, Predicate<String> condition) {
        this.serviceType = serviceType;
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.unloadedServices = STATIC_SERVICES.containsKey(serviceType.getName()) ? new StaticServicesLoaderIterator() : new ServiceLoaderIterator();
        this.condition = condition == null ? name -> true : condition;
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service) {
        return SoftServiceLoader.load(service, SoftServiceLoader.class.getClassLoader());
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new SoftServiceLoader<S>(service, loader);
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader, Predicate<String> condition) {
        return new SoftServiceLoader<S>(service, loader, condition);
    }

    public Optional<ServiceDefinition<S>> first() {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        return Optional.empty();
    }

    public Optional<ServiceDefinition<S>> firstOr(String alternative, ClassLoader classLoader) {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        Class alternativeClass = ClassUtils.forName(alternative, classLoader).orElse(null);
        if (alternativeClass != null) {
            return Optional.of(this.createService(alternative, alternativeClass));
        }
        return Optional.empty();
    }

    public void collectAll(@NonNull Collection<S> values, @Nullable Predicate<S> predicate) {
        String name = this.serviceType.getName();
        StaticServiceLoader<?> serviceLoader = STATIC_SERVICES.get(name);
        if (serviceLoader != null) {
            this.collectStaticServices(values, predicate, serviceLoader);
        } else {
            this.collectDynamicServices(values, predicate, name);
        }
    }

    private void collectDynamicServices(Collection<S> values, Predicate<S> predicate, String name) {
        ServiceCollector<Object> collector = SoftServiceLoader.newCollector(name, this.condition, this.classLoader, className -> {
            try {
                Class<?> loadedClass = Class.forName(className, false, this.classLoader);
                Object result = loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (predicate != null && !predicate.test(result)) {
                    return null;
                }
                return result;
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException loadedClass) {
            }
            catch (Exception e) {
                throw new ServiceLoadingException(e);
            }
            return null;
        });
        collector.collect(values);
    }

    private void collectStaticServices(Collection<S> values, Predicate<S> predicate, StaticServiceLoader<S> loader) {
        values.addAll(loader.load(predicate));
    }

    public void collectAll(@NonNull Collection<S> values) {
        this.collectAll(values, null);
    }

    @Override
    @NonNull
    public Iterator<ServiceDefinition<S>> iterator() {
        return new Iterator<ServiceDefinition<S>>(){
            final Iterator<ServiceDefinition<S>> loaded;
            {
                this.loaded = SoftServiceLoader.this.loadedServices.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.loaded.hasNext()) {
                    return true;
                }
                return SoftServiceLoader.this.unloadedServices.hasNext();
            }

            @Override
            public ServiceDefinition<S> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.loaded.hasNext()) {
                    return this.loaded.next();
                }
                if (SoftServiceLoader.this.unloadedServices.hasNext()) {
                    ServiceDefinition nextService = (ServiceDefinition)SoftServiceLoader.this.unloadedServices.next();
                    SoftServiceLoader.this.loadedServices.put(nextService.getName(), nextService);
                    return nextService;
                }
                throw new ServiceConfigurationError("Bug in iterator");
            }
        };
    }

    @Deprecated
    protected ServiceDefinition<S> newService(String name, Optional<Class> loadedClass) {
        return new DefaultServiceDefinition(name, loadedClass.orElse(null));
    }

    private ServiceDefinition<S> createService(String name, Class<S> loadedClass) {
        return new DefaultServiceDefinition<S>(name, loadedClass);
    }

    private static Set<String> computeServiceTypeNames(URI uri, String path) {
        HashSet<String> typeNames = new HashSet<String>();
        IOUtils.eachFile(uri, path, currentPath -> {
            if (Files.isRegularFile(currentPath, new LinkOption[0])) {
                String typeName = currentPath.getFileName().toString();
                typeNames.add(typeName);
            }
        });
        return typeNames;
    }

    public static <S> ServiceCollector<S> newCollector(String serviceName, Predicate<String> lineCondition, ClassLoader classLoader, Function<String, S> transformer) {
        return new DefaultServiceCollector<S>(serviceName, lineCondition, classLoader, transformer);
    }

    private static class ServiceLoadingException
    extends RuntimeException {
        public ServiceLoadingException(String message, Throwable cause) {
            super(message, cause);
        }

        public ServiceLoadingException(Throwable cause) {
            super(cause);
        }
    }

    public static final class Optimizations {
        private final Map<String, StaticServiceLoader<?>> serviceLoaders;

        public Optimizations(Map<String, StaticServiceLoader<?>> serviceLoaders) {
            this.serviceLoaders = serviceLoaders;
        }

        public Map<String, StaticServiceLoader<?>> getServiceLoaders() {
            return this.serviceLoaders;
        }
    }

    public static interface StaticServiceLoader<S> {
        public Stream<StaticDefinition<S>> findAll(Predicate<String> var1);

        default public List<S> load(Predicate<S> predicate) {
            return this.load(n -> true, predicate);
        }

        default public List<S> load(Predicate<String> condition, Predicate<S> predicate) {
            return this.findAll(condition).map(ServiceDefinition::load).filter(s -> predicate == null || predicate.test(s)).collect(Collectors.toList());
        }
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void collect(Collection<S> var1);
    }

    private static final class ServiceInstanceLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final String className;
        private final Function<String, S> transformer;
        private S result;
        private Throwable throwable;

        public ServiceInstanceLoader(String className, Function<String, S> transformer) {
            this.className = className;
            this.transformer = transformer;
        }

        @Override
        protected void compute() {
            try {
                this.result = this.transformer.apply(this.className);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void collect(Collection<S> values) {
            if (this.throwable != null) {
                throw new ServiceLoadingException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null && !values.contains(this.result)) {
                values.add(this.result);
            }
        }
    }

    private static final class UrlServicesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final URL url;
        private final Predicate<String> lineCondition;
        private final Function<String, S> transformer;
        private final List<ServiceInstanceLoader<S>> tasks = new LinkedList<ServiceInstanceLoader<S>>();

        public UrlServicesLoader(URL url, Predicate<String> lineCondition, Function<String, S> transformer) {
            this.url = url;
            this.lineCondition = lineCondition;
            this.transformer = transformer;
        }

        @Override
        protected void compute() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0 || line.charAt(0) == '#' || !this.lineCondition.test(line)) continue;
                    int i = line.indexOf(35);
                    if (i > -1) {
                        line = line.substring(0, i);
                    }
                    ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(line, this.transformer);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException | UncheckedIOException exception) {
                // empty catch block
            }
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader<S> task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    private static final class MicronautMetaServicesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final URI uri;
        private final transient Function<String, S> transformer;
        private final List<ServiceInstanceLoader<S>> tasks = new LinkedList<ServiceInstanceLoader<S>>();
        private final String path;

        private MicronautMetaServicesLoader(URI uri, String path, Function<String, S> transformer) {
            this.uri = uri;
            this.path = path;
            this.transformer = transformer;
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader<S> task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }

        @Override
        protected void compute() {
            Set typeNames = SoftServiceLoader.computeServiceTypeNames(this.uri, this.path);
            for (String typeName : typeNames) {
                ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(typeName, this.transformer);
                this.tasks.add(task);
                task.fork();
            }
        }
    }

    private static class DefaultServiceCollector<S>
    extends RecursiveActionValuesCollector<S>
    implements ServiceCollector<S> {
        private final String serviceName;
        private final Predicate<String> lineCondition;
        private final ClassLoader classLoader;
        private final Function<String, S> transformer;
        private final List<RecursiveActionValuesCollector<S>> tasks = new LinkedList<RecursiveActionValuesCollector<S>>();

        public DefaultServiceCollector(String serviceName, Predicate<String> lineCondition, ClassLoader classLoader, Function<String, S> transformer) {
            this.serviceName = serviceName;
            this.lineCondition = lineCondition;
            this.classLoader = classLoader;
            this.transformer = transformer;
        }

        @Override
        protected void compute() {
            try {
                Enumeration<URL> serviceConfigs = this.classLoader.getResources("META-INF/services/" + this.serviceName);
                while (serviceConfigs.hasMoreElements()) {
                    URL url = serviceConfigs.nextElement();
                    UrlServicesLoader<S> task = new UrlServicesLoader<S>(url, this.lineCondition, this.transformer);
                    this.tasks.add(task);
                    task.fork();
                }
                String path = "META-INF/micronaut/" + this.serviceName;
                Enumeration<URL> micronautResources = this.classLoader.getResources(path);
                LinkedHashSet<URI> uniqueURIs = new LinkedHashSet<URI>();
                while (micronautResources.hasMoreElements()) {
                    URL url = micronautResources.nextElement();
                    URI uri = url.toURI();
                    uniqueURIs.add(uri);
                }
                for (URI uri : uniqueURIs) {
                    String uriStr = uri.toString();
                    if (uriStr.startsWith("resource:") && uriStr.contains("#")) continue;
                    MicronautMetaServicesLoader task = new MicronautMetaServicesLoader(uri, path, this.transformer);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + this.serviceName, e);
            }
        }

        @Override
        public void collect(Collection<S> values) {
            ForkJoinPool.commonPool().invoke(this);
            for (RecursiveActionValuesCollector<S> task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    public static interface ServiceCollector<S> {
        public void collect(Collection<S> var1);

        default public void collect(Consumer<? super S> consumer) {
            ArrayList values = new ArrayList();
            this.collect(values);
            values.forEach(e -> {
                if (e != null) {
                    consumer.accept((Object)e);
                }
            });
        }
    }

    private final class ServiceLoaderIterator
    implements Iterator<ServiceDefinition<S>> {
        private Enumeration<URL> serviceConfigs = null;
        private Iterator<String> unprocessed = null;

        private ServiceLoaderIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.serviceConfigs == null) {
                String name = SoftServiceLoader.this.serviceType.getName();
                try {
                    this.serviceConfigs = SoftServiceLoader.this.classLoader.getResources("META-INF/services/" + name);
                }
                catch (IOException e) {
                    throw new ServiceConfigurationError("Failed to load resources for service: " + name, e);
                }
            }
            while (this.unprocessed == null || !this.unprocessed.hasNext()) {
                if (!this.serviceConfigs.hasMoreElements()) {
                    return false;
                }
                URL url = this.serviceConfigs.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    Throwable throwable = null;
                    try {
                        String line;
                        LinkedList<String> lines = new LinkedList<String>();
                        while ((line = reader.readLine()) != null) {
                            if (line.length() == 0 || line.charAt(0) == '#' || !SoftServiceLoader.this.condition.test(line)) continue;
                            int i = line.indexOf(35);
                            if (i > -1) {
                                line = line.substring(0, i);
                            }
                            lines.add(line);
                        }
                        this.unprocessed = lines.iterator();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException | UncheckedIOException exception) {}
            }
            return this.unprocessed.hasNext();
        }

        @Override
        public ServiceDefinition<S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String nextName = this.unprocessed.next();
            try {
                Class<?> loadedClass = Class.forName(nextName, false, SoftServiceLoader.this.classLoader);
                return SoftServiceLoader.this.createService(nextName, loadedClass);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                return SoftServiceLoader.this.createService(nextName, null);
            }
        }
    }

    private final class StaticServicesLoaderIterator
    implements Iterator<ServiceDefinition<S>> {
        Iterator<StaticDefinition<S>> iterator;

        private StaticServicesLoaderIterator() {
        }

        private void ensureIterator() {
            if (this.iterator == null) {
                StaticServiceLoader staticServiceLoader = (StaticServiceLoader)STATIC_SERVICES.get(SoftServiceLoader.this.serviceType.getName());
                this.iterator = staticServiceLoader.findAll(s -> SoftServiceLoader.this.condition == null || SoftServiceLoader.this.condition.test(s.getClass().getName())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.ensureIterator();
            return this.iterator.hasNext();
        }

        @Override
        public ServiceDefinition<S> next() {
            this.ensureIterator();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }
    }

    public static final class StaticDefinition<S>
    implements ServiceDefinition<S> {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
        private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
        private final String name;
        private final Supplier<S> value;

        private StaticDefinition(String name, Supplier<S> value) {
            this.name = name;
            this.value = value;
        }

        public static <S> StaticDefinition<S> of(String name, Class<S> value) {
            return new StaticDefinition<Object>(name, () -> StaticDefinition.doCreate(value));
        }

        public static <S> StaticDefinition<S> of(String name, Supplier<S> value) {
            return new StaticDefinition<S>(name, value);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public S load() {
            return this.value.get();
        }

        private static <S> S doCreate(Class<S> clazz) {
            try {
                return (S)LOOKUP.findConstructor(clazz, VOID_TYPE).invoke();
            }
            catch (Throwable e) {
                throw new ServiceLoadingException(e);
            }
        }
    }
}

