/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@FunctionalInterface
public interface ArgumentBinder<T, S> {
    public BindingResult<T> bind(ArgumentConversionContext<T> var1, S var2);

    public static interface BindingResult<T> {
        public static final BindingResult EMPTY = Optional::empty;
        public static final BindingResult UNSATISFIED = new BindingResult(){

            public Optional getValue() {
                return Optional.empty();
            }

            @Override
            public boolean isSatisfied() {
                return false;
            }
        };

        public Optional<T> getValue();

        default public List<ConversionError> getConversionErrors() {
            return Collections.emptyList();
        }

        default public boolean isSatisfied() {
            return this.getConversionErrors().isEmpty();
        }

        default public boolean isPresentAndSatisfied() {
            return this.isSatisfied() && this.getValue().isPresent();
        }

        default public T get() {
            return this.getValue().get();
        }

        public static <R> BindingResult<R> empty() {
            return EMPTY;
        }

        public static <R> BindingResult<R> unsatisfied() {
            return UNSATISFIED;
        }
    }
}

