/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.expressions;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public record EvaluatedExpressionReference(@NonNull Object annotationValue, @NonNull String annotationName, @NonNull String annotationMember, @NonNull String expressionClassName) {
    public static final String EXPR_SUFFIX = "$Expr";
    private static final Map<String, Integer> CLASS_NAME_INDEXES = new ConcurrentHashMap<String, Integer>();

    public static Integer nextIndex(String className) {
        if (CLASS_NAME_INDEXES.containsKey(className)) {
            return CLASS_NAME_INDEXES.merge(className, 1, Integer::sum);
        }
        CLASS_NAME_INDEXES.put(className, 0);
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedExpressionReference that = (EvaluatedExpressionReference)o;
        return this.expressionClassName.equals(that.expressionClassName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expressionClassName);
    }
}

