/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.converters;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.format.FormattingTypeConverter;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MultiValuesConverterFactory {
    public static final String FORMAT_CSV = "csv";
    public static final String FORMAT_SSV = "ssv";
    public static final String FORMAT_PIPES = "pipes";
    public static final String FORMAT_MULTI = "multi";
    public static final String FORMAT_DEEP_OBJECT = "deepobject";
    private static final Character CSV_DELIMITER = Character.valueOf(',');
    private static final Character SSV_DELIMITER = Character.valueOf(' ');
    private static final Character PIPES_DELIMITER = Character.valueOf('|');

    private static String normalizeFormatName(String value) {
        return value.toLowerCase().replaceAll("[-_]", "");
    }

    private static Map<String, String> getSeparatedMapParameters(ConvertibleMultiValues<String> parameters, String name, String defaultValue, Character delimiter) {
        List<String> paramValues = parameters.getAll(name);
        if (paramValues.isEmpty() && defaultValue != null) {
            paramValues.add(defaultValue);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (String value : paramValues) {
            List<String> delimited = MultiValuesConverterFactory.splitByDelimiter(value, delimiter);
            for (int i = 1; i < delimited.size(); i += 2) {
                values.put(delimited.get(i - 1), delimited.get(i));
            }
        }
        return values;
    }

    private static Map<String, String> getMultiMapParameters(ConvertibleMultiValues<String> parameters) {
        return parameters.asMap().entrySet().stream().filter(v -> !((List)v.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, v -> (String)((List)v.getValue()).get(0)));
    }

    private static Map<String, String> getDeepObjectMapParameters(ConvertibleMultiValues<String> parameters, String name) {
        Map paramValues = parameters.asMap();
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry param : paramValues.entrySet()) {
            String key = param.getKey();
            if (!key.startsWith(name) || key.length() <= name.length() || key.charAt(name.length()) != '[' || key.charAt(key.length() - 1) != ']' || ((List)param.getValue()).isEmpty()) continue;
            String mapKey = key.substring(name.length() + 1, key.length() - 1);
            values.put(mapKey, (String)((List)param.getValue()).get(0));
        }
        return values;
    }

    private static List<String> splitByDelimiter(String value, Character delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int startI = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != delimiter.charValue()) continue;
            result.add(value.substring(startI, i));
            startI = i + 1;
        }
        if (!value.isEmpty()) {
            result.add(value.substring(startI));
        }
        return result;
    }

    private static String joinStrings(Iterable<String> strings, Character delimiter) {
        if (strings == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String value : strings) {
            if (value == null) continue;
            if (!first) {
                builder.append(delimiter);
            } else {
                first = false;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static class ObjectToMultiValuesConverter
    extends AbstractConverterToMultiValues<Object> {
        public ObjectToMultiValuesConverter(ConversionService conversionService) {
            super(conversionService);
        }

        private void processValues(ArgumentConversionContext<Object> context, Object object, BiConsumer<String, String> consumer) {
            BeanWrapper<Object> beanWrapper;
            try {
                beanWrapper = BeanWrapper.getWrapper(object);
            }
            catch (IntrospectionException e) {
                context.reject(object, e);
                return;
            }
            for (BeanProperty<Object, Object> property : beanWrapper.getBeanProperties()) {
                String key = property.stringValue(Bindable.class).orElse(property.getName());
                ArgumentConversionContext<String> conversionContext = ConversionContext.STRING.with(property.getAnnotationMetadata());
                this.conversionService.convert(property.get(object), conversionContext).ifPresent(value -> consumer.accept(key, (String)value));
            }
        }

        @Override
        protected void addSeparatedValues(ArgumentConversionContext<Object> context, String name, Object object, MutableConvertibleMultiValuesMap<String> parameters, Character delimiter) {
            ArrayList<String> values = new ArrayList<String>();
            this.processValues(context, object, (k, v) -> {
                values.add((String)k);
                values.add((String)v);
            });
            parameters.add(name, MultiValuesConverterFactory.joinStrings(values, delimiter));
        }

        @Override
        protected void addMutliValues(ArgumentConversionContext<Object> context, String name, Object object, MutableConvertibleMultiValuesMap<String> parameters) {
            this.processValues(context, object, parameters::add);
        }

        @Override
        protected void addDeepObjectValues(ArgumentConversionContext<Object> context, String name, Object object, MutableConvertibleMultiValuesMap<String> parameters) {
            this.processValues(context, object, (k, v) -> parameters.add(name + "[" + k + "]", (String)v));
        }
    }

    public static class MapToMultiValuesConverter
    extends AbstractConverterToMultiValues<Map> {
        public MapToMultiValuesConverter(ConversionService conversionService) {
            super(conversionService);
        }

        private void processValues(ArgumentConversionContext<Object> context, Map object, BiConsumer<String, String> consumer) {
            Argument[] typeParameters = context.getTypeParameters();
            ArgumentConversionContext<String> keyConversionContext = ConversionContext.STRING.with(typeParameters.length > 0 ? typeParameters[0].getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA);
            ArgumentConversionContext<String> valueConversionContext = ConversionContext.STRING.with(typeParameters.length > 1 ? typeParameters[1].getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA);
            for (Map.Entry value : object.entrySet()) {
                this.conversionService.convert(value.getValue(), valueConversionContext).ifPresent(v -> this.conversionService.convert(value.getKey(), keyConversionContext).ifPresent(k -> consumer.accept((String)k, (String)v)));
            }
        }

        @Override
        protected void addSeparatedValues(ArgumentConversionContext<Object> context, String name, Map object, MutableConvertibleMultiValuesMap<String> parameters, Character delimiter) {
            ArrayList<String> values = new ArrayList<String>();
            this.processValues(context, object, (k, v) -> {
                values.add((String)k);
                values.add((String)v);
            });
            parameters.add(name, MultiValuesConverterFactory.joinStrings(values, delimiter));
        }

        @Override
        protected void addMutliValues(ArgumentConversionContext<Object> context, String name, Map object, MutableConvertibleMultiValuesMap<String> parameters) {
            this.processValues(context, object, parameters::add);
        }

        @Override
        protected void addDeepObjectValues(ArgumentConversionContext<Object> context, String name, Map object, MutableConvertibleMultiValuesMap<String> parameters) {
            this.processValues(context, object, (k, v) -> parameters.add(name + "[" + k + "]", (String)v));
        }
    }

    public static class IterableToMultiValuesConverter
    extends AbstractConverterToMultiValues<Iterable> {
        public IterableToMultiValuesConverter(ConversionService conversionService) {
            super(conversionService);
        }

        private void processValues(ArgumentConversionContext<Object> context, Iterable object, Consumer<String> consumer) {
            ArgumentConversionContext<String> conversionContext = ConversionContext.STRING.with(context.getFirstTypeVariable().map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA));
            for (Object value : object) {
                this.conversionService.convert(value, conversionContext).ifPresent(v -> consumer.accept((String)v));
            }
        }

        @Override
        protected void addSeparatedValues(ArgumentConversionContext<Object> context, String name, Iterable object, MutableConvertibleMultiValuesMap<String> parameters, Character delimiter) {
            ArrayList<String> strings = new ArrayList<String>();
            this.processValues(context, object, v -> strings.add((String)v));
            parameters.add(name, MultiValuesConverterFactory.joinStrings(strings, delimiter));
        }

        @Override
        protected void addMutliValues(ArgumentConversionContext<Object> context, String name, Iterable object, MutableConvertibleMultiValuesMap<String> parameters) {
            this.processValues(context, object, v -> parameters.add(name, (String)v));
        }

        @Override
        protected void addDeepObjectValues(ArgumentConversionContext<Object> context, String name, Iterable object, MutableConvertibleMultiValuesMap<String> parameters) {
            ArgumentConversionContext<String> conversionContext = ConversionContext.STRING.with(context.getFirstTypeVariable().map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA));
            int i = 0;
            for (Object value : object) {
                String stringValue = this.conversionService.convert(value, conversionContext).orElse("");
                parameters.add(name + "[" + i + "]", stringValue);
                ++i;
            }
        }
    }

    public static abstract class AbstractConverterToMultiValues<T>
    implements FormattingTypeConverter<T, ConvertibleMultiValues, Format> {
        protected ConversionService conversionService;

        public AbstractConverterToMultiValues(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        @Override
        public Optional<ConvertibleMultiValues> convert(T object, Class<ConvertibleMultiValues> targetType, ConversionContext conversionContext) {
            if (!targetType.isAssignableFrom(MutableConvertibleMultiValuesMap.class) || !(conversionContext instanceof ArgumentConversionContext)) {
                return Optional.empty();
            }
            ArgumentConversionContext context = (ArgumentConversionContext)conversionContext;
            String format = conversionContext.getAnnotationMetadata().stringValue(Format.class).orElse(null);
            if (format == null) {
                return Optional.empty();
            }
            String name = conversionContext.getAnnotationMetadata().stringValue(Bindable.class).orElse(context.getArgument().getName());
            MutableConvertibleMultiValuesMap<String> parameters = new MutableConvertibleMultiValuesMap<String>();
            if (object == null) {
                return Optional.of(parameters);
            }
            switch (MultiValuesConverterFactory.normalizeFormatName(format)) {
                case "csv": {
                    this.addSeparatedValues(context, name, object, parameters, CSV_DELIMITER);
                    break;
                }
                case "ssv": {
                    this.addSeparatedValues(context, name, object, parameters, SSV_DELIMITER);
                    break;
                }
                case "pipes": {
                    this.addSeparatedValues(context, name, object, parameters, PIPES_DELIMITER);
                    break;
                }
                case "multi": {
                    this.addMutliValues(context, name, object, parameters);
                    break;
                }
                case "deepobject": {
                    this.addDeepObjectValues(context, name, object, parameters);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(parameters);
        }

        protected abstract void addSeparatedValues(ArgumentConversionContext<Object> var1, String var2, T var3, MutableConvertibleMultiValuesMap<String> var4, Character var5);

        protected abstract void addMutliValues(ArgumentConversionContext<Object> var1, String var2, T var3, MutableConvertibleMultiValuesMap<String> var4);

        protected abstract void addDeepObjectValues(ArgumentConversionContext<Object> var1, String var2, T var3, MutableConvertibleMultiValuesMap<String> var4);

        @Override
        public Class<Format> annotationType() {
            return Format.class;
        }
    }

    public static class MultiValuesToObjectConverter
    extends AbstractConverterFromMultiValues<Object> {
        public MultiValuesToObjectConverter(ConversionService conversionService) {
            super(conversionService);
        }

        @Override
        protected Optional<Object> retrieveSeparatedValue(ArgumentConversionContext<Object> conversionContext, String name, ConvertibleMultiValues<String> parameters, String defaultValue, Character delimiter) {
            Map<String, String> values = MultiValuesConverterFactory.getSeparatedMapParameters(parameters, name, defaultValue, delimiter);
            return this.convertValues(conversionContext, values);
        }

        @Override
        protected Optional<Object> retrieveMultiValue(ArgumentConversionContext<Object> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            Map<String, String> values = MultiValuesConverterFactory.getMultiMapParameters(parameters);
            return this.convertValues(conversionContext, values);
        }

        @Override
        protected Optional<Object> retrieveDeepObjectValue(ArgumentConversionContext<Object> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            Map<String, String> values = MultiValuesConverterFactory.getDeepObjectMapParameters(parameters, name);
            return this.convertValues(conversionContext, values);
        }

        private Optional<Object> convertValues(ArgumentConversionContext<Object> context, Map<String, String> values) {
            try {
                BeanIntrospection introspection = BeanIntrospection.getIntrospection(context.getArgument().getType());
                BeanConstructor constructor = introspection.getConstructor();
                Argument<?>[] constructorArguments = constructor.getArguments();
                Object[] constructorParameters = new Object[constructorArguments.length];
                for (int i = 0; i < constructorArguments.length; ++i) {
                    Argument<?> argument = constructorArguments[i];
                    String name = argument.getAnnotationMetadata().stringValue(Bindable.class).orElse(argument.getName());
                    constructorParameters[i] = this.conversionService.convert((Object)values.get(name), ConversionContext.of(argument)).orElse(null);
                }
                Object result = constructor.instantiate(constructorParameters);
                BeanWrapper wrapper = BeanWrapper.getWrapper(result);
                for (BeanProperty property : wrapper.getBeanProperties()) {
                    String name = property.getName();
                    if (property.isReadOnly() || !values.containsKey(name)) continue;
                    this.conversionService.convert((Object)values.get(name), ConversionContext.of(property.asArgument())).ifPresent(v -> property.set(result, v));
                }
                return Optional.of(result);
            }
            catch (IntrospectionException e) {
                context.reject(values, e);
                return Optional.empty();
            }
        }
    }

    public static class MultiValuesToMapConverter
    extends AbstractConverterFromMultiValues<Map> {
        public MultiValuesToMapConverter(ConversionService conversionService) {
            super(conversionService);
        }

        @Override
        protected Optional<Map> retrieveSeparatedValue(ArgumentConversionContext<Map> conversionContext, String name, ConvertibleMultiValues<String> parameters, String defaultValue, Character delimiter) {
            Map<String, String> values = MultiValuesConverterFactory.getSeparatedMapParameters(parameters, name, defaultValue, delimiter);
            return this.convertValues(conversionContext, values);
        }

        @Override
        protected Optional<Map> retrieveMultiValue(ArgumentConversionContext<Map> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            Map<String, String> values = MultiValuesConverterFactory.getMultiMapParameters(parameters);
            return this.convertValues(conversionContext, values);
        }

        @Override
        protected Optional<Map> retrieveDeepObjectValue(ArgumentConversionContext<Map> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            Map<String, String> values = MultiValuesConverterFactory.getDeepObjectMapParameters(parameters, name);
            return this.convertValues(conversionContext, values);
        }

        private Optional<Map> convertValues(ArgumentConversionContext<Map> context, Map<String, String> values) {
            Map<String, String> convertedValues;
            Argument valueArgument;
            if (!context.getArgument().getType().isAssignableFrom(values.getClass())) {
                return Optional.empty();
            }
            Argument[] typeArguments = context.getTypeParameters();
            Argument keyArgument = typeArguments.length > 0 ? typeArguments[0] : Argument.OBJECT_ARGUMENT;
            Argument argument = valueArgument = typeArguments.length > 1 ? typeArguments[1] : Argument.OBJECT_ARGUMENT;
            if (keyArgument.getType().isAssignableFrom(String.class) && valueArgument.getType().isAssignableFrom(String.class)) {
                convertedValues = values;
            } else {
                ArgumentConversionContext keyContext = ConversionContext.of(keyArgument);
                ArgumentConversionContext valueContext = ConversionContext.of(valueArgument);
                convertedValues = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    Object key;
                    Object value = this.conversionService.convert((Object)entry.getValue(), valueContext).orElse(null);
                    if (value == null || (key = this.conversionService.convert((Object)entry.getKey(), keyContext).orElse(null)) == null) continue;
                    convertedValues.put((String)key, (String)value);
                }
            }
            return Optional.of(convertedValues);
        }
    }

    public static class MultiValuesToIterableConverter
    extends AbstractConverterFromMultiValues<Iterable> {
        public MultiValuesToIterableConverter(ConversionService conversionService) {
            super(conversionService);
        }

        @Override
        protected Optional<Iterable> retrieveSeparatedValue(ArgumentConversionContext<Iterable> conversionContext, String name, ConvertibleMultiValues<String> parameters, String defaultValue, Character delimiter) {
            List<String> values = parameters.getAll(name);
            if (values.isEmpty() && defaultValue != null) {
                values.add(defaultValue);
            }
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (String value : values) {
                result.addAll(MultiValuesConverterFactory.splitByDelimiter(value, delimiter));
            }
            return this.convertValues(conversionContext, result);
        }

        @Override
        protected Optional<Iterable> retrieveMultiValue(ArgumentConversionContext<Iterable> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            List<String> values = parameters.getAll(name);
            return this.convertValues(conversionContext, values);
        }

        @Override
        protected Optional<Iterable> retrieveDeepObjectValue(ArgumentConversionContext<Iterable> conversionContext, String name, ConvertibleMultiValues<String> parameters) {
            String key;
            String value;
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while ((value = parameters.get(key = name + "[" + i + "]")) != null) {
                values.add(value);
                ++i;
            }
            return this.convertValues(conversionContext, values);
        }

        private Optional<Iterable> convertValues(ArgumentConversionContext<Iterable> context, List<String> values) {
            List<String> convertedValues;
            Argument<Object> typeArgument = context.getArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (typeArgument.getType().isAssignableFrom(String.class)) {
                convertedValues = values;
            } else {
                ArgumentConversionContext<Object> argumentConversionContext = ConversionContext.of(typeArgument);
                convertedValues = new ArrayList<String>(values.size());
                for (String value : values) {
                    this.conversionService.convert((Object)value, argumentConversionContext).ifPresent(convertedValues::add);
                }
            }
            return CollectionUtils.convertCollection(context.getArgument().getType(), convertedValues);
        }
    }

    private static abstract class AbstractConverterFromMultiValues<T>
    implements FormattingTypeConverter<ConvertibleMultiValues, T, Format> {
        protected ConversionService conversionService;

        AbstractConverterFromMultiValues(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        @Override
        public Optional<T> convert(ConvertibleMultiValues object, Class<T> targetType, ConversionContext conversionContext) {
            if (!(conversionContext instanceof ArgumentConversionContext)) {
                return Optional.empty();
            }
            ConvertibleMultiValues parameters = object;
            ArgumentConversionContext context = (ArgumentConversionContext)conversionContext;
            String format = conversionContext.getAnnotationMetadata().stringValue(Format.class).orElse(null);
            if (format == null) {
                return Optional.empty();
            }
            String name = conversionContext.getAnnotationMetadata().stringValue(Bindable.class).orElse(context.getArgument().getName());
            String defaultValue = conversionContext.getAnnotationMetadata().stringValue(Bindable.class, "defaultValue").orElse(null);
            switch (MultiValuesConverterFactory.normalizeFormatName(format)) {
                case "csv": {
                    return this.retrieveSeparatedValue(context, name, parameters, defaultValue, CSV_DELIMITER);
                }
                case "ssv": {
                    return this.retrieveSeparatedValue(context, name, parameters, defaultValue, SSV_DELIMITER);
                }
                case "pipes": {
                    return this.retrieveSeparatedValue(context, name, parameters, defaultValue, PIPES_DELIMITER);
                }
                case "multi": {
                    return this.retrieveMultiValue(context, name, parameters);
                }
                case "deepobject": {
                    return this.retrieveDeepObjectValue(context, name, parameters);
                }
            }
            return Optional.empty();
        }

        protected abstract Optional<T> retrieveSeparatedValue(ArgumentConversionContext<T> var1, String var2, ConvertibleMultiValues<String> var3, @Nullable String var4, Character var5);

        protected abstract Optional<T> retrieveMultiValue(ArgumentConversionContext<T> var1, String var2, ConvertibleMultiValues<String> var3);

        protected abstract Optional<T> retrieveDeepObjectValue(ArgumentConversionContext<T> var1, String var2, ConvertibleMultiValues<String> var3);

        @Override
        public Class<Format> annotationType() {
            return Format.class;
        }
    }
}

