/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationDefaultValuesProvider;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.AnnotationValueResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.expressions.EvaluatedExpression;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AnnotationValue<A extends Annotation>
implements AnnotationValueResolver {
    private final String annotationName;
    private final ConvertibleValues<Object> convertibleValues;
    private final Map<CharSequence, Object> values;
    @Nullable
    private Map<CharSequence, Object> defaultValues;
    @Nullable
    private final Function<Object, Object> valueMapper;
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final List<AnnotationValue<?>> stereotypes;
    @Nullable
    private final AnnotationDefaultValuesProvider defaultValuesProvider;

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values) {
        this(annotationName, values, null, RetentionPolicy.RUNTIME);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        this(annotationName, values, null, retentionPolicy, null);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy, List<AnnotationValue<?>> stereotypes) {
        this(annotationName, values, null, retentionPolicy, stereotypes);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<CharSequence, Object> defaultValues) {
        this(annotationName, values, defaultValues, RetentionPolicy.RUNTIME, null);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, AnnotationDefaultValuesProvider defaultValuesProvider) {
        this(annotationName, values, null, RetentionPolicy.RUNTIME, null, defaultValuesProvider);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<CharSequence, Object> defaultValues, RetentionPolicy retentionPolicy) {
        this(annotationName, values, defaultValues, retentionPolicy, null);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<CharSequence, Object> defaultValues, RetentionPolicy retentionPolicy, List<AnnotationValue<?>> stereotypes) {
        this(annotationName, values, defaultValues, retentionPolicy, stereotypes, null);
    }

    @Internal
    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<CharSequence, Object> defaultValues, RetentionPolicy retentionPolicy, List<AnnotationValue<?>> stereotypes, AnnotationDefaultValuesProvider defaultValuesProvider) {
        this.annotationName = annotationName;
        this.convertibleValues = this.newConvertibleValues(values);
        this.values = values;
        this.defaultValues = defaultValues;
        this.valueMapper = null;
        this.retentionPolicy = retentionPolicy != null ? retentionPolicy : RetentionPolicy.RUNTIME;
        this.stereotypes = stereotypes;
        this.defaultValuesProvider = defaultValuesProvider;
    }

    @Internal
    public AnnotationValue(String annotationName) {
        this(annotationName, Collections.emptyMap(), Collections.emptyMap());
    }

    @Internal
    public AnnotationValue(String annotationName, ConvertibleValues<Object> convertibleValues) {
        this.annotationName = annotationName;
        this.convertibleValues = convertibleValues;
        this.values = new LinkedHashMap<String, Object>(convertibleValues.asMap());
        this.defaultValues = null;
        this.valueMapper = null;
        this.retentionPolicy = RetentionPolicy.RUNTIME;
        this.stereotypes = null;
        this.defaultValuesProvider = null;
    }

    @Internal
    public AnnotationValue(AnnotationValue<A> target, Map<CharSequence, Object> defaultValues, ConvertibleValues<Object> convertibleValues, Function<Object, Object> valueMapper) {
        this.annotationName = target.annotationName;
        this.defaultValues = defaultValues;
        this.values = target.values;
        this.convertibleValues = convertibleValues;
        this.valueMapper = valueMapper;
        this.retentionPolicy = RetentionPolicy.RUNTIME;
        this.stereotypes = target.stereotypes;
        this.defaultValuesProvider = null;
    }

    @Nullable
    protected Function<Object, Object> getValueMapper() {
        return this.valueMapper;
    }

    public AnnotationValueBuilder<A> mutate() {
        return AnnotationValue.builder(this);
    }

    @NonNull
    public final RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public List<AnnotationValue<?>> getStereotypes() {
        return this.stereotypes;
    }

    @Nullable
    public Map<CharSequence, Object> getDefaultValues() {
        if (this.defaultValues == null && this.defaultValuesProvider != null) {
            this.defaultValues = this.defaultValuesProvider.provide(this.annotationName);
        }
        return this.defaultValues;
    }

    @NonNull
    public Map<String, String> getProperties(@NonNull String member) {
        return this.getProperties(member, "name");
    }

    public Map<String, String> getProperties(@NonNull String member, String keyMember) {
        ArgumentUtils.requireNonNull("keyMember", keyMember);
        if (StringUtils.isEmpty(member)) {
            return Collections.emptyMap();
        }
        List values = this.getAnnotations(member);
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        LinkedHashMap props = CollectionUtils.newLinkedHashMap(values.size());
        for (AnnotationValue av : values) {
            String name = av.stringValue(keyMember).orElse(null);
            if (!StringUtils.isNotEmpty(name)) continue;
            av.stringValue("value", this.valueMapper).ifPresent(v -> props.put(name, v));
        }
        return Collections.unmodifiableMap(props);
    }

    @Override
    public <E extends Enum> Optional<E> enumValue(@NonNull String member, @NonNull Class<E> enumType) {
        return this.enumValue(member, enumType, this.valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull String member, @NonNull Class<E> enumType, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("enumType", enumType);
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o != null) {
            return AnnotationValue.convertToEnum(enumType, o);
        }
        return Optional.empty();
    }

    @Override
    public <E extends Enum> E[] enumValues(@NonNull String member, @NonNull Class<E> enumType) {
        ArgumentUtils.requireNonNull("enumType", enumType);
        if (StringUtils.isEmpty(member)) {
            return (Enum[])Array.newInstance(enumType, 0);
        }
        Object rawValue = this.values.get(member);
        return AnnotationValue.resolveEnumValues(enumType, (Object)rawValue);
    }

    @Override
    @NonNull
    public Optional<Class<?>> classValue() {
        return this.classValue("value");
    }

    @Override
    public Optional<Class<?>> classValue(@NonNull String member) {
        return this.classValue(member, this.valueMapper);
    }

    @Override
    public <T> Optional<Class<? extends T>> classValue(@NonNull String member, @NonNull Class<T> requiredType) {
        Class t;
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, this.valueMapper);
        if (o instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
            Class t2 = annotationClassValue.getType().orElse(null);
            if (t2 != null && requiredType.isAssignableFrom(t2)) {
                return Optional.of(t2);
            }
            return Optional.empty();
        }
        if (o instanceof Class) {
            Class t3 = (Class)o;
            if (requiredType.isAssignableFrom(t3)) {
                return Optional.of(t3);
            }
            return Optional.empty();
        }
        if (o != null && (t = (Class)ClassUtils.forName(o.toString(), this.getClass().getClassLoader()).orElse(null)) != null && requiredType.isAssignableFrom(t)) {
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public Optional<Class<?>> classValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
            return annotationClassValue.getType();
        }
        if (o instanceof Class) {
            Class aClass = (Class)o;
            return Optional.of(aClass);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull String member) {
        Function<Object, Object> valueMapper = this.valueMapper;
        return this.stringValues(member, valueMapper);
    }

    @Override
    public boolean[] booleanValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_BOOLEAN_ARRAY;
        }
        if (v instanceof boolean[]) {
            boolean[] booleans = (boolean[])v;
            return booleans;
        }
        if (v instanceof Boolean) {
            Boolean aBoolean = (Boolean)v;
            return new boolean[]{aBoolean};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] booleans = new boolean[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            booleans[i] = Boolean.parseBoolean((String)string);
        }
        return booleans;
    }

    @Override
    public byte[] byteValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (v instanceof byte[]) {
            byte[] bytes = (byte[])v;
            return bytes;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new byte[]{number.byteValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            bytes[i] = Byte.parseByte((String)string);
        }
        return bytes;
    }

    @Override
    public char[] charValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        if (v instanceof char[]) {
            char[] chars = (char[])v;
            return chars;
        }
        if (v instanceof Character[]) {
            Character[] v2 = (Character[])v;
            char[] chars = new char[v2.length];
            for (int i = 0; i < v2.length; ++i) {
                Character character = v2[i];
                chars[i] = character.charValue();
            }
            return chars;
        }
        if (v instanceof Character) {
            Character character = (Character)v;
            return new char[]{character.charValue()};
        }
        return ArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    public int[] intValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (v instanceof int[]) {
            int[] ints = (int[])v;
            return ints;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new int[]{number.intValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] integers = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            integers[i] = Integer.parseInt((String)string);
        }
        return integers;
    }

    @Override
    public double[] doubleValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_DOUBLE_ARRAY;
        }
        if (v instanceof double[]) {
            double[] doubles = (double[])v;
            return doubles;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new double[]{number.doubleValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = new double[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            doubles[i] = Double.parseDouble((String)string);
        }
        return doubles;
    }

    @Override
    public long[] longValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        if (v instanceof long[]) {
            long[] longs = (long[])v;
            return longs;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new long[]{number.longValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] longs = new long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            longs[i] = Long.parseLong((String)string);
        }
        return longs;
    }

    @Override
    public float[] floatValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_FLOAT_ARRAY;
        }
        if (v instanceof float[]) {
            float[] floats = (float[])v;
            return floats;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new float[]{number.floatValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_FLOAT_ARRAY;
        }
        float[] floats = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            floats[i] = Float.parseFloat((String)string);
        }
        return floats;
    }

    @Override
    public short[] shortValues(String member) {
        Object v = this.values.get(member);
        if (v == null) {
            return ArrayUtils.EMPTY_SHORT_ARRAY;
        }
        if (v instanceof short[]) {
            short[] shorts = (short[])v;
            return shorts;
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            return new short[]{number.shortValue()};
        }
        Object[] strings = AnnotationValue.resolveStringValues(v, this.valueMapper);
        if (ArrayUtils.isEmpty(strings)) {
            return ArrayUtils.EMPTY_SHORT_ARRAY;
        }
        short[] shorts = new short[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Object string = strings[i];
            shorts[i] = Short.parseShort((String)string);
        }
        return shorts;
    }

    public String[] stringValues(@NonNull String member, Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Object o = this.values.get(member);
        String[] strs = AnnotationValue.resolveStringValues(o, valueMapper);
        if (strs != null) {
            return strs;
        }
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public Class<?>[] classValues(@NonNull String member) {
        if (StringUtils.isEmpty(member)) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Object o = this.values.get(member);
        Class<?>[] type = AnnotationValue.resolveClassValues(o);
        if (type != null) {
            return type;
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    @Override
    @NonNull
    public AnnotationClassValue<?>[] annotationClassValues(@NonNull String member) {
        if (StringUtils.isEmpty(member)) {
            return AnnotationClassValue.EMPTY_ARRAY;
        }
        Object o = this.values.get(member);
        if (o instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
            return new AnnotationClassValue[]{annotationClassValue};
        }
        if (o instanceof AnnotationClassValue[]) {
            AnnotationClassValue[] annotationClassValues = (AnnotationClassValue[])o;
            return annotationClassValues;
        }
        return AnnotationClassValue.EMPTY_ARRAY;
    }

    @Override
    public Optional<AnnotationClassValue<?>> annotationClassValue(@NonNull String member) {
        AnnotationClassValue[] annotationClassValues;
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.values.get(member);
        if (o instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
            return Optional.of(annotationClassValue);
        }
        if (o instanceof AnnotationClassValue[] && (annotationClassValues = (AnnotationClassValue[])o).length > 0) {
            return Optional.of(annotationClassValues[0]);
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt intValue(@NonNull String member) {
        return this.intValue(member, this.valueMapper);
    }

    public OptionalInt intValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return OptionalInt.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return OptionalInt.of(number.intValue());
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                return OptionalInt.of(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return OptionalInt.empty();
            }
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return OptionalInt.of(Integer.parseInt(charSequence.toString()));
            }
            catch (NumberFormatException e) {
                return OptionalInt.empty();
            }
        }
        return OptionalInt.empty();
    }

    @Override
    public Optional<Byte> byteValue(String member) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, this.valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return Optional.of(number.byteValue());
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return Optional.of(Byte.parseByte(charSequence.toString()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Character> charValue(String member) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, this.valueMapper);
        if (o instanceof Character) {
            Character character = (Character)o;
            return Optional.of(character);
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt intValue() {
        return this.intValue("value");
    }

    @Override
    public OptionalLong longValue(@NonNull String member) {
        return this.longValue(member, this.valueMapper);
    }

    public OptionalLong longValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return OptionalLong.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return OptionalLong.of(number.longValue());
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                return OptionalLong.of(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                return OptionalLong.empty();
            }
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return OptionalLong.of(Long.parseLong(charSequence.toString()));
            }
            catch (NumberFormatException e) {
                return OptionalLong.empty();
            }
        }
        return OptionalLong.empty();
    }

    @Override
    public Optional<Short> shortValue(@NonNull String member) {
        return this.shortValue(member, this.valueMapper);
    }

    public Optional<Short> shortValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return Optional.of(number.shortValue());
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return Optional.of(Short.parseShort(charSequence.toString()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Boolean> booleanValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Boolean) {
            Boolean aBoolean = (Boolean)o;
            return Optional.of(aBoolean);
        }
        if (o instanceof String) {
            String s = (String)o;
            return Optional.of(StringUtils.isTrue(s));
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            return Optional.of(StringUtils.isTrue(charSequence.toString()));
        }
        return Optional.empty();
    }

    @Override
    public OptionalDouble doubleValue(@NonNull String member) {
        return this.doubleValue(member, this.valueMapper);
    }

    public OptionalDouble doubleValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return OptionalDouble.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return OptionalDouble.of(number.doubleValue());
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                return OptionalDouble.of(Double.parseDouble(s));
            }
            catch (NumberFormatException e) {
                return OptionalDouble.empty();
            }
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return OptionalDouble.of(Double.parseDouble(charSequence.toString()));
            }
            catch (NumberFormatException e) {
                return OptionalDouble.empty();
            }
        }
        return OptionalDouble.empty();
    }

    @Override
    public Optional<Float> floatValue(String member) {
        return this.floatValue(member, this.valueMapper);
    }

    public Optional<Float> floatValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Number) {
            Number number = (Number)o;
            return Optional.of(Float.valueOf(number.floatValue()));
        }
        if (o instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)o;
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(charSequence.toString())));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public OptionalDouble doubleValue() {
        return this.doubleValue("value");
    }

    @Override
    public Optional<String> stringValue(@NonNull String member) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, this.valueMapper);
        if (o != null) {
            return Optional.of(o.toString());
        }
        return Optional.empty();
    }

    public Optional<String> stringValue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return Optional.empty();
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o != null) {
            return Optional.of(o.toString());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> stringValue() {
        return this.stringValue("value");
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull String member) {
        return this.booleanValue(member, this.valueMapper);
    }

    @Override
    public final boolean isPresent(CharSequence member) {
        if (StringUtils.isNotEmpty(member)) {
            return this.values.containsKey(member);
        }
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue("value");
    }

    @Override
    public boolean isTrue(String member) {
        return this.isTrue(member, this.valueMapper);
    }

    public boolean isTrue(@NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isEmpty(member)) {
            return false;
        }
        Object o = this.getRawSingleValue(member, valueMapper);
        if (o instanceof Boolean) {
            Boolean aBoolean = (Boolean)o;
            return aBoolean;
        }
        if (o != null) {
            return StringUtils.isTrue(o.toString());
        }
        return false;
    }

    @Override
    public boolean isFalse() {
        return !this.isTrue("value");
    }

    @Override
    public boolean isFalse(String member) {
        return !this.isTrue(member);
    }

    @NonNull
    public final String getAnnotationName() {
        return this.annotationName;
    }

    public final boolean contains(String member) {
        return this.isPresent(member);
    }

    @NonNull
    public final Set<CharSequence> getMemberNames() {
        return this.values.keySet();
    }

    @Override
    @NonNull
    public Map<CharSequence, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @NonNull
    public ConvertibleValues<Object> getConvertibleValues() {
        return this.convertibleValues;
    }

    @Override
    public <T> Optional<T> get(CharSequence member, ArgumentConversionContext<T> conversionContext) {
        Object dv;
        Optional<T> result = this.convertibleValues.get(member, conversionContext);
        if (result.isPresent()) {
            return result;
        }
        Map<CharSequence, Object> defaults = this.getDefaultValues();
        if (defaults != null && (dv = defaults.get(member.toString())) != null) {
            return ConversionService.SHARED.convert(dv, conversionContext);
        }
        return result;
    }

    public <T> Optional<T> getValue(ArgumentConversionContext<T> conversionContext) {
        return this.get("value", conversionContext);
    }

    public final <T> Optional<T> getValue(Argument<T> argument) {
        return this.getValue(ConversionContext.of(argument));
    }

    public final <T> Optional<T> getValue(Class<T> type) {
        return this.getValue(ConversionContext.of(type));
    }

    @NonNull
    public final <T> T getRequiredValue(Class<T> type) {
        return this.getRequiredValue("value", type);
    }

    @NonNull
    public final <T> T getRequiredValue(String member, Class<T> type) {
        return this.get(member, ConversionContext.of(type)).orElseThrow(() -> new IllegalStateException("No value available for annotation member @" + this.annotationName + "[" + member + "] of type: " + type));
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member, Class<T> type) {
        Object o;
        Collection collection;
        Iterator i;
        ArgumentUtils.requireNonNull("type", type);
        String typeName = type.getName();
        ArgumentUtils.requireNonNull("member", member);
        Object v = this.values.get(member);
        Collection<AnnotationValue<Object>> values = null;
        if (v instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)v;
            values = Collections.singletonList(annotationValue);
        } else if (v instanceof AnnotationValue[]) {
            AnnotationValue[] annotationValues = (AnnotationValue[])v;
            values = Arrays.asList(annotationValues);
        } else if (v instanceof Collection && (i = (collection = (Collection)v).iterator()).hasNext() && (o = i.next()) instanceof AnnotationValue) {
            values = collection;
        }
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationValue<T>> list = new ArrayList<AnnotationValue<T>>(values.size());
        for (AnnotationValue value : values) {
            if (value == null || !value.getAnnotationName().equals(typeName)) continue;
            list.add(value);
        }
        return list;
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member) {
        Object o;
        Collection collection;
        Iterator i;
        ArgumentUtils.requireNonNull("member", member);
        Object v = this.values.get(member);
        if (v instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)v;
            return Collections.singletonList(annotationValue);
        }
        if (v instanceof AnnotationValue[]) {
            AnnotationValue[] annotationValues = (AnnotationValue[])v;
            return Arrays.asList(annotationValues);
        }
        if (v instanceof Collection && (i = (collection = (Collection)v).iterator()).hasNext() && (o = i.next()) instanceof AnnotationValue) {
            return new ArrayList<AnnotationValue<T>>((Collection)v);
        }
        return Collections.emptyList();
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(String member, Class<T> type) {
        ArgumentUtils.requireNonNull("type", type);
        String typeName = type.getName();
        ArgumentUtils.requireNonNull("member", member);
        Object v = this.values.get(member);
        if (v instanceof AnnotationValue) {
            AnnotationValue av = (AnnotationValue)v;
            if (av.getAnnotationName().equals(typeName)) {
                return Optional.of(av);
            }
            return Optional.empty();
        }
        if (v instanceof AnnotationValue[]) {
            Object value;
            Object[] values = (AnnotationValue[])v;
            if (ArrayUtils.isNotEmpty(values) && ((AnnotationValue)(value = values[0])).getAnnotationName().equals(typeName)) {
                return Optional.of(value);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(@NonNull String member) {
        ArgumentUtils.requireNonNull("member", member);
        Object v = this.values.get(member);
        if (v instanceof AnnotationValue) {
            AnnotationValue av = (AnnotationValue)v;
            return Optional.of(av);
        }
        if (v instanceof AnnotationValue[]) {
            Object[] values = (AnnotationValue[])v;
            if (ArrayUtils.isNotEmpty(values)) {
                return Optional.of(values[0]);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public boolean hasEvaluatedExpressions() {
        return this.values.values().stream().anyMatch(value -> value instanceof EvaluatedExpression);
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "@" + this.annotationName;
        }
        return "@" + this.annotationName + "(" + this.values.entrySet().stream().map(entry -> entry.getKey() + "=" + this.toStringValue(entry.getValue())).collect(Collectors.joining(", ")) + ")";
    }

    private String toStringValue(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            Object[] object1s = (Object[])object;
            return Arrays.deepToString(object1s);
        }
        return object.toString();
    }

    public int hashCode() {
        return 31 * this.annotationName.hashCode() + AnnotationUtil.calculateHashCode(this.getValues());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)obj;
        if (!this.annotationName.equals(other.getAnnotationName())) {
            return false;
        }
        Map<CharSequence, Object> otherValues = other.getValues();
        Map<CharSequence, Object> values = this.getValues();
        if (values.size() != otherValues.size()) {
            return false;
        }
        for (Map.Entry<CharSequence, Object> member : values.entrySet()) {
            Object otherValue;
            Object value = member.getValue();
            if (AnnotationUtil.areEqual(value, otherValue = otherValues.get(member.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(String annotationName) {
        return new AnnotationValueBuilder(annotationName);
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(String annotationName, RetentionPolicy retentionPolicy) {
        return new AnnotationValueBuilder(annotationName, retentionPolicy);
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(Class<T> annotation) {
        return new AnnotationValueBuilder(annotation);
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(@NonNull AnnotationValue<T> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return new AnnotationValueBuilder<T>(annotation, annotation.getRetentionPolicy());
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(@NonNull AnnotationValue<T> annotation, @Nullable RetentionPolicy retentionPolicy) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return new AnnotationValueBuilder<T>(annotation, retentionPolicy);
    }

    @Internal
    @Nullable
    public static String[] resolveStringValues(@Nullable Object value, @Nullable Function<Object, Object> valueMapper) {
        if (value == null) {
            return null;
        }
        if (valueMapper != null) {
            value = valueMapper.apply(value);
        }
        if (value instanceof String) {
            String s = (String)value;
            return new String[]{s};
        }
        if (value instanceof String[]) {
            String[] existing = (String[])value;
            return Arrays.copyOf(existing, existing.length);
        }
        if (value instanceof CharSequence) {
            return new String[]{value.toString()};
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                String[] newArray = new String[len];
                for (int i = 0; i < newArray.length; ++i) {
                    Object entry = Array.get(value, i);
                    if (entry == null) continue;
                    newArray[i] = entry.toString();
                }
                return newArray;
            }
            return new String[]{value.toString()};
        }
        return null;
    }

    @Internal
    @NonNull
    public static <E extends Enum> E[] resolveEnumValues(@NonNull Class<E> enumType, @Nullable Object rawValue) {
        if (rawValue == null) {
            return (Enum[])Array.newInstance(enumType, 0);
        }
        ArrayList<Enum> list = new ArrayList<Enum>();
        if (rawValue.getClass().isArray()) {
            int len = Array.getLength(rawValue);
            for (int i = 0; i < len; ++i) {
                AnnotationValue.convertToEnum(enumType, Array.get(rawValue, i)).ifPresent(list::add);
            }
        } else if (rawValue instanceof Iterable) {
            Iterable iterable = (Iterable)rawValue;
            for (Object o : iterable) {
                AnnotationValue.convertToEnum(enumType, o).ifPresent(list::add);
            }
        } else if (enumType.isAssignableFrom(rawValue.getClass())) {
            list.add((Enum)rawValue);
        } else {
            AnnotationValue.convertToEnum(enumType, rawValue).ifPresent(list::add);
        }
        return list.toArray((Enum[])Array.newInstance(enumType, 0));
    }

    @Internal
    public static String[] resolveStringArray(String[] strs, @Nullable Function<Object, Object> valueMapper) {
        if (valueMapper != null) {
            String[] newStrs = new String[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                newStrs[i] = valueMapper.apply(str).toString();
            }
            return newStrs;
        }
        return strs;
    }

    @Internal
    @Nullable
    public static Class<?>[] resolveClassValues(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)value;
            Class type = annotationClassValue.getType().orElse(null);
            if (type != null) {
                return new Class[]{type};
            }
            return null;
        }
        if (value instanceof AnnotationValue[]) {
            AnnotationValue[] annotationValues = (AnnotationValue[])value;
            int len = annotationValues.length;
            if (len > 0) {
                if (len == 1) {
                    return annotationValues[0].classValues();
                }
                ArrayList list = new ArrayList(5);
                for (AnnotationValue annotationValue : annotationValues) {
                    list.addAll(Arrays.asList(annotationValue.classValues()));
                }
                return list.toArray(new Class[0]);
            }
            return null;
        }
        if (value instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)value;
            return annotationValue.classValues();
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values instanceof Class[]) {
                Class[] classes = (Class[])values;
                return classes;
            }
            ArrayList<Class> list = new ArrayList<Class>(5);
            for (Object o : values) {
                if (o instanceof AnnotationClassValue) {
                    AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
                    if (annotationClassValue.theClass == null) continue;
                    list.add(annotationClassValue.theClass);
                    continue;
                }
                if (!(o instanceof Class)) continue;
                Class aClass = (Class)o;
                list.add(aClass);
            }
            return list.toArray(new Class[0]);
        }
        if (value instanceof Class) {
            Class aClass = (Class)value;
            return new Class[]{aClass};
        }
        return null;
    }

    private ConvertibleValues<Object> newConvertibleValues(Map<CharSequence, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return ConvertibleValues.EMPTY;
        }
        return ConvertibleValues.of(values);
    }

    @Nullable
    private Object getRawSingleValue(@NonNull String member, Function<Object, Object> valueMapper) {
        Object rawValue = this.values.get(member);
        if (rawValue != null) {
            Iterable iterable;
            Iterator i;
            if (rawValue.getClass().isArray()) {
                int len = Array.getLength(rawValue);
                if (len > 0) {
                    rawValue = Array.get(rawValue, 0);
                }
            } else if (rawValue instanceof Iterable && (i = (iterable = (Iterable)rawValue).iterator()).hasNext()) {
                rawValue = i.next();
            }
        }
        if (valueMapper != null && (rawValue instanceof String || rawValue instanceof EvaluatedExpression)) {
            return valueMapper.apply(rawValue);
        }
        return rawValue;
    }

    private static <T extends Enum> Optional<T> convertToEnum(Class<T> enumType, Object o) {
        if (enumType.isInstance(o)) {
            return Optional.of((Enum)o);
        }
        try {
            T t = Enum.valueOf(enumType, o.toString());
            return Optional.of(t);
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

