/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.propagation.ThreadContext;
import io.micronaut.core.propagation.ThreadPropagatedContextElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
final class PropagatedContextImpl
implements PropagatedContext {
    static final PropagatedContextImpl EMPTY = new PropagatedContextImpl(new PropagatedContextElement[0], false);
    private static final PropagatedContext.Scope CLEANUP = ThreadContext::remove;
    private final PropagatedContextElement[] elements;
    private final boolean containsThreadElements;

    private PropagatedContextImpl(PropagatedContextElement[] elements) {
        this(elements, PropagatedContextImpl.containsThreadElements(elements));
    }

    private PropagatedContextImpl(PropagatedContextElement[] elements, boolean containsThreadElements) {
        this.elements = elements;
        this.containsThreadElements = containsThreadElements;
    }

    private static boolean containsThreadElements(PropagatedContextElement[] elements) {
        for (PropagatedContextElement element : elements) {
            if (!PropagatedContextImpl.isThreadElement(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isThreadElement(PropagatedContextElement element) {
        return element instanceof ThreadPropagatedContextElement;
    }

    public static boolean exists() {
        PropagatedContextImpl propagatedContext = ThreadContext.get();
        if (propagatedContext == null) {
            return false;
        }
        return propagatedContext.elements.length != 0;
    }

    public static PropagatedContextImpl get() {
        PropagatedContextImpl propagatedContext = ThreadContext.get();
        if (propagatedContext == null) {
            throw new IllegalStateException("No active propagation context!");
        }
        return propagatedContext;
    }

    public static Optional<PropagatedContext> find() {
        return Optional.ofNullable(ThreadContext.get());
    }

    @NonNull
    public static PropagatedContextImpl getOrEmpty() {
        PropagatedContextImpl propagatedContext = ThreadContext.get();
        if (propagatedContext == null) {
            return EMPTY;
        }
        return propagatedContext;
    }

    @Override
    public PropagatedContextImpl plus(PropagatedContextElement element) {
        PropagatedContextElement[] newElements = Arrays.copyOf(this.elements, this.elements.length + 1);
        newElements[newElements.length - 1] = element;
        return new PropagatedContextImpl(newElements, this.containsThreadElements || PropagatedContextImpl.isThreadElement(element));
    }

    @Override
    public PropagatedContextImpl minus(PropagatedContextElement element) {
        int next;
        int index = this.findElement(element);
        PropagatedContextElement[] newElements = new PropagatedContextElement[this.elements.length - 1];
        if (index > 0) {
            System.arraycopy(this.elements, 0, newElements, 0, index);
        }
        if ((next = index + 1) != this.elements.length) {
            System.arraycopy(this.elements, next, newElements, index, this.elements.length - next);
        }
        return new PropagatedContextImpl(newElements);
    }

    @Override
    public PropagatedContext replace(PropagatedContextElement oldElement, PropagatedContextElement newElement) {
        int index = this.findElement(oldElement);
        PropagatedContextElement[] newElements = new PropagatedContextElement[this.elements.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
        newElements[index] = newElement;
        return new PropagatedContextImpl(newElements);
    }

    private int findElement(PropagatedContextElement element) {
        int elementsLength = this.elements.length;
        for (int i = 0; i < elementsLength; ++i) {
            if (!this.elements[i].equals(element)) continue;
            return i;
        }
        throw new NoSuchElementException("Element is not contained in the current context!");
    }

    @Override
    public <T extends PropagatedContextElement> Optional<T> find(Class<T> elementType) {
        return Optional.ofNullable(this.findElement(elementType));
    }

    @Override
    public <T extends PropagatedContextElement> Stream<T> findAll(Class<T> elementType) {
        ArrayList<PropagatedContextElement> reverseElements = new ArrayList<PropagatedContextElement>(Arrays.asList(this.elements));
        Collections.reverse(reverseElements);
        return reverseElements.stream().filter(elementType::isInstance).map(elementType::cast);
    }

    @Override
    public <T extends PropagatedContextElement> T get(Class<T> elementType) {
        T element = this.findElement(elementType);
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    private <T extends PropagatedContextElement> T findElement(Class<T> elementType) {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            PropagatedContextElement element = this.elements[i];
            if (!elementType.isInstance(element)) continue;
            return (T)element;
        }
        return null;
    }

    @Override
    public List<PropagatedContextElement> getAllElements() {
        return new ArrayList<PropagatedContextElement>(Arrays.asList(this.elements));
    }

    @Override
    public PropagatedContext.Scope propagate() {
        PropagatedContext.Scope restore;
        PropagatedContextImpl prevCtx = ThreadContext.get();
        if (prevCtx == null && this.elements.length == 0) {
            return CLEANUP;
        }
        if (prevCtx == null) {
            restore = CLEANUP;
        } else {
            restore = () -> ThreadContext.set(prevCtx);
            if (this.elements.length == 0) {
                ThreadContext.remove();
                return restore;
            }
        }
        PropagatedContextImpl ctx = this;
        ThreadContext.set(ctx);
        if (this.containsThreadElements) {
            List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState = ctx.updateThreadState();
            return () -> {
                ctx.restoreState(threadState);
                if (prevCtx == null) {
                    ThreadContext.remove();
                } else {
                    ThreadContext.set(prevCtx);
                }
            };
        }
        return restore;
    }

    private List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> updateThreadState() {
        ArrayList<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState = new ArrayList<Map.Entry<ThreadPropagatedContextElement<Object>, Object>>(this.elements.length);
        for (PropagatedContextElement element : this.elements) {
            if (!PropagatedContextImpl.isThreadElement(element)) continue;
            ThreadPropagatedContextElement threadPropagatedContextElement = (ThreadPropagatedContextElement)element;
            Object state = threadPropagatedContextElement.updateThreadContext();
            threadState.add(new AbstractMap.SimpleEntry(threadPropagatedContextElement, state));
        }
        return threadState;
    }

    private void restoreState(List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState) {
        for (Map.Entry<ThreadPropagatedContextElement<Object>, Object> e : threadState) {
            ThreadPropagatedContextElement<Object> threadPropagatedContextElement = e.getKey();
            threadPropagatedContextElement.restoreThreadContext(e.getValue());
        }
    }
}

