/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.value.OptionalMultiValuesMap;
import io.micronaut.core.value.OptionalValues;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface OptionalMultiValues<V>
extends OptionalValues<List<V>> {
    public static final OptionalMultiValues EMPTY_VALUES = OptionalMultiValues.of(Collections.emptyMap());

    default public Optional<V> getFirst(CharSequence name) {
        Optional list = this.get(name);
        return list.flatMap(v -> {
            if (!v.isEmpty()) {
                return Optional.ofNullable(v.get(0));
            }
            return Optional.empty();
        });
    }

    public static <T> OptionalMultiValues<T> empty() {
        return EMPTY_VALUES;
    }

    public static <T> OptionalMultiValues<T> of(Map<CharSequence, List<T>> values) {
        return new OptionalMultiValuesMap(List.class, values);
    }
}

