/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.service.SoftServiceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;

@Internal
final class ServiceScanner<S> {
    private final ClassLoader classLoader;
    private final String serviceName;
    private final Predicate<String> lineCondition;
    private final Function<String, S> transformer;

    public ServiceScanner(ClassLoader classLoader, String serviceName, Predicate<String> lineCondition, Function<String, S> transformer) {
        this.classLoader = classLoader;
        this.serviceName = serviceName;
        this.lineCondition = lineCondition;
        this.transformer = transformer;
    }

    private static URI normalizeFilePath(String path, URI uri) {
        Path p = Paths.get(uri);
        if (p.endsWith(path)) {
            Path subpath = Paths.get(path, new String[0]);
            for (int i = 0; i < subpath.getNameCount(); ++i) {
                p = p.getParent();
            }
            uri = p.toUri();
        }
        return uri;
    }

    private static Set<String> computeMicronautServiceTypeNames(URI uri, String path) {
        StaticServiceDefinitions ssd = ServiceScanner.findStaticServiceDefinitions();
        if (ssd != null) {
            return ssd.serviceTypeMap.getOrDefault(path, Collections.emptySet());
        }
        final HashSet<String> typeNames = new HashSet<String>();
        Consumer<Path> consumer = new Consumer<Path>(){

            @Override
            public void accept(Path currentPath) {
                if (Files.isRegularFile(currentPath, new LinkOption[0])) {
                    String typeName = currentPath.getFileName().toString();
                    typeNames.add(typeName);
                }
            }
        };
        IOUtils.eachFile(uri, path, consumer);
        return typeNames;
    }

    @Nullable
    private static StaticServiceDefinitions findStaticServiceDefinitions() {
        if (ServiceScanner.hasImageSingletons()) {
            return ImageSingletons.contains(StaticServiceDefinitions.class) ? (StaticServiceDefinitions)ImageSingletons.lookup(StaticServiceDefinitions.class) : null;
        }
        return null;
    }

    private static boolean hasImageSingletons() {
        try {
            return ImageSingletons.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Set<String> computeStandardServiceTypeNames(URL url) {
        HashSet<String> typeNames = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#' || !this.lineCondition.test(line)) continue;
                int i = line.indexOf(35);
                if (i > -1) {
                    line = line.substring(0, i);
                }
                typeNames.add(line);
            }
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
        return typeNames;
    }

    private boolean isWebSphereClassLoader() {
        return this.classLoader.getClass().getName().startsWith("com.ibm.ws.classloader");
    }

    private String buildResourceSearchPath() {
        String path = "META-INF/micronaut/" + this.serviceName;
        if (this.isWebSphereClassLoader()) {
            return path + "/";
        }
        return path;
    }

    private Enumeration<URL> findStandardServiceConfigs() throws IOException {
        return this.classLoader.getResources("META-INF/services/" + this.serviceName);
    }

    private void findMicronautMetaServiceConfigs(BiConsumer<URI, String> consumer) throws IOException, URISyntaxException {
        String path = this.buildResourceSearchPath();
        Enumeration<URL> micronautResources = this.classLoader.getResources(path);
        LinkedHashSet<URI> uniqueURIs = new LinkedHashSet<URI>();
        while (micronautResources.hasMoreElements()) {
            URL url = micronautResources.nextElement();
            URI uri = url.toURI();
            uniqueURIs.add(uri);
        }
        if (uniqueURIs.isEmpty()) {
            FileSystem fs = null;
            try {
                fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            }
            catch (FileSystemNotFoundException | ProviderNotFoundException uri) {
                // empty catch block
            }
            if (fs == null || !fs.isOpen()) {
                try {
                    fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), this.classLoader);
                }
                catch (IOException | ProviderNotFoundException uri) {
                    // empty catch block
                }
            }
            if (fs != null) {
                Path modulesPath = fs.getPath("modules", new String[0]);
                try (Stream<Path> stream = Files.list(modulesPath);){
                    stream.filter(p -> !p.getFileName().toString().startsWith("jdk.")).filter(p -> !p.getFileName().toString().startsWith("java.")).map(p -> p.resolve(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(modulesPath::resolve).map(Path::toUri).forEach(uniqueURIs::add);
                }
            }
        }
        for (URI uri : uniqueURIs) {
            String scheme = uri.getScheme();
            if ("file".equals(scheme)) {
                uri = ServiceScanner.normalizeFilePath(path, uri);
            }
            if ("resource".equals(scheme) && uri.toString().contains("#")) continue;
            consumer.accept(uri, path);
        }
    }

    @Internal
    record StaticServiceDefinitions(Map<String, Set<String>> serviceTypeMap) {
        StaticServiceDefinitions {
            if (serviceTypeMap == null) {
                serviceTypeMap = new HashMap<String, Set<String>>();
            }
        }
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void collect(Collection<S> var1);
    }

    private final class ServiceInstanceLoader
    extends RecursiveActionValuesCollector<S> {
        private final String className;
        private S result;
        private Throwable throwable;

        public ServiceInstanceLoader(String className) {
            this.className = className;
        }

        @Override
        protected void compute() {
            try {
                this.result = ServiceScanner.this.transformer.apply(this.className);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void collect(Collection<S> values) {
            if (this.throwable != null) {
                throw new SoftServiceLoader.ServiceLoadingException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null && !values.contains(this.result)) {
                values.add(this.result);
            }
        }
    }

    private final class UrlServicesLoader
    extends RecursiveActionValuesCollector<S> {
        private final URL url;
        private final List<ServiceInstanceLoader> tasks = new ArrayList<ServiceInstanceLoader>();

        public UrlServicesLoader(URL url) {
            this.url = url;
        }

        @Override
        protected void compute() {
            for (String typeName : ServiceScanner.this.computeStandardServiceTypeNames(this.url)) {
                ServiceInstanceLoader task = new ServiceInstanceLoader(typeName);
                this.tasks.add(task);
                task.fork();
            }
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    private final class MicronautMetaServicesLoader
    extends RecursiveActionValuesCollector<S> {
        private final URI uri;
        private final List<ServiceInstanceLoader> tasks = new ArrayList<ServiceInstanceLoader>();
        private final String path;

        private MicronautMetaServicesLoader(URI uri, String path) {
            this.uri = uri;
            this.path = path;
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }

        @Override
        protected void compute() {
            Set<String> typeNames = ServiceScanner.computeMicronautServiceTypeNames(this.uri, this.path);
            for (String typeName : typeNames) {
                ServiceInstanceLoader task = new ServiceInstanceLoader(typeName);
                this.tasks.add(task);
                task.fork();
            }
        }
    }

    final class DefaultServiceCollector
    extends RecursiveActionValuesCollector<S>
    implements SoftServiceLoader.ServiceCollector<S> {
        private final List<RecursiveActionValuesCollector<S>> tasks = new ArrayList();

        DefaultServiceCollector() {
        }

        @Override
        protected void compute() {
            try {
                Enumeration<URL> serviceConfigs = ServiceScanner.this.findStandardServiceConfigs();
                while (serviceConfigs.hasMoreElements()) {
                    URL url = serviceConfigs.nextElement();
                    UrlServicesLoader task = new UrlServicesLoader(url);
                    this.tasks.add(task);
                    task.fork();
                }
                ServiceScanner.this.findMicronautMetaServiceConfigs((uri, path) -> {
                    MicronautMetaServicesLoader task = new MicronautMetaServicesLoader((URI)uri, (String)path);
                    this.tasks.add(task);
                    task.fork();
                });
            }
            catch (IOException | URISyntaxException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + ServiceScanner.this.serviceName, e);
            }
        }

        @Override
        public void collect(Collection<S> values) {
            ForkJoinPool.commonPool().invoke(this);
            for (RecursiveActionValuesCollector task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }

        @Override
        public void collect(Collection<S> values, boolean allowFork) {
            if (allowFork && ForkJoinPool.getCommonPoolParallelism() > 1) {
                ForkJoinPool.commonPool().invoke(this);
                for (RecursiveActionValuesCollector task : this.tasks) {
                    task.join();
                    task.collect(values);
                }
            } else {
                try {
                    Enumeration<URL> serviceConfigs = ServiceScanner.this.findStandardServiceConfigs();
                    while (serviceConfigs.hasMoreElements()) {
                        URL url = serviceConfigs.nextElement();
                        for (String typeName : ServiceScanner.this.computeStandardServiceTypeNames(url)) {
                            Object val = ServiceScanner.this.transformer.apply(typeName);
                            if (val == null) continue;
                            values.add(val);
                        }
                    }
                    ServiceScanner.this.findMicronautMetaServiceConfigs((uri, path) -> {
                        for (String typeName : ServiceScanner.computeMicronautServiceTypeNames(uri, path)) {
                            Object val = ServiceScanner.this.transformer.apply(typeName);
                            if (val == null) continue;
                            values.add(val);
                        }
                    });
                }
                catch (IOException | URISyntaxException e) {
                    throw new ServiceConfigurationError("Failed to load resources for service: " + ServiceScanner.this.serviceName, e);
                }
            }
        }
    }
}

