/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.CharSequenceToEnumConverter;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.converters.MultiValuesConverterFactory;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.format.FormattingTypeConverter;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.CopyOnWriteMap;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultMutableConversionService
implements MutableConversionService {
    private static final int CACHE_MAX = 256;
    private static final int CACHE_EVICTION_BATCH = 64;
    private static final TypeConverter UNCONVERTIBLE = (object, targetType, context) -> Optional.empty();
    private static final Map<Class<?>, List<Class<?>>> COMMON_TYPE_HIERARCHY = CollectionUtils.newHashMap(30);
    private final Map<ConvertiblePair, TypeConverter> internalConverters = CollectionUtils.newHashMap(300);
    private final Map<ConvertiblePair, TypeConverter> customConverters = new ConcurrentHashMap<ConvertiblePair, TypeConverter>();
    private final Map<ConvertiblePair, TypeConverter> converterCache = new ConcurrentHashMap<ConvertiblePair, TypeConverter>();
    private final MutableConversionService internalMutableConversionService = new MutableConversionService(){

        @Override
        public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> typeConverter) {
            DefaultMutableConversionService.this.addInternalConverter(sourceType, targetType, typeConverter);
        }

        @Override
        public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
            DefaultMutableConversionService.this.addInternalConverter(sourceType, targetType, typeConverter);
        }

        @Override
        public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
            return DefaultMutableConversionService.this.convert(object, targetType, context);
        }

        @Override
        public <S, T> Optional<T> convert(S object, Class<? super S> sourceType, Class<T> targetType, ConversionContext context) {
            return DefaultMutableConversionService.this.convert(object, sourceType, targetType, context);
        }

        @Override
        public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
            return DefaultMutableConversionService.this.canConvert(sourceType, targetType);
        }

        @Override
        public <T> Optional<T> convert(Object object, Class<T> targetType) {
            return DefaultMutableConversionService.this.convert(object, targetType);
        }

        @Override
        public <T> Optional<T> convert(Object object, Argument<T> targetType) {
            return DefaultMutableConversionService.this.convert(object, targetType);
        }

        @Override
        public <T> Optional<T> convert(Object object, ArgumentConversionContext<T> context) {
            return DefaultMutableConversionService.this.convert(object, context);
        }

        @Override
        public <T> T convertRequired(Object value, Class<T> type) {
            return DefaultMutableConversionService.this.convertRequired(value, type);
        }

        @Override
        public <T> T convertRequired(Object value, Argument<T> argument) {
            return DefaultMutableConversionService.this.convertRequired(value, argument);
        }

        @Override
        public <T> T convertRequired(Object value, ArgumentConversionContext<T> context) {
            return DefaultMutableConversionService.this.convertRequired(value, context);
        }
    };

    public DefaultMutableConversionService() {
        this.registerDefaultConverters();
    }

    @Override
    public <S, T> Optional<T> convert(S object, Class<? super S> sourceType, Class<T> targetType, ConversionContext context) {
        if (object == null || targetType == null || context == null) {
            return Optional.empty();
        }
        if (targetType == Object.class) {
            return Optional.of(object);
        }
        Class<Object> clazz = targetType = targetType.isPrimitive() ? ReflectionUtils.getWrapperType(targetType) : targetType;
        if (targetType.isInstance(object) && !(object instanceof Iterable) && !(object instanceof Map)) {
            return Optional.of(object);
        }
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        String formattingAnnotation = annotationMetadata.hasStereotypeNonRepeating(Format.class) ? (String)annotationMetadata.getAnnotationNameByStereotype(Format.class).orElse(null) : null;
        ConvertiblePair pair = new ConvertiblePair(sourceType, targetType, formattingAnnotation);
        TypeConverter<Object, Object> typeConverter = this.findConverter(pair);
        if (typeConverter == null) {
            typeConverter = this.findTypeConverter(sourceType, targetType, formattingAnnotation);
            if (typeConverter == null) {
                this.addToConverterCache(pair, UNCONVERTIBLE);
                return Optional.empty();
            }
            this.addToConverterCache(pair, typeConverter);
        }
        if (typeConverter == UNCONVERTIBLE) {
            return Optional.empty();
        }
        return typeConverter.convert(object, targetType, context);
    }

    @Override
    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        ConvertiblePair pair = new ConvertiblePair(sourceType, targetType, null);
        TypeConverter<Object, Object> typeConverter = this.findConverter(pair);
        if (typeConverter == null) {
            typeConverter = this.findTypeConverter(sourceType, targetType, null);
            if (typeConverter != null) {
                this.addToConverterCache(pair, typeConverter);
                return typeConverter != UNCONVERTIBLE;
            }
            return false;
        }
        return typeConverter != UNCONVERTIBLE;
    }

    private <T, S> TypeConverter<T, S> findConverter(ConvertiblePair pair) {
        TypeConverter typeConverter = this.internalConverters.get(pair);
        if (typeConverter != null) {
            return typeConverter;
        }
        return this.converterCache.get(pair);
    }

    private <T, S> TypeConverter<T, S> findRegisteredConverter(ConvertiblePair pair) {
        TypeConverter typeConverter = this.internalConverters.get(pair);
        if (typeConverter != null) {
            return typeConverter;
        }
        return this.customConverters.get(pair);
    }

    @Override
    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        this.addConverterAnalyzeSource(this.customConverters, sourceType, targetType, typeConverter);
    }

    @Internal
    public <S, T> void addInternalConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        this.addConverterAnalyzeSource(this.internalConverters, sourceType, targetType, typeConverter);
    }

    private <S, T> void addConverterAnalyzeSource(Map<ConvertiblePair, TypeConverter> typeConverters, Class<S> sourceType, Class<T> targetType, final TypeConverter<S, T> typeConverter) {
        this.addConverterToMap(typeConverters, sourceType, targetType, typeConverter);
        if (sourceType == CharSequence.class) {
            FormattingTypeConverter converter;
            if (typeConverter instanceof FormattingTypeConverter) {
                final FormattingTypeConverter formattingTypeConverter = (FormattingTypeConverter)typeConverter;
                converter = new FormattingTypeConverter<String, T, Annotation>(){

                    @Override
                    public Class<Annotation> annotationType() {
                        return formattingTypeConverter.annotationType();
                    }

                    @Override
                    public Optional<T> convert(String value, Class<T> targetType, ConversionContext context) {
                        return typeConverter.convert(value.toString(), CharSequence.class, context);
                    }
                };
            } else {
                converter = (value, theTarget, context) -> typeConverter.convert(value.toString(), theTarget, context);
            }
            this.addConverterToMap(typeConverters, String.class, targetType, converter);
        } else if (sourceType == String.class) {
            this.addConverterToMap(typeConverters, CharSequence.class, targetType, typeConverter);
        } else if (sourceType == Iterable.class) {
            this.addConverterAnalyzeSource(typeConverters, Collection.class, targetType, typeConverter);
        } else if (sourceType == Collection.class) {
            this.addConverterAnalyzeSource(typeConverters, List.class, targetType, typeConverter);
            this.addConverterAnalyzeSource(typeConverters, Set.class, targetType, typeConverter);
            this.addConverterAnalyzeSource(typeConverters, Queue.class, targetType, typeConverter);
            this.addConverterAnalyzeSource(typeConverters, Deque.class, targetType, typeConverter);
        } else if (sourceType == Queue.class) {
            this.addConverterAnalyzeSource(typeConverters, Deque.class, targetType, typeConverter);
        } else if (sourceType == List.class) {
            this.addConverterToMap(typeConverters, ArrayList.class, targetType, typeConverter);
            this.addConverterToMap(typeConverters, LinkedList.class, targetType, typeConverter);
        } else if (sourceType == Set.class) {
            this.addConverterToMap(typeConverters, HashSet.class, targetType, typeConverter);
            this.addConverterToMap(typeConverters, LinkedHashSet.class, targetType, typeConverter);
        } else if (sourceType == Map.class) {
            this.addConverterToMap(typeConverters, HashMap.class, targetType, typeConverter);
            this.addConverterToMap(typeConverters, LinkedHashMap.class, targetType, typeConverter);
            this.addConverterToMap(typeConverters, ConcurrentHashMap.class, targetType, typeConverter);
        } else if (sourceType == Deque.class) {
            this.addConverterToMap(typeConverters, LinkedList.class, targetType, typeConverter);
            this.addConverterToMap(typeConverters, ArrayDeque.class, targetType, typeConverter);
        }
    }

    private <S, T> void addConverterToMap(Map<ConvertiblePair, TypeConverter> typeConverters, Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        ConvertiblePair pair = this.newPair(sourceType, targetType, typeConverter);
        typeConverters.put(pair, typeConverter);
        if (typeConverters != this.internalConverters) {
            this.addToConverterCache(pair, typeConverter);
        }
    }

    @Override
    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> function) {
        this.addConverter(sourceType, targetType, TypeConverter.of(sourceType, targetType, function));
    }

    @Internal
    public <S, T> void addInternalConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> function) {
        this.addInternalConverter(sourceType, targetType, TypeConverter.of(sourceType, targetType, function));
    }

    private void addToConverterCache(ConvertiblePair pair, TypeConverter<?, ?> typeConverter) {
        this.converterCache.put(pair, typeConverter);
        if (this.converterCache.size() > 256) {
            CopyOnWriteMap.evict(this.converterCache, 64);
        }
    }

    private void registerDefaultConverters() {
        LinkedHashMap<Class, Class> primitiveArrays = new LinkedHashMap<Class, Class>();
        primitiveArrays.put(Boolean[].class, boolean[].class);
        primitiveArrays.put(Byte[].class, byte[].class);
        primitiveArrays.put(Character[].class, char[].class);
        primitiveArrays.put(Double[].class, double[].class);
        primitiveArrays.put(Float[].class, float[].class);
        primitiveArrays.put(Integer[].class, int[].class);
        primitiveArrays.put(Long[].class, long[].class);
        primitiveArrays.put(Short[].class, short[].class);
        Function<Object, Object> primitiveArrayToWrapperArray = ArrayUtils::toWrapperArray;
        Function<Object[], Object> wrapperArrayToPrimitiveArray = ArrayUtils::toPrimitiveArray;
        for (Map.Entry e : primitiveArrays.entrySet()) {
            Class wrapperArray = (Class)e.getKey();
            Class primitiveArray = (Class)e.getValue();
            this.addInternalConverter(primitiveArray, wrapperArray, primitiveArrayToWrapperArray);
            this.addInternalConverter(wrapperArray, primitiveArray, wrapperArrayToPrimitiveArray);
        }
        this.addInternalConverter(Object.class, List.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<Argument<?>> firstTypeVariable = context.getFirstTypeVariable();
            Argument<Object> argument = firstTypeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Optional<Object> converted = this.convert(object, context.with(argument));
            if (converted.isPresent()) {
                return Optional.of(Collections.singletonList(converted.get()));
            }
            return Optional.empty();
        });
        this.addInternalConverter(byte[].class, String.class, (S bytes, Class<T> targetType, ConversionContext context) -> Optional.of(new String((byte[])bytes, context.getCharset())));
        this.addInternalConverter(CharSequence.class, Class.class, (S object, Class<T> targetType, ConversionContext context) -> {
            ClassLoader classLoader = targetType.getClassLoader();
            if (classLoader == null) {
                classLoader = DefaultMutableConversionService.class.getClassLoader();
            }
            return ClassUtils.forName(object.toString(), classLoader);
        });
        this.addInternalConverter(AnnotationClassValue.class, Class.class, (S object, Class<T> targetType, ConversionContext context) -> object.getType());
        this.addInternalConverter(AnnotationClassValue.class, Object.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (targetType.equals(Class.class)) {
                return object.getType();
            }
            if (CharSequence.class.isAssignableFrom(targetType)) {
                return Optional.of(object.getName());
            }
            Optional i = object.getInstance();
            if (i.isPresent() && targetType.isInstance(i.get())) {
                return i;
            }
            return Optional.empty();
        });
        this.addInternalConverter(AnnotationClassValue[].class, Class.class, (S object, Class<T> targetType, ConversionContext context) -> {
            AnnotationClassValue o;
            if (((AnnotationClassValue[])object).length > 0 && (o = object[0]) != null) {
                return o.getType();
            }
            return Optional.empty();
        });
        this.addInternalConverter(AnnotationClassValue[].class, Class[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            ArrayList classes = new ArrayList(((AnnotationClassValue[])object).length);
            for (AnnotationClassValue annotationClassValue : object) {
                Optional type;
                if (annotationClassValue == null || !(type = annotationClassValue.getType()).isPresent()) continue;
                classes.add(type.get());
            }
            return Optional.of(classes.toArray(ReflectionUtils.EMPTY_CLASS_ARRAY));
        });
        this.addInternalConverter(URI.class, URL.class, (S uri) -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
        this.addInternalConverter(InputStream.class, String.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<String> optional;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)object));
            try {
                optional = Optional.of(IOUtils.readText(reader));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    context.reject(e);
                    return Optional.empty();
                }
            }
            reader.close();
            return optional;
        });
        this.addInternalConverter(CharSequence.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(object.toString().getBytes(context.getCharset())));
        this.addInternalConverter(Integer.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putInt((int)object).array()));
        this.addInternalConverter(Character.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putChar(object.charValue()).array()));
        this.addInternalConverter(Long.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(8).putLong((long)object).array()));
        this.addInternalConverter(Short.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(2).putShort((short)object).array()));
        this.addInternalConverter(Double.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(8).putDouble((double)object).array()));
        this.addInternalConverter(Float.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putFloat(object.floatValue()).array()));
        this.addInternalConverter(InputStream.class, Number.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<String> convert = this.convert(object, String.class, context);
            if (convert.isPresent()) {
                return convert.flatMap(val -> this.convert(val, targetType, context));
            }
            return Optional.empty();
        });
        this.addInternalConverter(Reader.class, String.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<String> optional;
            block8: {
                BufferedReader bufferedReader;
                BufferedReader reader = object instanceof BufferedReader ? (bufferedReader = (BufferedReader)object) : new BufferedReader((Reader)object);
                try {
                    optional = Optional.of(IOUtils.readText(reader));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        context.reject(e);
                        return Optional.empty();
                    }
                }
                reader.close();
            }
            return optional;
        });
        this.addInternalConverter(CharSequence.class, File.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            return Optional.of(new File(object.toString()));
        });
        this.addInternalConverter(String[].class, Enum.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (object == null || ((String[])object).length == 0) {
                return Optional.empty();
            }
            StringJoiner joiner = new StringJoiner("");
            for (String string : object) {
                joiner.add(string);
            }
            String val = joiner.toString();
            return this.convert(val, targetType, context);
        });
        this.addInternalConverter(String[].class, CharSequence.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (object == null || ((String[])object).length == 0) {
                return Optional.empty();
            }
            StringJoiner joiner = new StringJoiner("");
            for (String string : object) {
                joiner.add(string);
            }
            return this.convert(joiner.toString(), targetType, context);
        });
        final ReadableBytesTypeConverter readableBytesTypeConverter = new ReadableBytesTypeConverter();
        this.addInternalConverter(CharSequence.class, Number.class, readableBytesTypeConverter);
        this.addInternalConverter(CharSequence.class, Long.class, new FormattingTypeConverter<CharSequence, Long, ReadableBytes>(){

            @Override
            public Class<ReadableBytes> annotationType() {
                return readableBytesTypeConverter.annotationType();
            }

            @Override
            public Optional<Long> convert(CharSequence object, Class<Long> targetType, ConversionContext context) {
                return readableBytesTypeConverter.convert(object, Number.class, context).map(Number::longValue);
            }
        });
        this.addInternalConverter(CharSequence.class, Integer.class, new FormattingTypeConverter<CharSequence, Integer, ReadableBytes>(){

            @Override
            public Class<ReadableBytes> annotationType() {
                return readableBytesTypeConverter.annotationType();
            }

            @Override
            public Optional<Integer> convert(CharSequence object, Class<Integer> targetType, ConversionContext context) {
                return readableBytesTypeConverter.convert(object, Number.class, context).map(Number::intValue);
            }
        });
        this.addInternalConverter(CharSequence.class, Date.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                SimpleDateFormat format = this.resolveFormat(context);
                return Optional.of(format.parse(object.toString()));
            }
            catch (ParseException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(Date.class, CharSequence.class, (S object, Class<T> targetType, ConversionContext context) -> {
            SimpleDateFormat format = this.resolveFormat(context);
            return Optional.of(format.format((Date)object));
        });
        this.addInternalConverter(Number.class, CharSequence.class, (S object, Class<T> targetType, ConversionContext context) -> {
            NumberFormat format = this.resolveNumberFormat(context);
            if (format != null) {
                return Optional.of(format.format(object));
            }
            return Optional.of(object.toString());
        });
        this.addInternalConverter(CharSequence.class, Path.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Paths.get(object.toString(), new String[0]));
            }
            catch (Exception e) {
                context.reject("Invalid path [" + object + " ]: " + e.getMessage(), e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Integer.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Integer converted = Integer.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, BigInteger.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                BigInteger converted = new BigInteger(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Float.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Float converted = Float.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Double.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Double converted = Double.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Long.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Long converted = Long.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Short.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Short converted = Short.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Byte.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Byte converted = Byte.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, BigDecimal.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                BigDecimal converted = new BigDecimal(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Boolean.class, (S object, Class<T> targetType, ConversionContext context) -> {
            String booleanString;
            return switch (booleanString = object.toString().toLowerCase(Locale.ENGLISH)) {
                case "yes", "y", "on", "true" -> Optional.of(Boolean.TRUE);
                default -> Optional.of(Boolean.FALSE);
            };
        });
        this.addInternalConverter(CharSequence.class, URL.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Object spec = object.toString();
                if (!((String)spec).contains("://")) {
                    spec = "http://" + (String)spec;
                }
                return Optional.of(new URL((String)spec));
            }
            catch (MalformedURLException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, URI.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(new URI(object.toString()));
            }
            catch (URISyntaxException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Locale.class, (S object) -> StringUtils.parseLocale(object.toString()));
        this.addInternalConverter(CharSequence.class, UUID.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(UUID.fromString(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Currency.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Currency.getInstance(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, TimeZone.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            return Optional.of(TimeZone.getTimeZone(object.toString()));
        });
        this.addInternalConverter(CharSequence.class, Charset.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Charset.forName(object.toString()));
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addInternalConverter(CharSequence.class, Character.class, (S object, Class<T> targetType, ConversionContext context) -> {
            String str = object.toString();
            if (str.length() == 1) {
                return Optional.of(Character.valueOf(str.charAt(0)));
            }
            return Optional.empty();
        });
        this.addInternalConverter(CharSequence.class, Object[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (object instanceof AnnotationClassValue) {
                AnnotationClassValue annotationClassValue = (AnnotationClassValue)object;
                if (targetType.equals(AnnotationClassValue[].class)) {
                    AnnotationClassValue[] array = new AnnotationClassValue[]{annotationClassValue};
                    return Optional.of(array);
                }
            }
            String str = object.toString();
            String[] strings = str.split(",");
            Class<?> componentType = ReflectionUtils.getWrapperType(targetType.getComponentType());
            Object newArray = Array.newInstance(componentType, strings.length);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                Optional<?> converted = this.convert((Object)string, componentType);
                if (!converted.isPresent()) continue;
                Array.set(newArray, i, converted.get());
            }
            return Optional.of((Object[])newArray);
        });
        this.addInternalConverter(CharSequence.class, int[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            String str = object.toString();
            String[] strings = str.split(",");
            Object newArray = Array.newInstance(Integer.TYPE, strings.length);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                Optional<Integer> converted = this.convert((Object)string, Integer.TYPE);
                if (!converted.isPresent()) continue;
                Array.set(newArray, i, converted.get());
            }
            return Optional.of((int[])newArray);
        });
        this.addInternalConverter(String.class, char[].class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(object.toCharArray()));
        this.addInternalConverter(Object[].class, String[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            String[] strings = new String[((Object[])object).length];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Object o = object[i];
                if (o == null) continue;
                strings[i] = o.toString();
            }
            return Optional.of(strings);
        });
        this.addInternalConverter(Collection.class, String[].class, (S collection, Class<T> targetType, ConversionContext context) -> {
            String[] strings = new String[collection.size()];
            int i = 0;
            for (Object o : collection) {
                if (o == null) continue;
                strings[i++] = o.toString();
            }
            return Optional.of(strings);
        });
        this.addInternalConverter(CharSequence.class, Enum.class, new CharSequenceToEnumConverter());
        this.addInternalConverter(Object.class, String.class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(object.toString()));
        this.addInternalConverter(Number.class, Number.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Class<?> targetNumberType = ReflectionUtils.getWrapperType(targetType);
            if (targetNumberType.isInstance(object)) {
                return Optional.of(object);
            }
            if (targetNumberType == Integer.class) {
                return Optional.of(object.intValue());
            }
            if (targetNumberType == Long.class) {
                return Optional.of(object.longValue());
            }
            if (targetNumberType == Short.class) {
                return Optional.of(object.shortValue());
            }
            if (targetNumberType == Byte.class) {
                return Optional.of(object.byteValue());
            }
            if (targetNumberType == Float.class) {
                return Optional.of(Float.valueOf(object.floatValue()));
            }
            if (targetNumberType == Double.class) {
                return Optional.of(object.doubleValue());
            }
            if (targetNumberType == BigInteger.class) {
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    return Optional.of(bigDecimal.toBigInteger());
                }
                return Optional.of(BigInteger.valueOf(object.longValue()));
            }
            if (targetNumberType == BigDecimal.class) {
                return Optional.of(new BigDecimal(object.toString()));
            }
            return Optional.empty();
        });
        this.addInternalConverter(CharSequence.class, Iterable.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            ArgumentConversionContext<Object> newContext = context.with(componentType);
            Class<?> targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            String[] strings = object.toString().split(",");
            ArrayList list = new ArrayList();
            for (String string : strings) {
                Optional<?> converted = this.convert(string, targetComponentType, newContext);
                if (!converted.isPresent()) continue;
                list.add(converted.get());
            }
            return CollectionUtils.convertCollection(targetType, list);
        });
        TypeConverter objectToOptionalConverter = (object, targetType, context) -> {
            ArgumentConversionContext<Object> newContext;
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Class<?> targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            Optional<?> converted = this.convert(object, targetComponentType, newContext = context.with(componentType).with(context.getAnnotationMetadata()));
            if (converted.isPresent()) {
                return Optional.of(converted);
            }
            return Optional.of(Optional.empty());
        };
        this.addInternalConverter(Object.class, Optional.class, objectToOptionalConverter);
        this.addInternalConverter(Object.class, OptionalInt.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<Integer> converted = this.convert(object, Integer.class, context);
            return converted.map(OptionalInt::of).or(() -> Optional.of(OptionalInt.empty()));
        });
        this.addInternalConverter(Object.class, OptionalLong.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Optional<Long> converted = this.convert(object, Long.class, context);
            return converted.map(OptionalLong::of).or(() -> Optional.of(OptionalLong.empty()));
        });
        this.addInternalConverter(Iterable.class, String.class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(CollectionUtils.toString(object)));
        this.addInternalConverter(Iterable.class, Object.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (Optional.class.isAssignableFrom(targetType)) {
                return objectToOptionalConverter.convert(object, targetType, context);
            }
            Iterator i = object.iterator();
            int count = 0;
            Object value = null;
            while (i.hasNext()) {
                if (count > 0) {
                    context.reject(object, new ConversionErrorException(Argument.of(targetType), new IllegalArgumentException("Cannot convert an iterable with more than 1 value to a non collection object")));
                    return Optional.empty();
                }
                ++count;
                value = i.next();
            }
            return this.convert(value, targetType, context);
        });
        this.addInternalConverter(Iterable.class, Iterable.class, (S object, Class<T> targetType, ConversionContext context) -> {
            if (ConvertibleValues.class.isAssignableFrom(targetType)) {
                if (object instanceof ConvertibleValues) {
                    return Optional.of(object);
                }
                return Optional.empty();
            }
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Class<?> targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            if (targetType.isInstance(object) && targetComponentType == Object.class) {
                return Optional.of(object);
            }
            ArrayList list = new ArrayList();
            ArgumentConversionContext<Object> newContext = context.with(componentType);
            for (Object o : object) {
                Optional<?> converted = this.convert(o, targetComponentType, newContext);
                if (!converted.isPresent()) continue;
                list.add(converted.get());
            }
            return CollectionUtils.convertCollection(targetType, list);
        });
        this.addInternalConverter(Object[].class, String.class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(ArrayUtils.toString(object)));
        this.addInternalConverter(Object[].class, Object[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            ArrayList results = new ArrayList(((Object[])object).length);
            for (Object o : object) {
                Optional<?> converted = this.convert(o, targetComponentType, context);
                if (!converted.isPresent()) continue;
                results.add(converted.get());
            }
            return Optional.of(results.toArray((Object[])Array.newInstance(targetComponentType, results.size())));
        });
        this.addInternalConverter(Iterable.class, Object[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            ArrayList results = new ArrayList();
            for (Object o : object) {
                Optional<?> converted = this.convert(o, targetComponentType, context);
                if (!converted.isPresent()) continue;
                results.add(converted.get());
            }
            return Optional.of(results.toArray((Object[])Array.newInstance(targetComponentType, results.size())));
        });
        this.addInternalConverter(Object[].class, Iterable.class, (S object, Class<T> targetType, ConversionContext context) -> this.convert(Arrays.asList(object), targetType, context));
        this.addInternalConverter(Object.class, Object[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            Optional<?> converted = this.convert(object, targetComponentType);
            if (converted.isPresent()) {
                Object[] result = (Object[])Array.newInstance(targetComponentType, 1);
                result[0] = converted.get();
                return Optional.of(result);
            }
            return Optional.empty();
        });
        this.addInternalConverter(Map.class, Map.class, (S object, Class<T> targetType, ConversionContext context) -> {
            Argument<String> keyArgument = context.getTypeVariable("K").orElse(Argument.of(String.class, "K"));
            boolean isProperties = targetType.equals(Properties.class);
            Argument valArgument = context.getTypeVariable("V").orElseGet(() -> {
                if (isProperties) {
                    return Argument.of(String.class, "V");
                }
                return Argument.of(Object.class, "V");
            });
            Class keyType = isProperties ? Object.class : keyArgument.getType();
            Class valueType = isProperties ? Object.class : valArgument.getType();
            ArgumentConversionContext<String> keyContext = context.with(keyArgument);
            ArgumentConversionContext valContext = context.with(valArgument);
            Map<Object, Object> newMap = isProperties ? new Properties() : new LinkedHashMap();
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!keyType.isInstance(key)) {
                    Optional convertedKey = this.convert(key, keyType, keyContext);
                    if (!convertedKey.isPresent()) continue;
                    key = convertedKey.get();
                }
                if (!valueType.isInstance(value) || value instanceof Map || value instanceof Collection) {
                    Optional converted = this.convert(value, valueType, valContext);
                    if (!converted.isPresent()) continue;
                    value = converted.get();
                }
                newMap.put(key, value);
            }
            return Optional.of(newMap);
        });
        this.addInternalConverter(Map.class, ConvertibleValues.class, (S object, Class<T> targetType, ConversionContext context) -> Optional.of(new ConvertibleValuesMap(object)));
        this.addInternalConverter(ByteBuffer.class, byte[].class, (S object, Class<T> targetType, ConversionContext context) -> {
            byte[] result = object.toByteArray();
            ((ReferenceCounted)((Object)object)).release();
            return Optional.of(result);
        });
        this.addInternalConverter(ConvertibleMultiValues.class, Iterable.class, new MultiValuesConverterFactory.MultiValuesToIterableConverter(this));
        this.addInternalConverter(ConvertibleMultiValues.class, Map.class, new MultiValuesConverterFactory.MultiValuesToMapConverter(this));
        this.addInternalConverter(ConvertibleMultiValues.class, Object.class, new MultiValuesConverterFactory.MultiValuesToObjectConverter(this));
        this.addInternalConverter(Iterable.class, ConvertibleMultiValues.class, new MultiValuesConverterFactory.IterableToMultiValuesConverter(this));
        this.addInternalConverter(Map.class, ConvertibleMultiValues.class, new MultiValuesConverterFactory.MapToMultiValuesConverter(this));
        this.addInternalConverter(Object.class, ConvertibleMultiValues.class, new MultiValuesConverterFactory.ObjectToMultiValuesConverter(this));
        this.addInternalConverter(CharSequence.class, Proxy.Type.class, new CharSequenceToEnumConverter());
        this.addInternalConverter(Boolean.class, String.class, Object::toString);
        ArrayList registrars = new ArrayList();
        SoftServiceLoader.load(TypeConverterRegistrar.class).disableFork().collectAll(registrars);
        for (TypeConverterRegistrar registrar : registrars) {
            registrar.register(this.internalMutableConversionService);
        }
    }

    @Internal
    public void registerInternalTypeConverters(Collection<TypeConverterRegistrar> registrars) {
        for (TypeConverterRegistrar registrar : registrars) {
            registrar.register(this.internalMutableConversionService);
        }
    }

    protected <T> TypeConverter<Object, T> findTypeConverter(Class<?> sourceType, Class<T> targetType, String formattingAnnotation) {
        boolean hasFormatting;
        List<Class<?>> sourceHierarchy = this.resolveHierarchy(sourceType);
        List<Class<?>> targetHierarchy = this.resolveHierarchy(targetType);
        for (Class<?> sourceSuperType : sourceHierarchy) {
            for (Class<?> targetSuperType : targetHierarchy) {
                ConvertiblePair pair = new ConvertiblePair(sourceSuperType, targetSuperType, formattingAnnotation);
                TypeConverter typeConverter = this.findRegisteredConverter(pair);
                if (typeConverter == null) continue;
                this.addToConverterCache(pair, typeConverter);
                return typeConverter;
            }
        }
        boolean bl = hasFormatting = formattingAnnotation != null;
        if (hasFormatting) {
            for (Class<?> sourceSuperType : sourceHierarchy) {
                for (Class<?> targetSuperType : targetHierarchy) {
                    ConvertiblePair pair = new ConvertiblePair(sourceSuperType, targetSuperType);
                    TypeConverter typeConverter = this.findRegisteredConverter(pair);
                    if (typeConverter == null) continue;
                    this.addToConverterCache(pair, typeConverter);
                    return typeConverter;
                }
            }
        }
        return UNCONVERTIBLE;
    }

    private List<Class<?>> resolveHierarchy(Class<?> sourceType) {
        List<Class<?>> hierarchy = COMMON_TYPE_HIERARCHY.get(sourceType);
        if (hierarchy != null) {
            return hierarchy;
        }
        return ClassUtils.resolveHierarchy(sourceType);
    }

    private SimpleDateFormat resolveFormat(ConversionContext context) {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        Optional<String> format = annotationMetadata.stringValue(Format.class);
        return format.map(pattern -> new SimpleDateFormat((String)pattern, context.getLocale())).orElseGet(() -> new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", context.getLocale()));
    }

    private NumberFormat resolveNumberFormat(ConversionContext context) {
        return context.getAnnotationMetadata().stringValue(Format.class).map(DecimalFormat::new).orElse(null);
    }

    private <S, T> ConvertiblePair newPair(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        ConvertiblePair pair;
        if (typeConverter instanceof FormattingTypeConverter) {
            FormattingTypeConverter formattingTypeConverter = (FormattingTypeConverter)typeConverter;
            pair = new ConvertiblePair(sourceType, targetType, formattingTypeConverter.annotationType().getName());
        } else {
            pair = new ConvertiblePair(sourceType, targetType);
        }
        return pair;
    }

    static {
        COMMON_TYPE_HIERARCHY.put(String.class, List.of(String.class, CharSequence.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(CharSequence.class, List.of(CharSequence.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Character.class, List.of(Character.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Number.class, List.of(Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Integer.class, List.of(Integer.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Double.class, List.of(Double.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Float.class, List.of(Float.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Long.class, List.of(Long.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Short.class, List.of(Short.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Byte.class, List.of(Byte.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(BigInteger.class, List.of(BigInteger.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(BigDecimal.class, List.of(BigDecimal.class, Number.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Iterable.class, List.of(Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Collection.class, List.of(Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(List.class, List.of(List.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Set.class, List.of(Set.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(ArrayList.class, List.of(ArrayList.class, List.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(LinkedList.class, List.of(LinkedList.class, List.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(HashSet.class, List.of(HashSet.class, Set.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(LinkedHashSet.class, List.of(LinkedHashSet.class, Set.class, Collection.class, Iterable.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(Map.class, List.of(Map.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(HashMap.class, List.of(HashMap.class, Map.class, Object.class));
        COMMON_TYPE_HIERARCHY.put(LinkedHashMap.class, List.of(LinkedHashMap.class, Map.class, Object.class));
    }

    private static final class ConvertiblePair {
        final Class<?> source;
        final Class<?> target;
        final String formattingAnnotation;
        final int hashCode;

        ConvertiblePair(Class<?> source, Class<?> target) {
            this(source, target, null);
        }

        ConvertiblePair(Class<?> source, Class<?> target, String formattingAnnotation) {
            this.source = source;
            this.target = target;
            this.formattingAnnotation = formattingAnnotation;
            this.hashCode = ObjectUtils.hash(source, target, formattingAnnotation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConvertiblePair pair = (ConvertiblePair)o;
            if (!this.source.equals(pair.source)) {
                return false;
            }
            if (!this.target.equals(pair.target)) {
                return false;
            }
            return Objects.equals(this.formattingAnnotation, pair.formattingAnnotation);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

