/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MapPropertyResolver
implements PropertyResolver {
    private final Map<String, Object> map;
    private final ConversionService conversionService;

    public MapPropertyResolver(Map<String, Object> map) {
        this.map = map;
        this.conversionService = ConversionService.SHARED;
    }

    public MapPropertyResolver(Map<String, Object> map, ConversionService conversionService) {
        this.map = map;
        this.conversionService = conversionService;
    }

    @Override
    public boolean containsProperty(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean containsProperties(String name) {
        return this.map.keySet().stream().anyMatch(k -> k.startsWith(name));
    }

    @Override
    public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.map.get(name);
        return this.conversionService.convert(value, conversionContext);
    }

    @Override
    @NonNull
    public Collection<String> getPropertyEntries(@NonNull String name) {
        if (StringUtils.isNotEmpty(name)) {
            String prefix = name + ".";
            Set<String> strings = this.map.keySet();
            ArrayList<String> entries = new ArrayList<String>(strings.size());
            for (String k : strings) {
                if (!k.startsWith(prefix)) continue;
                String withoutPrefix = k.substring(prefix.length());
                int i = withoutPrefix.indexOf(46);
                String e = i > -1 ? withoutPrefix.substring(0, i) : withoutPrefix;
                entries.add(e);
            }
            return entries;
        }
        return Collections.emptySet();
    }

    public List<List<String>> getPropertyPathMatches(String pathPattern) {
        return Collections.emptyList();
    }
}

