/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind.annotation;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import java.util.List;
import java.util.Optional;

public abstract class AbstractArgumentBinder<T> {
    private static final String DEFAULT_VALUE_MEMBER = "defaultValue";
    protected final ConversionService conversionService;
    private final String parameterName;
    private final String fallbackParameterName;
    private final String defaultValue;

    protected AbstractArgumentBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.parameterName = null;
        this.fallbackParameterName = null;
        this.defaultValue = null;
    }

    protected AbstractArgumentBinder(ConversionService conversionService, Argument<T> argument) {
        this.conversionService = conversionService;
        this.parameterName = this.getParameterName(argument);
        this.fallbackParameterName = this.getFallbackFormat(argument);
        this.defaultValue = argument.getAnnotationMetadata().stringValue(Bindable.class, DEFAULT_VALUE_MEMBER).orElse(null);
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String name) {
        return this.doBind(context, values, name, ArgumentBinder.BindingResult.empty());
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values) {
        return this.doBind(context, values, this.resolvedParameterName(context.getArgument()), ArgumentBinder.BindingResult.empty());
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String name, ArgumentBinder.BindingResult<T> defaultResult) {
        return this.doConvert(this.doResolve(context, values, name), context, defaultResult);
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, ArgumentBinder.BindingResult<T> defaultResult) {
        return this.doBind(context, values, this.resolvedParameterName(context.getArgument()), defaultResult);
    }

    @NonNull
    protected String getParameterName(@NonNull Argument<T> argument) {
        throw new IllegalStateException("Parameter resolved method must be implemented!");
    }

    protected final String resolvedParameterName(Argument<T> argument) {
        if (this.parameterName == null) {
            return this.getParameterName(argument);
        }
        return this.parameterName;
    }

    @Nullable
    protected Object doResolve(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String name) {
        String fallbackName;
        Object value = this.resolveValue(context, values, name);
        if (value == null && !name.equals(fallbackName = this.getFallbackFormatInternal(context.getArgument()))) {
            name = fallbackName;
            value = this.resolveValue(context, values, name);
        }
        return value;
    }

    @Nullable
    protected Object doResolve(ArgumentConversionContext<T> context, ConvertibleValues<?> values) {
        String name = this.resolvedParameterName(context.getArgument());
        return this.doResolve(context, values, name);
    }

    private String getFallbackFormatInternal(Argument<?> argument) {
        if (this.fallbackParameterName == null) {
            return NameUtils.hyphenate(argument.getName());
        }
        return this.fallbackParameterName;
    }

    protected String getFallbackFormat(Argument<?> argument) {
        return NameUtils.hyphenate(argument.getName());
    }

    private Object resolveValue(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        Argument<T> argument = context.getArgument();
        if (StringUtils.isEmpty(annotationValue)) {
            annotationValue = argument.getName();
        }
        return values.get(annotationValue, context).orElseGet(() -> this.conversionService.convert((Object)this.resolveDefaultValue(argument), context).orElse(null));
    }

    private String resolveDefaultValue(Argument<T> argument) {
        if (this.defaultValue == null) {
            return argument.getAnnotationMetadata().stringValue(Bindable.class, DEFAULT_VALUE_MEMBER).orElse(null);
        }
        return this.defaultValue;
    }

    protected ArgumentBinder.BindingResult<T> doConvert(Object value, ArgumentConversionContext<T> context) {
        return this.doConvert(value, context, ArgumentBinder.BindingResult.empty());
    }

    protected ArgumentBinder.BindingResult<T> doConvert(Object value, ArgumentConversionContext<T> context, ArgumentBinder.BindingResult<T> defaultResult) {
        if (value == null) {
            final Optional<ConversionError> lastError = context.getLastError();
            if (lastError.isPresent()) {
                return new ArgumentBinder.BindingResult<T>(){

                    @Override
                    public Optional<T> getValue() {
                        return Optional.empty();
                    }

                    @Override
                    public List<ConversionError> getConversionErrors() {
                        return lastError.map(List::of).orElseGet(List::of);
                    }
                };
            }
            return defaultResult;
        }
        Optional result = this.conversionService.convert(value, context);
        final Optional<ConversionError> lastError = context.getLastError();
        if (result.isPresent() && context.getArgument().getType() == Optional.class) {
            result = (Optional)result.get();
        }
        final Optional finalResult = result;
        return new ArgumentBinder.BindingResult<T>(){

            @Override
            public Optional<T> getValue() {
                return finalResult;
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return lastError.map(List::of).orElseGet(List::of);
            }
        };
    }
}

