/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgumentValue;
import io.micronaut.core.type.MutableArgumentValue;

@Internal
class DefaultMutableArgumentValue<V>
extends DefaultArgumentValue<V>
implements MutableArgumentValue<V> {
    private V value;

    DefaultMutableArgumentValue(Argument<V> argument, V value) {
        super(argument, value);
        this.value = value;
    }

    @Override
    public void setValue(V value) {
        this.value = !this.getType().isInstance(value) ? value : ConversionService.SHARED.convert(value, this.getType()).orElseThrow(() -> new IllegalArgumentException("Invalid value [" + String.valueOf(value) + "] for argument: " + String.valueOf(this)));
    }

    @Override
    public V getValue() {
        return this.value;
    }
}

