/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Arrays;
import java.util.Optional;

@Internal
public final class CharSequenceToEnumConverter<T extends Enum<T>>
implements TypeConverter<CharSequence, T> {
    @Override
    public Optional<T> convert(CharSequence charSequence, Class<T> targetType, ConversionContext context) {
        if (StringUtils.isEmpty(charSequence)) {
            return Optional.empty();
        }
        String stringValue = charSequence.toString();
        try {
            T val2 = Enum.valueOf(targetType, stringValue);
            return Optional.of(val2);
        }
        catch (IllegalArgumentException e) {
            try {
                T val3 = Enum.valueOf(targetType, NameUtils.environmentName(stringValue));
                return Optional.of(val3);
            }
            catch (Exception e1) {
                Optional<Enum> valOpt = Arrays.stream((Enum[])targetType.getEnumConstants()).filter(val -> val.toString().equals(stringValue)).findFirst();
                if (valOpt.isPresent()) {
                    return valOpt;
                }
                context.reject(charSequence, e);
                return Optional.empty();
            }
        }
    }
}

