/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.client;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.DiscoveryConfiguration;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.registration.RegistrationConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class DiscoveryClientConfiguration
extends HttpClientConfiguration {
    private final ApplicationConfiguration applicationConfiguration;
    private List<ServiceInstance> defaultZone = Collections.emptyList();
    private List<ServiceInstance> otherZones = Collections.emptyList();
    private String host = "localhost";
    private int port = -1;
    private boolean secure;
    private boolean shouldUseDns = false;
    private String contextPath;

    public DiscoveryClientConfiguration() {
        this.applicationConfiguration = null;
    }

    public DiscoveryClientConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.applicationConfiguration = applicationConfiguration;
    }

    public boolean isShouldUseDns() {
        return this.shouldUseDns;
    }

    public void setShouldUseDns(boolean shouldUseDns) {
        this.shouldUseDns = shouldUseDns;
    }

    public Optional<String> getContextPath() {
        return Optional.ofNullable(this.contextPath);
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Optional<String> getServiceId() {
        if (this.applicationConfiguration != null) {
            return this.applicationConfiguration.getName();
        }
        return Optional.empty();
    }

    public List<ServiceInstance> getDefaultZone() {
        return this.defaultZone;
    }

    public void setDefaultZone(List<URL> defaultZone) {
        this.defaultZone = defaultZone.stream().map(this.uriMapper()).map(uri -> ServiceInstance.builder((String)this.getServiceID(), (URI)uri).build()).collect(Collectors.toList());
    }

    public List<ServiceInstance> getAllZones() {
        ArrayList<ServiceInstance> allZones = new ArrayList<ServiceInstance>(this.defaultZone.size() + this.otherZones.size());
        allZones.addAll(this.defaultZone);
        allZones.addAll(this.otherZones);
        return allZones;
    }

    public void setZones(Map<String, List<URL>> zones) {
        if (zones != null) {
            this.otherZones = zones.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(this.uriMapper()).map(uri -> ServiceInstance.builder((String)this.getServiceID(), (URI)uri).zone((String)entry.getKey()).build())).collect(Collectors.toList());
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            this.host = host;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @NonNull
    public abstract DiscoveryConfiguration getDiscovery();

    @Nullable
    public abstract RegistrationConfiguration getRegistration();

    public String toString() {
        return "DiscoveryClientConfiguration{defaultZone=" + this.defaultZone + ", host='" + this.host + '\'' + ", port=" + this.port + ", secure=" + this.secure + "} ";
    }

    protected abstract String getServiceID();

    private Function<URL, URI> uriMapper() {
        return url -> {
            try {
                return url.toURI();
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Invalid Eureka server URL: " + url);
            }
        };
    }
}

