/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.consul.client.v1.Check;
import io.micronaut.discovery.consul.client.v1.HealthEntry;
import io.micronaut.discovery.consul.client.v1.NodeEntry;
import io.micronaut.discovery.consul.client.v1.ServiceEntry;
import io.micronaut.discovery.exceptions.DiscoveryException;
import io.micronaut.health.HealthStatus;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ConsulServiceInstance
implements ServiceInstance {
    private final HealthEntry healthEntry;
    private final URI uri;
    private ConvertibleValues<String> metadata;

    public ConsulServiceInstance(@NonNull HealthEntry healthEntry, @Nullable String scheme) {
        Objects.requireNonNull(healthEntry, "HealthEntry cannot be null");
        this.healthEntry = healthEntry;
        ServiceEntry service = healthEntry.getService();
        Objects.requireNonNull(service, "HealthEntry cannot reference a null service entry");
        NodeEntry node = healthEntry.getNode();
        Objects.requireNonNull(service, "HealthEntry cannot reference a null node entry");
        InetAddress inetAddress = service.getAddress().orElse(node.getAddress());
        int port = service.getPort().orElse(-1);
        String portSuffix = port > -1 ? ":" + port : "";
        String uriStr = (scheme != null ? scheme + "://" : "http://") + inetAddress.getHostName() + portSuffix;
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new DiscoveryException("Invalid service URI: " + uriStr);
        }
    }

    public HealthStatus getHealthStatus() {
        Stream<Check> criticalStream;
        Optional<Check> first;
        List<Check> checks = this.healthEntry.getChecks();
        if (CollectionUtils.isNotEmpty(checks) && (first = (criticalStream = checks.stream().filter(c -> c.status() == Check.Status.CRITICAL)).findFirst()).isPresent()) {
            Check check = first.get();
            String notes = check.getNotes();
            if (StringUtils.isNotEmpty((CharSequence)notes)) {
                return HealthStatus.DOWN.describe(notes);
            }
            return HealthStatus.DOWN;
        }
        return HealthStatus.UP;
    }

    public HealthEntry getHealthEntry() {
        return this.healthEntry;
    }

    public String getId() {
        return this.healthEntry.getService().getName();
    }

    public Optional<String> getInstanceId() {
        return this.healthEntry.getService().getID();
    }

    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvertibleValues<String> getMetadata() {
        ConvertibleValues<String> metadata = this.metadata;
        if (metadata == null) {
            ConsulServiceInstance consulServiceInstance = this;
            synchronized (consulServiceInstance) {
                metadata = this.metadata;
                if (metadata == null) {
                    this.metadata = metadata = this.buildMetadata();
                }
            }
        }
        return metadata;
    }

    private ConvertibleValues<String> buildMetadata() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.healthEntry.getNode().getNodeMetadata());
        List<String> tags = this.healthEntry.getService().getTags();
        for (String tag : tags) {
            int i = tag.indexOf(61);
            if (i <= -1) continue;
            map.put(tag.substring(0, i), tag.substring(i + 1));
        }
        Map<String, String> meta = this.healthEntry.getService().getMeta();
        map.putAll(meta);
        return ConvertibleValues.of(map);
    }
}

