/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.client.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.discovery.consul.client.v1.Check;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
@Introspected
public abstract class NewCheck
implements Check {
    private Duration deregisterCriticalServiceAfter;
    private String name;
    private String ID;
    private Check.Status status = Check.Status.PASSING;
    private String notes;

    @JsonCreator
    protected NewCheck(@JsonProperty(value="Name") String name) {
        this.name = name;
    }

    protected NewCheck() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="ID")
    public String getID() {
        return this.ID;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public String getStatus() {
        return this.status.toString().toLowerCase();
    }

    @Override
    public Check.Status status() {
        return this.status;
    }

    public Duration deregisterCriticalServiceAfter() {
        return this.deregisterCriticalServiceAfter;
    }

    public Optional<String> getDeregisterCriticalServiceAfter() {
        if (this.deregisterCriticalServiceAfter == null) {
            return Optional.empty();
        }
        return Optional.of(this.deregisterCriticalServiceAfter.toMinutes() + "m");
    }

    public NewCheck deregisterCriticalServiceAfter(Duration interval) {
        if (interval != null) {
            this.deregisterCriticalServiceAfter = interval;
        }
        return this;
    }

    public NewCheck deregisterCriticalServiceAfter(String interval) {
        this.deregisterCriticalServiceAfter = (Duration)ConversionService.SHARED.convert((Object)interval, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid deregisterCriticalServiceAfter Specified"));
        return this;
    }

    public NewCheck id(String ID) {
        this.setID(ID);
        return this;
    }

    public NewCheck status(Check.Status status) {
        this.status = status;
        return this;
    }

    public NewCheck notes(String notes) {
        this.notes = notes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewCheck check = (NewCheck)o;
        return Objects.equals(this.deregisterCriticalServiceAfter, check.deregisterCriticalServiceAfter) && Objects.equals(this.name, check.name) && Objects.equals(this.ID, check.ID) && this.status == check.status && Objects.equals(this.notes, check.notes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deregisterCriticalServiceAfter, this.name, this.ID, this.status, this.notes});
    }

    @ReflectiveAccess
    protected void setName(String name) {
        this.name = name;
    }

    protected void setDeregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
        this.deregisterCriticalServiceAfter = (Duration)ConversionService.SHARED.convert((Object)deregisterCriticalServiceAfter, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid deregisterCriticalServiceAfter Specified"));
    }

    @JsonProperty(value="ID")
    @ReflectiveAccess
    void setID(String ID) {
        this.ID = ID;
    }

    @ReflectiveAccess
    protected void setStatus(String status) {
        this.status = Check.Status.valueOf(status.toUpperCase());
    }

    @ReflectiveAccess
    protected void setNotes(String notes) {
        this.notes = notes;
    }
}

