/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.config;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.client.ClientUtil;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.discovery.consul.client.v1.KeyValue;
import io.micronaut.discovery.consul.condition.RequiresConsul;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.jackson.env.JsonPropertySourceLoader;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@RequiresConsul
@Requirements(value={@Requires(beans={ConsulClient.class}), @Requires(property="micronaut.config-client.enabled", value="true", defaultValue="false")})
@BootstrapContextCompatible
public class ConsulConfigurationClient
implements ConfigurationClient {
    private final ConsulClient consulClient;
    private final ConsulConfiguration consulConfiguration;
    private final Map<String, PropertySourceLoader> loaderByFormatMap = new ConcurrentHashMap<String, PropertySourceLoader>();
    private ExecutorService executionService;

    public ConsulConfigurationClient(ConsulClient consulClient, ConsulConfiguration consulConfiguration, Environment environment) {
        this.consulClient = consulClient;
        this.consulConfiguration = consulConfiguration;
        if (environment != null) {
            Collection loaders = environment.getPropertySourceLoaders();
            for (PropertySourceLoader loader : loaders) {
                Set extensions = loader.getExtensions();
                for (String extension : extensions) {
                    this.loaderByFormatMap.put(extension, loader);
                }
            }
        }
    }

    public String getDescription() {
        return this.consulClient.getDescription();
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.consulConfiguration.getConfiguration().isEnabled()) {
            return Flowable.empty();
        }
        ArrayList activeNames = new ArrayList(environment.getActiveNames());
        Optional<String> serviceId = this.consulConfiguration.getServiceId();
        ConsulConfiguration.ConsulConfigDiscoveryConfiguration configDiscoveryConfiguration = this.consulConfiguration.getConfiguration();
        ConfigDiscoveryConfiguration.Format format = configDiscoveryConfiguration.getFormat();
        String path = configDiscoveryConfiguration.getPath().orElse("config/");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String pathPrefix = path;
        String commonConfigPath = path + "application";
        boolean hasApplicationSpecificConfig = serviceId.isPresent();
        String applicationSpecificPath = hasApplicationSpecificConfig ? path + serviceId.get() : null;
        String dc = configDiscoveryConfiguration.getDatacenter().orElse(null);
        Scheduler scheduler = null;
        if (this.executionService != null) {
            scheduler = Schedulers.from((Executor)this.executionService);
        }
        ArrayList<Flowable> keyValueFlowables = new ArrayList<Flowable>();
        Function errorHandler = throwable -> {
            HttpClientResponseException httpClientResponseException;
            if (throwable instanceof HttpClientResponseException && (httpClientResponseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                return Flowable.empty();
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from Consul: " + throwable.getMessage(), throwable));
        };
        Flowable applicationConfig = Flowable.fromPublisher(this.consulClient.readValues(commonConfigPath, dc, null, null)).onErrorResumeNext(errorHandler);
        if (scheduler != null) {
            applicationConfig = applicationConfig.subscribeOn(scheduler);
        }
        keyValueFlowables.add(applicationConfig);
        if (hasApplicationSpecificConfig) {
            Flowable appSpecificConfig = Flowable.fromPublisher(this.consulClient.readValues(applicationSpecificPath, dc, null, null)).onErrorResumeNext(errorHandler);
            if (scheduler != null) {
                appSpecificConfig = appSpecificConfig.subscribeOn(scheduler);
            }
            keyValueFlowables.add(appSpecificConfig);
        }
        int basePriority = -100;
        int envBasePriority = basePriority + 50;
        return Flowable.merge(keyValueFlowables).flatMap(keyValues -> Flowable.create(emitter -> {
            if (CollectionUtils.isEmpty((Collection)keyValues)) {
                emitter.onComplete();
            } else {
                HashMap<String, LocalSource> propertySources = new HashMap<String, LocalSource>();
                Base64.Decoder base64Decoder = Base64.getDecoder();
                block5: for (KeyValue keyValue : keyValues) {
                    boolean validKey;
                    String key = keyValue.getKey();
                    String value = keyValue.getValue();
                    boolean isFolder = key.endsWith("/") && value == null;
                    boolean isCommonConfigKey = key.startsWith(commonConfigPath);
                    boolean isApplicationSpecificConfigKey = hasApplicationSpecificConfig && key.startsWith(applicationSpecificPath);
                    boolean bl = validKey = isCommonConfigKey || isApplicationSpecificConfigKey;
                    if (isFolder || !validKey) continue;
                    switch (format) {
                        case FILE: {
                            String fileName = key.substring(pathPrefix.length());
                            int i = fileName.lastIndexOf(46);
                            if (i <= -1) break;
                            String ext = fileName.substring(i + 1);
                            fileName = fileName.substring(0, i);
                            PropertySourceLoader propertySourceLoader = this.resolveLoader(ext);
                            if (propertySourceLoader == null) continue block5;
                            Object propertySourceName = this.resolvePropertySourceName("application", fileName, activeNames);
                            if (hasApplicationSpecificConfig && propertySourceName == null) {
                                propertySourceName = this.resolvePropertySourceName((String)serviceId.get(), fileName, activeNames);
                            }
                            if (propertySourceName == null) continue block5;
                            Object finalName = propertySourceName;
                            byte[] decoded = base64Decoder.decode(value);
                            Map properties = propertySourceLoader.read((String)propertySourceName, decoded);
                            String envName = ClientUtil.resolveEnvironment(fileName, activeNames);
                            LocalSource localSource = propertySources.computeIfAbsent((String)propertySourceName, arg_0 -> ConsulConfigurationClient.lambda$null$1(isApplicationSpecificConfigKey, envName, (String)finalName, arg_0));
                            localSource.putAll(properties);
                            break;
                        }
                        case NATIVE: {
                            String property = null;
                            Set<String> propertySourceNames = null;
                            if (isCommonConfigKey) {
                                property = this.resolvePropertyName(commonConfigPath, key);
                                propertySourceNames = this.resolvePropertySourceNames(pathPrefix, key, activeNames);
                            } else if (isApplicationSpecificConfigKey) {
                                property = this.resolvePropertyName(applicationSpecificPath, key);
                                propertySourceNames = this.resolvePropertySourceNames(pathPrefix, key, activeNames);
                            }
                            if (property == null || propertySourceNames == null) break;
                            for (String propertySourceName : propertySourceNames) {
                                String envName = ClientUtil.resolveEnvironment(propertySourceName, activeNames);
                                LocalSource localSource = propertySources.computeIfAbsent(propertySourceName, s -> new LocalSource(isApplicationSpecificConfigKey, envName, propertySourceName));
                                byte[] decoded = base64Decoder.decode(value);
                                localSource.put(property, new String(decoded));
                            }
                            continue block5;
                        }
                        case JSON: 
                        case YAML: 
                        case PROPERTIES: {
                            String fullName = key.substring(pathPrefix.length());
                            if (fullName.contains("/")) break;
                            Set<String> propertySourceNames = ClientUtil.calcPropertySourceNames(fullName, activeNames, ",");
                            String formatName = format.name().toLowerCase(Locale.ENGLISH);
                            PropertySourceLoader propertySourceLoader = this.resolveLoader(formatName);
                            if (propertySourceLoader == null) {
                                emitter.onError((Throwable)new ConfigurationException("No PropertySourceLoader found for format [" + format + "]. Ensure ConfigurationClient is running within Micronaut container."));
                                return;
                            }
                            if (!propertySourceLoader.isEnabled()) continue block5;
                            byte[] decoded = base64Decoder.decode(value);
                            Map properties = propertySourceLoader.read(fullName, decoded);
                            for (String propertySourceName : propertySourceNames) {
                                String envName = ClientUtil.resolveEnvironment(propertySourceName, activeNames);
                                LocalSource localSource = propertySources.computeIfAbsent(propertySourceName, s -> new LocalSource(isApplicationSpecificConfigKey, envName, propertySourceName));
                                localSource.putAll(properties);
                            }
                            continue block5;
                        }
                    }
                }
                for (LocalSource localSource : propertySources.values()) {
                    int priority = localSource.environment != null ? envBasePriority + activeNames.indexOf(localSource.environment) * 2 : basePriority + 1;
                    if (localSource.appSpecific) {
                        ++priority;
                    }
                    emitter.onNext((Object)PropertySource.of((String)("consul-" + localSource.name), (Map)localSource.values, (int)priority));
                }
                emitter.onComplete();
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR));
    }

    private String resolvePropertySourceName(String rootName, String fileName, List<String> activeNames) {
        String propertySourceName = null;
        if (fileName.startsWith(rootName)) {
            String env;
            String envString = fileName.substring(rootName.length());
            if (StringUtils.isEmpty((CharSequence)envString)) {
                propertySourceName = rootName;
            } else if (envString.startsWith("-") && activeNames.contains(env = envString.substring(1))) {
                propertySourceName = rootName + '[' + env + ']';
            }
        }
        return propertySourceName;
    }

    private PropertySourceLoader resolveLoader(String formatName) {
        return this.loaderByFormatMap.computeIfAbsent(formatName, f -> this.defaultLoader(formatName));
    }

    private PropertySourceLoader defaultLoader(String format) {
        try {
            switch (format) {
                case "json": {
                    return new JsonPropertySourceLoader();
                }
                case "properties": {
                    return new PropertiesPropertySourceLoader();
                }
                case "yml": 
                case "yaml": {
                    return new YamlPropertySourceLoader();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConfigurationException("Unsupported properties file format: " + format);
    }

    @Inject
    void setExecutionService(@Named(value="io") @Nullable ExecutorService executionService) {
        if (executionService != null) {
            this.executionService = executionService;
        }
    }

    private Set<String> resolvePropertySourceNames(String finalPath, String key, List<String> activeNames) {
        Set<String> propertySourceNames = null;
        String prefix = key.substring(finalPath.length());
        int i = prefix.indexOf(47);
        if (i > -1 && (propertySourceNames = ClientUtil.calcPropertySourceNames(prefix = prefix.substring(0, i), activeNames, ",")) == null) {
            return null;
        }
        return propertySourceNames;
    }

    private String resolvePropertyName(String commonConfigPath, String key) {
        String property = key.substring(commonConfigPath.length());
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            if (property.charAt(0) == '/') {
                property = property.substring(1);
            } else if (property.lastIndexOf(47) > -1) {
                property = property.substring(property.lastIndexOf(47) + 1);
            }
        }
        if (property.indexOf(47) == -1) {
            return property;
        }
        return null;
    }

    private static /* synthetic */ LocalSource lambda$null$1(boolean isApplicationSpecificConfigKey, String envName, String finalName, String s) {
        return new LocalSource(isApplicationSpecificConfigKey, envName, finalName);
    }

    private static class LocalSource {
        private final boolean appSpecific;
        private final String environment;
        private final String name;
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();

        LocalSource(boolean appSpecific, String environment, String name) {
            this.appSpecific = appSpecific;
            this.environment = environment;
            this.name = name;
        }

        void put(String key, Object value) {
            this.values.put(key, value);
        }

        void putAll(Map<String, Object> values) {
            this.values.putAll(values);
        }
    }
}

