/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.consul.registration;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceIdGenerator;
import io.micronaut.discovery.client.registration.DiscoveryServiceAutoRegistration;
import io.micronaut.discovery.consul.ConsulConfiguration;
import io.micronaut.discovery.consul.client.v1.Check;
import io.micronaut.discovery.consul.client.v1.ConsulClient;
import io.micronaut.discovery.consul.client.v1.HTTPCheck;
import io.micronaut.discovery.consul.client.v1.NewCheck;
import io.micronaut.discovery.consul.client.v1.NewServiceEntry;
import io.micronaut.discovery.consul.client.v1.TTLCheck;
import io.micronaut.discovery.exceptions.DiscoveryException;
import io.micronaut.discovery.registration.RegistrationException;
import io.micronaut.health.HealthStatus;
import io.micronaut.health.HeartbeatConfiguration;
import io.micronaut.http.HttpStatus;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import io.reactivex.Single;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={ConsulClient.class, ConsulConfiguration.class})
public class ConsulAutoRegistration
extends DiscoveryServiceAutoRegistration {
    private final ConsulClient consulClient;
    private final HeartbeatConfiguration heartbeatConfiguration;
    private final ConsulConfiguration consulConfiguration;
    private final ServiceInstanceIdGenerator idGenerator;
    private final Environment environment;

    protected ConsulAutoRegistration(Environment environment, ConsulClient consulClient, HeartbeatConfiguration heartbeatConfiguration, ConsulConfiguration consulConfiguration, ServiceInstanceIdGenerator idGenerator) {
        super(consulConfiguration.getRegistration());
        this.environment = environment;
        this.consulClient = consulClient;
        this.heartbeatConfiguration = heartbeatConfiguration;
        this.consulConfiguration = consulConfiguration;
        this.idGenerator = idGenerator;
    }

    protected void pulsate(ServiceInstance instance, HealthStatus status) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null && !registration.getCheck().isHttp() && registration.getCheck().isEnabled() && this.registered.get()) {
            String checkId = "service:" + this.idGenerator.generateId(this.environment, instance);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reporting status for Check ID [{}]: {}", (Object)checkId, (Object)status);
            }
            if (status.equals((Object)HealthStatus.UP)) {
                Single passPublisher = Single.fromPublisher(this.consulClient.pass(checkId));
                passPublisher.subscribe((httpStatus, throwable) -> {
                    if (throwable == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully reported passing state to Consul");
                        }
                    } else {
                        Single.fromPublisher(this.consulClient.getServiceIds()).subscribe((serviceIds, throwable1) -> {
                            String serviceId;
                            if (throwable1 == null && !serviceIds.contains(serviceId = this.idGenerator.generateId(this.environment, instance))) {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("Instance [{}] no longer registered with Consul. Attempting re-registration.", (Object)instance.getId());
                                }
                                this.register(instance);
                            }
                        });
                        String errorMessage = this.getErrorMessage((Throwable)throwable, "Error reporting passing state to Consul: ");
                        if (LOG.isErrorEnabled()) {
                            LOG.error(errorMessage, throwable);
                        }
                    }
                });
            } else {
                Single failPublisher = Single.fromPublisher(this.consulClient.fail(checkId, status.getDescription().orElse(null)));
                failPublisher.subscribe((httpStatus, throwable) -> {
                    if (throwable == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully reported failure state to Consul");
                        }
                    } else {
                        String errorMessage = this.getErrorMessage((Throwable)throwable, "Error reporting passing state to Consul: ");
                        if (LOG.isErrorEnabled()) {
                            LOG.error(errorMessage, throwable);
                        }
                    }
                });
            }
        }
    }

    protected void deregister(ServiceInstance instance) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null) {
            String applicationName = instance.getId();
            String serviceId = this.idGenerator.generateId(this.environment, instance);
            Publisher<HttpStatus> deregisterPublisher = this.consulClient.deregister(serviceId);
            String discoveryService = "Consul";
            this.performDeregistration("Consul", registration, deregisterPublisher, applicationName);
        }
    }

    protected void register(ServiceInstance instance) {
        ConsulConfiguration.ConsulRegistrationConfiguration registration = this.consulConfiguration.getRegistration();
        if (registration != null) {
            String applicationName = instance.getId();
            this.validateApplicationName(applicationName);
            if (StringUtils.isNotEmpty((CharSequence)applicationName)) {
                NewServiceEntry serviceEntry = new NewServiceEntry(applicationName);
                ArrayList<String> tags = new ArrayList<String>(registration.getTags());
                HashMap<String, String> meta = new HashMap<String, String>(registration.getMeta());
                String address = registration.isPreferIpAddress() ? registration.getIpAddr().orElseGet(() -> {
                    String host = instance.getHost();
                    try {
                        InetAddress inetAddress = InetAddress.getByName(host);
                        return inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        throw new RegistrationException("Failed to lookup IP address for host [" + host + "]: " + e.getMessage(), (Throwable)e);
                    }
                }) : instance.getHost();
                serviceEntry.address(address).port(instance.getPort()).tags(tags).meta(meta);
                String serviceId = this.idGenerator.generateId(this.environment, instance);
                serviceEntry.id(serviceId);
                if (instance instanceof EmbeddedServerInstance) {
                    NewCheck check = null;
                    EmbeddedServerInstance embeddedServerInstance = (EmbeddedServerInstance)instance;
                    ApplicationConfiguration applicationConfiguration = embeddedServerInstance.getEmbeddedServer().getApplicationConfiguration();
                    ApplicationConfiguration.InstanceConfiguration instanceConfiguration = applicationConfiguration.getInstance();
                    instanceConfiguration.getGroup().ifPresent(g -> {
                        this.validateName((String)g, "Instance Group");
                        tags.add("group=" + g);
                    });
                    instanceConfiguration.getZone().ifPresent(z -> {
                        this.validateName((String)z, "Instance Zone");
                        tags.add("zone=" + z);
                    });
                    ConvertibleValues metadata = embeddedServerInstance.getMetadata();
                    for (Map.Entry entry : metadata) {
                        tags.add((String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    ConsulConfiguration.ConsulRegistrationConfiguration.CheckConfiguration checkConfig = registration.getCheck();
                    if (checkConfig.isEnabled()) {
                        if (this.heartbeatConfiguration.isEnabled() && !checkConfig.isHttp()) {
                            TTLCheck ttlCheck = new TTLCheck();
                            ttlCheck.ttl(this.heartbeatConfiguration.getInterval().plus(Duration.ofSeconds(10L)));
                            check = ttlCheck;
                        } else {
                            HTTPCheck httpCheck;
                            EmbeddedServer embeddedServer = ((EmbeddedServerInstance)instance).getEmbeddedServer();
                            URL serverURL = embeddedServer.getURL();
                            if (registration.isPreferIpAddress() && address != null) {
                                try {
                                    serverURL = new URL(embeddedServer.getURL().getProtocol(), address, embeddedServer.getPort(), embeddedServer.getURL().getPath());
                                }
                                catch (MalformedURLException e) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.error("invalid url for health check:" + embeddedServer.getURL().getProtocol() + address + ":" + embeddedServer.getPort() + "/" + embeddedServer.getURL().getPath());
                                    }
                                    throw new DiscoveryException("Invalid health path configured: " + registration.getHealthPath());
                                }
                            }
                            try {
                                httpCheck = new HTTPCheck(new URL(serverURL, registration.getHealthPath().orElse("/health")));
                            }
                            catch (MalformedURLException e) {
                                throw new DiscoveryException("Invalid health path configured: " + registration.getHealthPath());
                            }
                            httpCheck.interval(checkConfig.getInterval());
                            httpCheck.method(checkConfig.getMethod()).headers((ConvertibleMultiValues<String>)ConvertibleMultiValues.of(checkConfig.getHeaders()));
                            checkConfig.getTlsSkipVerify().ifPresent(httpCheck::setTLSSkipVerify);
                            check = httpCheck;
                        }
                    }
                    if (check != null) {
                        check.status(Check.Status.PASSING);
                        checkConfig.getDeregisterCriticalServiceAfter().ifPresent(check::deregisterCriticalServiceAfter);
                        checkConfig.getNotes().ifPresent(check::notes);
                        checkConfig.getId().ifPresent(check::id);
                        serviceEntry.check(check);
                    }
                }
                this.customizeServiceEntry(instance, serviceEntry);
                Publisher<HttpStatus> registerFlowable = this.consulClient.register(serviceEntry);
                this.performRegistration("Consul", registration, instance, registerFlowable);
            }
        }
    }

    protected void customizeServiceEntry(ServiceInstance instance, NewServiceEntry serviceEntry) {
    }
}

