/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka;

import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.eureka.client.v2.AmazonInfo;
import io.micronaut.discovery.eureka.client.v2.DataCenterInfo;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class EurekaServiceInstance
implements ServiceInstance {
    private final InstanceInfo instanceInfo;
    private final URI uri;

    public EurekaServiceInstance(InstanceInfo instanceInfo) {
        this.instanceInfo = instanceInfo;
        this.uri = this.createURI(instanceInfo);
    }

    public Optional<String> getInstanceId() {
        return Optional.ofNullable(this.instanceInfo.getInstanceId());
    }

    public HealthStatus getHealthStatus() {
        @NotNull InstanceInfo.Status status = this.instanceInfo.getStatus();
        switch (status) {
            case UP: {
                return HealthStatus.UP;
            }
            case UNKNOWN: {
                return HealthStatus.UNKNOWN;
            }
        }
        return HealthStatus.DOWN;
    }

    public Optional<String> getZone() {
        @NotNull DataCenterInfo dataCenterInfo = this.instanceInfo.getDataCenterInfo();
        if (dataCenterInfo instanceof AmazonInfo) {
            String availabilityZone = ((AmazonInfo)dataCenterInfo).get(AmazonInfo.MetaDataKey.availabilityZone);
            return Optional.ofNullable(availabilityZone);
        }
        return super.getZone();
    }

    public Optional<String> getRegion() {
        @NotNull DataCenterInfo dataCenterInfo = this.instanceInfo.getDataCenterInfo();
        if (dataCenterInfo instanceof AmazonInfo) {
            String availabilityZone = ((AmazonInfo)dataCenterInfo).get(AmazonInfo.MetaDataKey.availabilityZone);
            return Optional.ofNullable(availabilityZone);
        }
        return super.getZone();
    }

    public Optional<String> getGroup() {
        String asgName = this.instanceInfo.getAsgName();
        if (StringUtils.isNotEmpty((CharSequence)asgName)) {
            return Optional.of(asgName);
        }
        return super.getZone();
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public String getId() {
        return this.instanceInfo.getId();
    }

    public URI getURI() {
        return this.uri;
    }

    public ConvertibleValues<String> getMetadata() {
        return ConvertibleValues.of(this.instanceInfo.getMetadata());
    }

    private URI createURI(InstanceInfo instanceInfo) {
        int securePort = instanceInfo.getSecurePort();
        if (securePort > 0) {
            int port = instanceInfo.getSecurePort();
            String portStr = port > 0 ? ":" + port : "";
            return URI.create("https://" + instanceInfo.getHostName() + portStr);
        }
        int port = instanceInfo.getPort();
        String portStr = port > 0 ? ":" + port : "";
        return URI.create("http://" + instanceInfo.getHostName() + portStr);
    }

    public String toString() {
        return this.instanceInfo.toString();
    }
}

