/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.eureka.client.v2;

import io.micronaut.discovery.eureka.client.v2.ApplicationInfo;
import io.micronaut.discovery.eureka.client.v2.InstanceInfo;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.retry.annotation.Retryable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.reactivestreams.Publisher;

public interface EurekaOperations {
    @Post(uri="/apps/{appId}", single=true)
    @Retryable(attempts="${eureka.client.registration.retry-count:10}", delay="${eureka.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> register(@NotBlank String var1, @Valid @NotNull @Body InstanceInfo var2);

    @Delete(uri="/apps/{appId}/{instanceId}", single=true)
    @Retryable(attempts="${eureka.client.registration.retry-count:10}", delay="${eureka.client.registration.retry-delay:3s}")
    public Publisher<HttpStatus> deregister(@NotBlank String var1, @NotBlank String var2);

    @Get(uri="/apps/{appId}", single=true)
    public Publisher<ApplicationInfo> getApplicationInfo(@NotBlank String var1);

    @Get(uri="/apps/{appId}/{instanceId}", single=true)
    public Publisher<InstanceInfo> getInstanceInfo(@NotBlank String var1, @NotBlank String var2);

    public Publisher<List<ApplicationInfo>> getApplicationInfos();

    public Publisher<List<ApplicationInfo>> getApplicationVips(String var1);

    @Put(uri="/apps/{appId}/{instanceId}", single=true)
    public Publisher<HttpStatus> heartbeat(@NotBlank String var1, @NotBlank String var2);

    @Put(uri="/apps/{appId}/{instanceId}/status?value={status}", single=true)
    public Publisher<HttpStatus> updateStatus(@NotBlank String var1, @NotBlank String var2, @NotNull InstanceInfo.Status var3);

    @Put(uri="/apps/{appId}/{instanceId}/metadata?{key}={value}", single=true)
    public Publisher<HttpStatus> updateMetadata(@NotBlank String var1, @NotBlank String var2, @NotBlank String var3, @NotBlank String var4);
}

