/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.oraclecloud.vault.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.discovery.config.ConfigDiscoveryConfiguration;
import java.util.List;

@ConfigurationProperties(value="oraclecloud.vault")
@BootstrapContextCompatible
public class OracleCloudVaultClientConfiguration {
    public static final String PREFIX = "oraclecloud.vault";
    private static final Boolean USE_INSTANCE_PRINCIPAL = false;
    private static final String PATH_TO_OCI_CONFIG = "~/.oci/config";
    private static final String DEFAULT_PROFILE = "DEFAULT";
    private final OracleCloudVaultClientDiscoveryConfiguration oracleCloudVaultClientDiscoveryConfiguration = new OracleCloudVaultClientDiscoveryConfiguration();
    private List<OracleCloudVault> vaults;
    private boolean useInstancePrincipal = USE_INSTANCE_PRINCIPAL;
    private String pathToConfig = "~/.oci/config";
    private String profile = "DEFAULT";
    private String region;

    public OracleCloudVaultClientDiscoveryConfiguration getDiscoveryConfiguration() {
        return this.oracleCloudVaultClientDiscoveryConfiguration;
    }

    public List<OracleCloudVault> getVaults() {
        return this.vaults;
    }

    public void setVaults(List<OracleCloudVault> vaults) {
        this.vaults = vaults;
    }

    public boolean isUseInstancePrincipal() {
        return this.useInstancePrincipal;
    }

    public void setUseInstancePrincipal(boolean useInstancePrincipal) {
        this.useInstancePrincipal = useInstancePrincipal;
    }

    public String getPathToConfig() {
        return this.pathToConfig;
    }

    public void setPathToConfig(String pathToConfig) {
        this.pathToConfig = pathToConfig;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @ConfigurationProperties(value="config")
    @BootstrapContextCompatible
    public static class OracleCloudVaultClientDiscoveryConfiguration
    extends ConfigDiscoveryConfiguration {
        public static final String PREFIX = "oraclecloud.vault.config";
    }

    @EachProperty(value="vaults", list=true)
    @BootstrapContextCompatible
    public static class OracleCloudVault {
        private String ocid;
        private String compartmentOcid;

        public String getOcid() {
            return this.ocid;
        }

        public void setOcid(String ocid) {
            this.ocid = ocid;
        }

        public String getCompartmentOcid() {
            return this.compartmentOcid;
        }

        public void setCompartmentOcid(String compartmentOcid) {
            this.compartmentOcid = compartmentOcid;
        }

        public String toString() {
            return "OracleCloudVault{ocid='" + this.ocid + '\'' + ", compartmentOcid='" + this.compartmentOcid + '\'' + '}';
        }
    }
}

