/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.oraclecloud.vault.config;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.secrets.SecretsClient;
import com.oracle.bmc.secrets.model.Base64SecretBundleContentDetails;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import com.oracle.bmc.secrets.responses.GetSecretBundleResponse;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.oraclecloud.vault.config.OracleCloudVaultClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={SecretsClient.class, VaultsClient.class, InstancePrincipalsAuthenticationDetailsProvider.class, ConfigFileAuthenticationDetailsProvider.class})
@BootstrapContextCompatible
public class OracleCloudVaultConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(OracleCloudVaultConfigurationClient.class);
    private final OracleCloudVaultClientConfiguration oracleCloudVaultClientConfiguration;
    private final ApplicationConfiguration applicationConfiguration;
    private final ExecutorService executorService;
    private final SecretsClient secretsClient;
    private final VaultsClient vaultsClient;

    public OracleCloudVaultConfigurationClient(OracleCloudVaultClientConfiguration oracleCloudVaultClientConfiguration, ApplicationConfiguration applicationConfiguration, @Named(value="io") @Nullable ExecutorService executorService) throws Exception {
        InstancePrincipalsAuthenticationDetailsProvider provider;
        block5: {
            this.oracleCloudVaultClientConfiguration = oracleCloudVaultClientConfiguration;
            this.applicationConfiguration = applicationConfiguration;
            this.executorService = executorService;
            provider = null;
            if (oracleCloudVaultClientConfiguration.isUseInstancePrincipal()) {
                provider = InstancePrincipalsAuthenticationDetailsProvider.builder().build();
            } else {
                try {
                    provider = new ConfigFileAuthenticationDetailsProvider(oracleCloudVaultClientConfiguration.getPathToConfig(), oracleCloudVaultClientConfiguration.getProfile());
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error("An error occurred when attempting to connect with a ConfigFileAuthenticationDetailsProvider: {}", (Object)e.getMessage());
                }
            }
        }
        Region region = Region.fromRegionCodeOrId((String)oracleCloudVaultClientConfiguration.getRegion());
        if (provider == null) {
            throw new Exception("You must use instance principal auth or config file auth with the Oracle Cloud Vault Client");
        }
        this.secretsClient = ((SecretsClient.Builder)SecretsClient.builder().region(region)).build((AbstractAuthenticationDetailsProvider)provider);
        this.vaultsClient = ((VaultsClient.Builder)VaultsClient.builder().region(region)).build((AbstractAuthenticationDetailsProvider)provider);
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.oracleCloudVaultClientConfiguration.getDiscoveryConfiguration().isEnabled()) {
            return Flowable.empty();
        }
        String applicationName = this.applicationConfiguration.getName().orElse(null);
        Set activeNames = environment.getActiveNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Oracle Cloud Vault OCIDs: {}, Using Instance Principals: {}, Path To Config: {}, Profile: {}, Region: {}", new Object[]{this.oracleCloudVaultClientConfiguration.getVaults(), this.oracleCloudVaultClientConfiguration.isUseInstancePrincipal(), this.oracleCloudVaultClientConfiguration.getPathToConfig(), this.oracleCloudVaultClientConfiguration.getProfile(), this.oracleCloudVaultClientConfiguration.getRegion()});
            LOG.debug("Application name: {}, application profiles: {}", (Object)applicationName, (Object)activeNames);
        }
        ArrayList<Flowable> propertySources = new ArrayList<Flowable>();
        Scheduler scheduler = this.executorService != null ? Schedulers.from((Executor)this.executorService) : null;
        HashMap secrets = new HashMap();
        for (OracleCloudVaultClientConfiguration.OracleCloudVault vault : this.oracleCloudVaultClientConfiguration.getVaults()) {
            int retrieved = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving secrets from Oracle Cloud Vault with OCID: {}", (Object)vault.getOcid());
            }
            ArrayList<ListSecretsResponse> responses = new ArrayList<ListSecretsResponse>();
            ListSecretsRequest listSecretsRequest = this.buildRequest(vault.getOcid(), vault.getCompartmentOcid(), null);
            ListSecretsResponse listSecretsResponse = this.vaultsClient.listSecrets(listSecretsRequest);
            responses.add(listSecretsResponse);
            while (listSecretsResponse.getOpcNextPage() != null) {
                listSecretsRequest = this.buildRequest(vault.getOcid(), vault.getCompartmentOcid(), listSecretsResponse.getOpcNextPage());
                listSecretsResponse = this.vaultsClient.listSecrets(listSecretsRequest);
                responses.add(listSecretsResponse);
            }
            for (ListSecretsResponse response : responses) {
                retrieved += response.getItems().size();
                response.getItems().forEach(summary -> {
                    String secretValue = this.getSecretValue(summary.getId());
                    secrets.put(summary.getSecretName(), secretValue);
                });
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("{} secrets where retrieved from Oracle Cloud Vault with OCID: {}", (Object)retrieved, (Object)vault.getOcid());
        }
        Flowable propertySourceFlowable = Flowable.just((Object)PropertySource.of(secrets));
        if (scheduler != null) {
            propertySourceFlowable = propertySourceFlowable.subscribeOn(scheduler);
        }
        propertySources.add(propertySourceFlowable);
        return Flowable.merge(propertySources);
    }

    private ListSecretsRequest buildRequest(String vaultId, String compartmentId, @Nullable String page) {
        ListSecretsRequest.Builder request = ListSecretsRequest.builder().vaultId(vaultId).compartmentId(compartmentId).lifecycleState(SecretSummary.LifecycleState.Active);
        if (page != null) {
            request.page(page);
        }
        return request.build();
    }

    private String getSecretValue(String secretOcid) {
        GetSecretBundleRequest getSecretBundleRequest = GetSecretBundleRequest.builder().secretId(secretOcid).stage(GetSecretBundleRequest.Stage.Current).build();
        GetSecretBundleResponse getSecretBundleResponse = this.secretsClient.getSecretBundle(getSecretBundleRequest);
        Base64SecretBundleContentDetails base64SecretBundleContentDetails = (Base64SecretBundleContentDetails)getSecretBundleResponse.getSecretBundle().getSecretBundleContent();
        byte[] secretValueDecoded = Base64.decodeBase64((String)base64SecretBundleContentDetails.getContent());
        return new String(secretValueDecoded);
    }

    public String getDescription() {
        return "Retrieves secrets from Oracle Cloud vaults";
    }
}

