/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.spring.config;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.spring.config.SpringCloudClientConfiguration;
import io.micronaut.discovery.spring.config.client.ConfigServerPropertySource;
import io.micronaut.discovery.spring.config.client.ConfigServerResponse;
import io.micronaut.discovery.spring.config.client.SpringCloudConfigClient;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
public class SpringCloudConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(SpringCloudConfigurationClient.class);
    private final SpringCloudConfigClient springCloudConfigClient;
    private final SpringCloudClientConfiguration springCloudConfiguration;
    private final ApplicationConfiguration applicationConfiguration;
    private ExecutorService executionService;

    protected SpringCloudConfigurationClient(SpringCloudConfigClient springCloudConfigClient, SpringCloudClientConfiguration springCloudConfiguration, ApplicationConfiguration applicationConfiguration, @Named(value="io") @Nullable ExecutorService executionService) {
        this.springCloudConfigClient = springCloudConfigClient;
        this.springCloudConfiguration = springCloudConfiguration;
        this.applicationConfiguration = applicationConfiguration;
        this.executionService = executionService;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.springCloudConfiguration.getConfiguration().isEnabled()) {
            return Flowable.empty();
        }
        Optional configuredApplicationName = this.applicationConfiguration.getName();
        if (!configuredApplicationName.isPresent()) {
            return Flowable.empty();
        }
        String applicationName = (String)configuredApplicationName.get();
        Set activeNames = environment.getActiveNames();
        String profiles = StringUtils.trimToNull((String)String.join((CharSequence)",", activeNames));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Spring Cloud Config Active: {}", this.springCloudConfiguration.getUri());
            LOG.debug("Application Name: {}, Application Profiles: {}, label: {}", new Object[]{applicationName, profiles, this.springCloudConfiguration.getLabel()});
        }
        Publisher<ConfigServerResponse> responsePublisher = this.springCloudConfiguration.getLabel() == null ? this.springCloudConfigClient.readValues(applicationName, profiles) : this.springCloudConfigClient.readValues(applicationName, profiles, this.springCloudConfiguration.getLabel());
        Flowable configurationValues = Flowable.fromPublisher(responsePublisher).onErrorResumeNext(throwable -> {
            HttpClientResponseException httpClientResponseException;
            if (throwable instanceof HttpClientResponseException && (httpClientResponseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                if (this.springCloudConfiguration.isFailFast()) {
                    return Flowable.error((Throwable)new ConfigurationException("Could not locate PropertySource and the fail fast property is set", throwable));
                }
                return Flowable.empty();
            }
            return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from Spring Cloud: " + throwable.getMessage(), throwable));
        }).flatMap(response -> {
            List<ConfigServerPropertySource> springSources = response.getPropertySources();
            if (CollectionUtils.isEmpty(springSources)) {
                return Flowable.empty();
            }
            int baseOrder = -100;
            ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>(springSources.size());
            for (int i = springSources.size() - 1; i >= 0; --i) {
                ConfigServerPropertySource springSource = springSources.get(i);
                propertySources.add(PropertySource.of((String)springSource.getName(), springSource.getSource(), (int)(++baseOrder)));
            }
            return Flowable.fromIterable(propertySources);
        });
        if (this.executionService != null) {
            return configurationValues.subscribeOn(Schedulers.from((Executor)this.executionService));
        }
        return configurationValues;
    }

    public final String getDescription() {
        return "spring-cloud-config-client";
    }
}

