/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.vault.config;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.discovery.vault.config.VaultClientConfiguration;
import io.micronaut.discovery.vault.config.VaultConfigHttpClient;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
public class VaultConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(VaultConfigurationClient.class);
    private static final String DEFAULT_APPLICATION = "application";
    private final VaultConfigHttpClient<?> configHttpClient;
    private final VaultClientConfiguration vaultClientConfiguration;
    private final ApplicationConfiguration applicationConfiguration;
    private final ExecutorService executorService;

    public VaultConfigurationClient(VaultConfigHttpClient<?> configHttpClient, VaultClientConfiguration vaultClientConfiguration, ApplicationConfiguration applicationConfiguration, @Named(value="io") @Nullable ExecutorService executorService) {
        this.configHttpClient = configHttpClient;
        this.vaultClientConfiguration = vaultClientConfiguration;
        this.applicationConfiguration = applicationConfiguration;
        this.executorService = executorService;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!this.vaultClientConfiguration.getDiscoveryConfiguration().isEnabled()) {
            return Flowable.empty();
        }
        String applicationName = this.applicationConfiguration.getName().orElse(null);
        Set activeNames = environment.getActiveNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vault server endpoint: {}, secret engine version: {}, secret-engine-name: {}", new Object[]{this.vaultClientConfiguration.getUri(), this.vaultClientConfiguration.getKvVersion(), this.vaultClientConfiguration.getSecretEngineName()});
            LOG.debug("Application name: {}, application profiles: {}", (Object)applicationName, (Object)activeNames);
        }
        ArrayList propertySources = new ArrayList();
        String token = this.vaultClientConfiguration.getToken();
        String engine = this.vaultClientConfiguration.getSecretEngineName();
        Scheduler scheduler = this.executorService != null ? Schedulers.from((Executor)this.executorService) : null;
        this.buildVaultKeys(applicationName, activeNames).forEach((key, value) -> {
            Flowable propertySourceFlowable = Flowable.fromPublisher(this.configHttpClient.readConfigurationValues(token, engine, (String)value)).filter(data -> !data.getSecrets().isEmpty()).map(data -> PropertySource.of((String)value, data.getSecrets(), (int)key)).onErrorResumeNext(throwable -> {
                Throwable t = (Throwable)throwable;
                if (t instanceof HttpClientResponseException) {
                    if (((HttpClientResponseException)t).getStatus() == HttpStatus.NOT_FOUND && this.vaultClientConfiguration.isFailFast()) {
                        return Flowable.error((Throwable)new ConfigurationException("Could not locate PropertySource and the fail fast property is set", t));
                    }
                    return Flowable.empty();
                }
                return Flowable.error((Throwable)new ConfigurationException("Error reading distributed configuration from Vault: " + t.getMessage(), t));
            });
            if (scheduler != null) {
                propertySourceFlowable = propertySourceFlowable.subscribeOn(scheduler);
            }
            propertySources.add(propertySourceFlowable);
        });
        return Flowable.merge(propertySources);
    }

    protected Map<Integer, String> buildVaultKeys(@Nullable String applicationName, Set<String> environmentNames) {
        HashMap<Integer, String> vaultKeys = new HashMap<Integer, String>();
        int baseOrder = -100;
        int envOrder = baseOrder + 50;
        vaultKeys.put(++baseOrder, DEFAULT_APPLICATION);
        if (applicationName != null) {
            vaultKeys.put(++baseOrder, applicationName);
        }
        for (String activeName : environmentNames) {
            vaultKeys.put(++envOrder, "application/" + activeName);
            if (applicationName == null) continue;
            vaultKeys.put(++envOrder, applicationName + "/" + activeName);
        }
        return vaultKeys;
    }

    public String getDescription() {
        return this.configHttpClient.getDescription();
    }
}

