/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.vault.config.v2;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.discovery.vault.config.VaultClientConfiguration;
import io.micronaut.discovery.vault.config.VaultConfigHttpClient;
import io.micronaut.discovery.vault.config.v2.VaultResponseV2;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.retry.annotation.Retryable;
import org.reactivestreams.Publisher;

@Client(value="${vault.client.uri}", configuration=VaultClientConfiguration.class)
@BootstrapContextCompatible
public interface VaultConfigHttpClientV2
extends VaultConfigHttpClient<VaultResponseV2> {
    public static final String CLIENT_DESCRIPTION = "vault-config-client-v2";

    @Override
    @Get(value="/v1/{backend}/data/{vaultKey}")
    @Produces(single=true)
    @Retryable(attempts="${vault.client.config.retry-count:3}", delay="${vault.client.config.retry-delay:1s}")
    public Publisher<VaultResponseV2> readConfigurationValues(@Header(value="X-Vault-Token") @NonNull String var1, @NonNull String var2, @NonNull String var3);

    @Override
    default public String getDescription() {
        return CLIENT_DESCRIPTION;
    }
}

