/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.cloud.AbstractComputeInstanceMetadata;
import io.micronaut.http.HttpMethod;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class ComputeInstanceMetadataResolverUtils {
    public static com.fasterxml.jackson.databind.JsonNode readMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, ObjectMapper objectMapper, Map<String, String> requestProperties) throws IOException {
        try (InputStream in = ComputeInstanceMetadataResolverUtils.openMetadataUrl(url, connectionTimeoutMs, readTimeoutMs, requestProperties);){
            com.fasterxml.jackson.databind.JsonNode jsonNode = objectMapper.readTree(in);
            return jsonNode;
        }
    }

    public static JsonNode readMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, JsonNodeTreeCodec treeCodec, JsonFactory jsonFactory, Map<String, String> requestProperties) throws IOException {
        try (InputStream in = ComputeInstanceMetadataResolverUtils.openMetadataUrl(url, connectionTimeoutMs, readTimeoutMs, requestProperties);){
            JsonNode jsonNode;
            block12: {
                JsonParser parser = jsonFactory.createParser(in);
                try {
                    jsonNode = treeCodec.readTree(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return jsonNode;
        }
    }

    public static JsonNode readMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, JsonMapper jsonMapper, Map<String, String> requestProperties) throws IOException {
        try (InputStream in = ComputeInstanceMetadataResolverUtils.openMetadataUrl(url, connectionTimeoutMs, readTimeoutMs, requestProperties);){
            JsonNode jsonNode = (JsonNode)jsonMapper.readValue(in, Argument.of(JsonNode.class));
            return jsonNode;
        }
    }

    private static InputStream openMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, Map<String, String> requestProperties) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            urlConnection.connect();
            return urlConnection.getInputStream();
        }
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        requestProperties.forEach(uc::setRequestProperty);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod(HttpMethod.GET.name());
        uc.setDoOutput(true);
        return uc.getInputStream();
    }

    public static void populateMetadata(AbstractComputeInstanceMetadata instanceMetadata, JsonNode metadata) {
        if (metadata != null) {
            HashMap finalMetadata = CollectionUtils.newHashMap((int)metadata.size());
            for (Map.Entry entry : metadata.entries()) {
                JsonNode value = (JsonNode)entry.getValue();
                if (!value.isString()) continue;
                finalMetadata.put((String)entry.getKey(), value.getStringValue());
            }
            instanceMetadata.setMetadata(finalMetadata);
        }
    }

    public static Optional<String> stringValue(com.fasterxml.jackson.databind.JsonNode json, String key) {
        return Optional.ofNullable(json.findValue(key)).map(com.fasterxml.jackson.databind.JsonNode::asText);
    }

    public static void populateMetadata(AbstractComputeInstanceMetadata instanceMetadata, Map<?, ?> metadata) {
        if (metadata != null) {
            HashMap finalMetadata = CollectionUtils.newHashMap((int)metadata.size());
            for (Map.Entry<?, ?> entry : metadata.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String strValue = (String)value;
                finalMetadata.put(key.toString(), strValue);
            }
            instanceMetadata.setMetadata(finalMetadata);
        }
    }
}

