/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.function.executor.AbstractFunctionExecutor;

public abstract class MicronautRequestHandler<I, O>
extends AbstractFunctionExecutor<I, O, Context>
implements RequestHandler<I, O> {
    public final O handleRequest(I input, Context context) {
        ApplicationContext applicationContext = this.buildApplicationContext(context);
        this.startEnvironment(applicationContext);
        return (O)((MicronautRequestHandler)((Object)applicationContext.inject((Object)this))).execute(input);
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        ApplicationContext applicationContext = super.buildApplicationContext((Object)context);
        if (context != null) {
            MicronautRequestHandler.registerContextBeans(context, applicationContext);
        }
        return applicationContext;
    }

    static void registerContextBeans(Context context, ApplicationContext applicationContext) {
        CognitoIdentity identity;
        ClientContext clientContext;
        applicationContext.registerSingleton((Object)context);
        LambdaLogger logger = context.getLogger();
        if (logger != null) {
            applicationContext.registerSingleton((Object)logger);
        }
        if ((clientContext = context.getClientContext()) != null) {
            applicationContext.registerSingleton((Object)clientContext);
        }
        if ((identity = context.getIdentity()) != null) {
            applicationContext.registerSingleton((Object)identity);
        }
    }
}

