/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.function.aws.MicronautLambdaContext;
import io.micronaut.function.executor.AbstractFunctionExecutor;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class MicronautRequestHandler<I, O>
extends AbstractFunctionExecutor<I, O, Context>
implements RequestHandler<I, O>,
MicronautLambdaContext {
    private final Class<I> inputType = this.initTypeArgument();

    public MicronautRequestHandler() {
        this.buildApplicationContext(null);
        this.applicationContext.inject((Object)this);
    }

    public final O handleRequest(I input, Context context) {
        if (context != null) {
            MicronautRequestHandler.registerContextBeans(context, this.applicationContext);
        }
        if (!this.inputType.isInstance(input)) {
            input = this.convertInput(input);
        }
        return (O)this.execute(input);
    }

    protected I convertInput(Object input) {
        ArgumentConversionContext cc = ConversionContext.of(this.inputType);
        Optional converted = this.applicationContext.getConversionService().convert(input, cc);
        return (I)converted.orElseThrow(() -> new IllegalArgumentException("Unconvertible input: " + input, cc.getLastError().map(ConversionError::getCause).orElse(null)));
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        this.applicationContext = super.buildApplicationContext((Object)context);
        this.startEnvironment(this.applicationContext);
        return this.applicationContext;
    }

    @Nonnull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        ApplicationContextBuilder builder = super.newApplicationContextBuilder();
        builder.environments(new String[]{"lambda"});
        builder.eagerInitSingletons(true);
        return builder;
    }

    static void registerContextBeans(Context context, ApplicationContext applicationContext) {
        CognitoIdentity identity;
        ClientContext clientContext;
        applicationContext.registerSingleton((Object)context);
        LambdaLogger logger = context.getLogger();
        if (logger != null) {
            applicationContext.registerSingleton((Object)logger);
        }
        if ((clientContext = context.getClientContext()) != null) {
            applicationContext.registerSingleton((Object)clientContext);
        }
        if ((identity = context.getIdentity()) != null) {
            applicationContext.registerSingleton((Object)identity);
        }
    }

    private Class initTypeArgument() {
        Object[] args = GenericTypeUtils.resolveSuperTypeGenericArguments(this.getClass(), MicronautRequestHandler.class);
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            return args[0];
        }
        return Object.class;
    }
}

