/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.http;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClient;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Singleton
public class HttpFunctionExecutor<I, O>
implements FunctionInvoker<I, O>,
Closeable,
FunctionInvokerChooser {
    private final ConversionService conversionService;
    private final HttpClient httpClient;

    public HttpFunctionExecutor(ConversionService conversionService, HttpClient httpClient) {
        this.conversionService = conversionService;
        this.httpClient = httpClient;
    }

    @Override
    public O invoke(FunctionDefinition definition, I input, Argument<O> outputType) {
        Class outputJavaType;
        Optional<URI> opt = definition.getURI();
        if (!opt.isPresent()) {
            throw new FunctionNotFoundException(definition.getName());
        }
        URI uri = opt.get();
        MutableHttpRequest request = input == null ? HttpRequest.GET((String)uri.toString()) : HttpRequest.POST((String)uri.toString(), input);
        if (input != null && ClassUtils.isJavaLangType(input.getClass())) {
            request.contentType(MediaType.TEXT_PLAIN_TYPE);
        }
        if (ClassUtils.isJavaLangType((Class)(outputJavaType = outputType.getType()))) {
            request.accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE});
        }
        if (Publishers.isConvertibleToPublisher((Class)outputJavaType)) {
            Publisher publisher = this.httpClient.retrieve((HttpRequest)request, outputType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
            return (O)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)publisher, (Class)outputJavaType);
        }
        if (outputType.isVoid()) {
            this.httpClient.toBlocking().exchange((HttpRequest)request);
            return null;
        }
        return (O)this.httpClient.toBlocking().retrieve((HttpRequest)request, outputType);
    }

    public <I1, O2> Optional<FunctionInvoker<I1, O2>> choose(FunctionDefinition definition) {
        if (definition.getURI().isPresent()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.httpClient.close();
    }
}

