/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.executor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.util.StringUtils;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.inject.ExecutableMethod;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.PreDestroy;

class AbstractExecutor<C>
implements ApplicationContextProvider,
Closeable,
AutoCloseable {
    protected ApplicationContext applicationContext;

    AbstractExecutor() {
    }

    protected ExecutableMethod<Object, Object> resolveFunction(LocalFunctionRegistry localFunctionRegistry, String functionName) {
        Optional<Object> registeredMethod = functionName == null ? localFunctionRegistry.findFirst() : localFunctionRegistry.find(functionName);
        return registeredMethod.orElseThrow(() -> new IllegalStateException("No function found for name: " + functionName));
    }

    protected String resolveFunctionName(Environment env) {
        return (String)env.getProperty("micronaut.function.name", String.class, (Object)null);
    }

    protected ApplicationContext buildApplicationContext(@Nullable C context) {
        if (this.applicationContext == null) {
            String name;
            ApplicationContextBuilder contextBuilder = this.newApplicationContextBuilder();
            Package pkg = this.getClass().getPackage();
            if (pkg != null && StringUtils.isNotEmpty((CharSequence)(name = pkg.getName()))) {
                contextBuilder.packages(new String[]{name});
            }
            this.applicationContext = contextBuilder.build();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.applicationContext != null && this.applicationContext.isRunning()) {
                    this.applicationContext.close();
                    this.applicationContext = null;
                }
            }));
        }
        return this.applicationContext;
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return ApplicationContext.build((String[])new String[]{"function"});
    }

    protected Environment startEnvironment(ApplicationContext applicationContext) {
        if (!applicationContext.isRunning()) {
            if (this instanceof PropertySource) {
                applicationContext.getEnvironment().addPropertySource((PropertySource)this);
            }
            return applicationContext.start().getEnvironment();
        }
        return applicationContext.getEnvironment();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        try {
            this.applicationContext.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

