/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.graal.reflect;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GraalTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = -200;
    protected static Set<String> packages = new HashSet<String>();
    protected static Map<String, Map<String, Object>> classes = new HashMap<String, Map<String, Object>>();
    protected static Set<String> arrays = new HashSet<String>();
    private static final TypeHint.AccessType[] DEFAULT_ACCESS_TYPE = new TypeHint.AccessType[]{TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS};
    private static final String REFLECTION_CONFIG_JSON = "reflect-config.json";
    private static final String BASE_RESOURCE_CONFIG_JSON = "src/main/graal/resource-config.json";
    private static final String RESOURCE_CONFIG_JSON = "resource-config.json";
    private static final String RESOURCES_DIR = "src/main/resources";
    private static final String RESOURCES = "resources";
    private static final String PATTERN = "pattern";
    private static final String META_INF = "META-INF";
    private static final List<String> EXCLUDED_META_INF_DIRECTORIES = Arrays.asList("native-image", "services");
    private static final String BASE_REFLECT_JSON = "src/main/graal/reflect.json";
    private static final String ALL_PUBLIC_METHODS = "allPublicMethods";
    private static final String ALL_DECLARED_FIELDS = "allDeclaredFields";
    private static final String NAME = "name";
    private static final String ALL_DECLARED_CONSTRUCTORS = "allDeclaredConstructors";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private boolean isSubclass = this.getClass() != GraalTypeElementVisitor.class;
    private boolean executed = false;

    public int getOrder() {
        return -200;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!this.isSubclass && !element.hasStereotype(Deprecated.class)) {
            if (element.hasAnnotation(Introspected.class)) {
                String[] introspectedClasses;
                packages.add(element.getPackageName());
                String beanName = element.getName();
                this.addBean(beanName);
                this.resolveClassData(beanName + "[]");
                for (String introspectedClass : introspectedClasses = element.getValue(Introspected.class, "classes", String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY)) {
                    this.addBean(introspectedClass);
                }
            } else if (element.hasAnnotation(TypeHint.class)) {
                packages.add(element.getPackageName());
                String[] introspectedClasses = element.stringValues(TypeHint.class);
                TypeHint typeHint = (TypeHint)element.synthesize(TypeHint.class);
                TypeHint.AccessType[] accessTypes = DEFAULT_ACCESS_TYPE;
                if (typeHint != null) {
                    accessTypes = typeHint.accessType();
                }
                this.processClasses(accessTypes, introspectedClasses);
                this.processClasses(accessTypes, element.getValue(TypeHint.class, "typeNames", String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY));
            }
        }
    }

    private void addBean(String beanName) {
        this.resolveClassData(beanName).putAll(CollectionUtils.mapOf((Object[])new Object[]{ALL_PUBLIC_METHODS, true, ALL_DECLARED_CONSTRUCTORS, true, ALL_DECLARED_FIELDS, true}));
    }

    public void visitField(FieldElement element, VisitorContext context) {
        if (element.hasStereotype(ReflectiveAccess.class)) {
            ClassElement dt = element.getDeclaringType();
            packages.add(dt.getPackageName());
            Map<String, Object> json = this.resolveClassData(this.resolveName(dt));
            List fields = json.computeIfAbsent("fields", s -> new ArrayList());
            fields.add(Collections.singletonMap(NAME, element.getName()));
        }
    }

    private String resolveName(ClassElement classElement) {
        if (classElement.isArray()) {
            return classElement.getName() + "[]";
        }
        return classElement.getName();
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (!this.isSubclass && element.hasDeclaredStereotype(ReflectiveAccess.class)) {
            this.processMethodElement(element);
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (!this.isSubclass) {
            if (element.hasAnnotation(Creator.class)) {
                ClassElement declaringType = element.getDeclaringType();
                packages.add(declaringType.getPackageName());
                this.addBean(declaringType.getName());
            } else if (element.hasAnnotation(ReflectiveAccess.class)) {
                this.processMethodElement((MethodElement)element);
            }
        }
    }

    private void processMethodElement(MethodElement element) {
        String methodName = element.getName();
        packages.add(element.getDeclaringType().getPackageName());
        Map<String, Object> json = this.resolveClassData(element.getDeclaringType().getName());
        List methods = json.computeIfAbsent("methods", s -> new ArrayList());
        List params = Arrays.stream(element.getParameters()).map(ParameterElement::getType).filter(Objects::nonNull).map(this::resolveName).collect(Collectors.toList());
        Map newMap = CollectionUtils.mapOf((Object[])new Object[]{NAME, methodName, "parameterTypes", params});
        if (!methods.contains(newMap)) {
            methods.add(newMap);
        }
    }

    private void processClasses(TypeHint.AccessType[] accessType, String ... introspectedClasses) {
        for (String introspectedClass : introspectedClasses) {
            for (TypeHint.AccessType type : accessType) {
                if (type == TypeHint.AccessType.ALL_PUBLIC) {
                    for (String aClass : introspectedClasses) {
                        this.addBean(aClass);
                    }
                    return;
                }
                Map<String, Object> json = this.resolveClassData(introspectedClass);
                json.put(NameUtils.camelCase((String)type.name().toLowerCase()), true);
            }
        }
    }

    public final void finish(VisitorContext visitorContext) {
        if (!this.executed && !this.isSubclass) {
            this.executed = true;
            this.generateNativeImageProperties(visitorContext);
            this.generateResourceConfig(visitorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateNativeImageProperties(VisitorContext visitorContext) {
        List json;
        Optional projectDir = visitorContext.getProjectDir();
        File userReflectJsonFile = projectDir.map(projectPath -> Paths.get(projectPath.toString(), BASE_REFLECT_JSON).toFile()).orElse(null);
        if (userReflectJsonFile != null && userReflectJsonFile.exists()) {
            try {
                json = (List)MAPPER.readValue(userReflectJsonFile, (TypeReference)new TypeReference<List<Map>>(){});
            }
            catch (Throwable e) {
                visitorContext.fail("Error parsing base reflect.json: src/main/graal/reflect.json", null);
                return;
            }
        } else {
            json = new ArrayList();
        }
        if (CollectionUtils.isEmpty(classes) && CollectionUtils.isEmpty(arrays) && CollectionUtils.isEmpty(json)) {
            return;
        }
        try {
            String path = this.buildNativeImagePath(visitorContext);
            String reflectFile = path + REFLECTION_CONFIG_JSON;
            Optional generatedFile = visitorContext.visitMetaInfFile(reflectFile);
            generatedFile.ifPresent(gf -> {
                for (Map<String, Object> value : classes.values()) {
                    json.add(value);
                }
                for (String array : arrays) {
                    json.add(CollectionUtils.mapOf((Object[])new Object[]{NAME, "[L" + array.substring(0, array.length() - 2) + ";", ALL_DECLARED_CONSTRUCTORS, true}));
                }
                ObjectWriter writer = MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter());
                try (Writer w = gf.openWriter();){
                    visitorContext.info("Writing reflect-config.json file to destination: " + gf.getName());
                    writer.writeValue(w, (Object)json);
                }
                catch (IOException e) {
                    visitorContext.fail("Error writing reflect-config.json: " + e.getMessage(), null);
                }
            });
        }
        finally {
            classes.clear();
            arrays.clear();
        }
    }

    private void generateResourceConfig(VisitorContext visitorContext) {
        ObjectWriter writer = MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter());
        Optional projectDir = visitorContext.getProjectDir();
        if (projectDir.isPresent()) {
            Map json;
            File f = Paths.get(((Path)projectDir.get()).toString(), BASE_RESOURCE_CONFIG_JSON).toFile();
            if (f.exists()) {
                try {
                    json = (Map)MAPPER.readValue(f, (TypeReference)new TypeReference<Map>(){});
                }
                catch (Throwable e) {
                    visitorContext.fail("Error parsing base resource-config.json: src/main/graal/resource-config.json", null);
                    return;
                }
            } else {
                json = new HashMap();
            }
            try {
                Set<String> resourceFiles = this.findResourceFiles(Paths.get(((Path)projectDir.get()).toString(), RESOURCES_DIR).toFile(), new ArrayList<String>());
                if (!resourceFiles.isEmpty()) {
                    String path = this.buildNativeImagePath(visitorContext);
                    String resourcesFile = path + RESOURCE_CONFIG_JSON;
                    Optional generatedFile = visitorContext.visitMetaInfFile(resourcesFile);
                    generatedFile.ifPresent(gf -> {
                        resourceFiles.addAll(visitorContext.getGeneratedResources());
                        List resourceList = resourceFiles.stream().map(this::mapToGraalResource).collect(Collectors.toList());
                        resourceList.addAll(json.getOrDefault(RESOURCES, Collections.EMPTY_LIST));
                        json.put(RESOURCES, resourceList);
                        try (Writer w = gf.openWriter();){
                            visitorContext.info("Writing resource-config.json file to destination: " + gf.getName());
                            writer.writeValue(w, (Object)json);
                        }
                        catch (IOException e) {
                            visitorContext.fail("Error writing resource-config.json: " + e.getMessage(), null);
                        }
                    });
                }
            }
            catch (Exception e) {
                visitorContext.fail("There was an error generating resource-config.json: " + e.getMessage(), null);
            }
        }
    }

    private Map mapToGraalResource(String resourceName) {
        return resourceName.contains("*") ? CollectionUtils.mapOf((Object[])new Object[]{PATTERN, resourceName}) : CollectionUtils.mapOf((Object[])new Object[]{PATTERN, "\\Q" + resourceName + "\\E"});
    }

    private Set<String> findResourceFiles(File folder, List<String> filePath) {
        File[] files;
        HashSet<String> resourceFiles = new HashSet<String>();
        if (filePath == null) {
            filePath = new ArrayList<String>();
        }
        if (folder.exists() && (files = folder.listFiles()) != null) {
            boolean isMetaInfDirectory = folder.getName().equals(META_INF);
            for (File element : files) {
                boolean isExcludedDirectory = EXCLUDED_META_INF_DIRECTORIES.contains(element.getName());
                if (isMetaInfDirectory && isExcludedDirectory) continue;
                if (element.isDirectory()) {
                    ArrayList<String> paths = new ArrayList<String>(filePath);
                    paths.add(element.getName());
                    resourceFiles.addAll(this.findResourceFiles(element, paths));
                    continue;
                }
                String joinedDirectories = String.join((CharSequence)"/", filePath);
                String elementName = joinedDirectories.isEmpty() ? element.getName() : joinedDirectories + "/" + element.getName();
                resourceFiles.add(elementName);
            }
        }
        return resourceFiles;
    }

    private String buildNativeImagePath(VisitorContext visitorContext) {
        String group = (String)visitorContext.getOptions().get("micronaut.processing.group");
        String module = (String)visitorContext.getOptions().get("micronaut.processing.module");
        if (group != null && module != null) {
            return "native-image/" + group + "/" + module + "/";
        }
        String basePackage = packages.stream().distinct().min(Comparator.comparingInt(String::length)).orElse("io.micronaut");
        if (basePackage.startsWith("io.micronaut.")) {
            module = basePackage.substring("io.micronaut.".length()).replace('.', '-');
            basePackage = "io.micronaut";
        } else if (basePackage.contains(".")) {
            int i = basePackage.lastIndexOf(46);
            module = basePackage.substring(i + 1);
            basePackage = basePackage.substring(0, i);
        } else {
            module = basePackage;
        }
        return "native-image/" + basePackage + "/" + module + "/";
    }

    private Map<String, Object> resolveClassData(String introspectedClass) {
        return classes.computeIfAbsent(introspectedClass, s -> {
            HashMap<String, String> map = new HashMap<String, String>(5);
            map.put(NAME, (String)s);
            return map;
        });
    }
}

