/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.graal.reflect;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Import;
import io.micronaut.context.visitor.BeanImportVisitor;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GraalTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = -200;
    protected static Set<String> packages = new HashSet<String>();
    protected static Map<String, Map<String, Object>> classes = new HashMap<String, Map<String, Object>>();
    protected static Set<String> arrays = new HashSet<String>();
    protected static Set<ClassElement> originatingElements = new HashSet<ClassElement>();
    private static final TypeHint.AccessType[] DEFAULT_ACCESS_TYPE = new TypeHint.AccessType[]{TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS};
    private static final String REFLECTION_CONFIG_JSON = "reflect-config.json";
    private static final String BASE_REFLECT_JSON = "src/main/graal/reflect.json";
    private static final String ALL_PUBLIC_METHODS = "allPublicMethods";
    private static final String ALL_DECLARED_FIELDS = "allDeclaredFields";
    private static final String NAME = "name";
    private static final String ALL_DECLARED_CONSTRUCTORS = "allDeclaredConstructors";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private boolean isSubclass = this.getClass() != GraalTypeElementVisitor.class;
    private boolean executed = false;

    public int getOrder() {
        return -200;
    }

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{ReflectiveAccess.class.getName(), TypeHint.class.getName(), Import.class.getName(), "javax.persistence.Entity", "jakarta.persistence.Entity", "javax.inject.Inject", Inject.class.getName()});
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.AGGREGATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!this.isSubclass && !element.hasStereotype(Deprecated.class)) {
            ClassElement enclosingType;
            MethodElement me;
            if (element.hasAnnotation(ReflectiveAccess.class)) {
                originatingElements.add(element);
                packages.add(element.getPackageName());
                String beanName = element.getName();
                this.addBean(beanName);
                this.resolveClassData(beanName + "[]");
            }
            if (element.hasAnnotation(TypeHint.class)) {
                originatingElements.add(element);
                packages.add(element.getPackageName());
                String[] introspectedClasses = element.stringValues(TypeHint.class);
                TypeHint typeHint = (TypeHint)element.synthesize(TypeHint.class);
                TypeHint.AccessType[] accessTypes = DEFAULT_ACCESS_TYPE;
                if (typeHint != null) {
                    accessTypes = typeHint.accessType();
                }
                this.processClasses(accessTypes, introspectedClasses);
                this.processClasses(accessTypes, element.getValue(TypeHint.class, "typeNames", String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY));
            }
            if (element.hasAnnotation(Import.class)) {
                List beanElements = BeanImportVisitor.collectInjectableElements((ClassElement)element, (VisitorContext)context);
                for (ClassElement beanElement : beanElements) {
                    MethodElement constructor = beanElement.getPrimaryConstructor().orElse(null);
                    if (constructor != null && !constructor.isPublic()) {
                        this.processMethodElement(constructor);
                    }
                    ElementQuery reflectiveMethodQuery = ElementQuery.ALL_METHODS.onlyInstance().onlyConcrete().onlyInjected().modifiers(elementModifiers -> !elementModifiers.contains(ElementModifier.PUBLIC));
                    List reflectiveMethods = beanElement.getEnclosedElements(reflectiveMethodQuery);
                    reflectiveMethods.forEach(this::processMethodElement);
                    ElementQuery reflectiveFieldQuery = ElementQuery.ALL_FIELDS.onlyInstance().onlyInjected().modifiers(elementModifiers -> !elementModifiers.contains(ElementModifier.PUBLIC));
                    List reflectiveFields = beanElement.getEnclosedElements(reflectiveFieldQuery);
                    reflectiveFields.forEach(this::processFieldElement);
                }
            } else if ((element.hasStereotype(Bean.class) || element.hasStereotype("javax.inject.Scope") || element.hasStereotype("javax.inject.Qualifier")) && (me = (MethodElement)element.getPrimaryConstructor().orElse(null)) != null && me.isPrivate() && !me.hasAnnotation(ReflectiveAccess.class)) {
                this.processMethodElement(me);
            }
            if (element.isInner() && (enclosingType = (ClassElement)element.getEnclosingType().orElse(null)) != null && enclosingType.hasAnnotation(ReflectiveAccess.class)) {
                originatingElements.add(enclosingType);
                packages.add(enclosingType.getPackageName());
                String beanName = element.getName();
                this.addBean(beanName);
                this.resolveClassData(beanName + "[]");
            }
        }
    }

    private void addBean(String beanName) {
        this.resolveClassData(beanName).putAll(CollectionUtils.mapOf((Object[])new Object[]{ALL_PUBLIC_METHODS, true, ALL_DECLARED_CONSTRUCTORS, true, ALL_DECLARED_FIELDS, true}));
    }

    public void visitField(FieldElement element, VisitorContext context) {
        if (element.hasStereotype(ReflectiveAccess.class)) {
            this.processFieldElement(element);
        } else if (element.hasDeclaredAnnotation("javax.inject.Inject") && element.isPrivate()) {
            this.processFieldElement(element);
        }
    }

    private void processFieldElement(FieldElement element) {
        ClassElement dt = element.getDeclaringType();
        originatingElements.add(dt);
        packages.add(dt.getPackageName());
        Map<String, Object> json = this.resolveClassData(this.resolveName(dt));
        List fields = json.computeIfAbsent("fields", s -> new ArrayList());
        fields.add(Collections.singletonMap(NAME, element.getName()));
    }

    private String resolveName(ClassElement classElement) {
        if (classElement.isArray()) {
            return classElement.getName() + "[]";
        }
        return classElement.getName();
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (!this.isSubclass && element.hasDeclaredStereotype(ReflectiveAccess.class)) {
            this.processMethodElement(element);
        } else if (element.hasDeclaredAnnotation("javax.inject.Inject") && element.isPrivate()) {
            this.processMethodElement(element);
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (!this.isSubclass) {
            if (element.hasAnnotation(Creator.class) && element.isPrivate()) {
                ClassElement declaringType = element.getDeclaringType();
                originatingElements.add(declaringType);
                packages.add(declaringType.getPackageName());
                this.addBean(declaringType.getName());
            } else if (element.hasAnnotation(ReflectiveAccess.class) && !element.getDeclaringType().isEnum()) {
                this.processMethodElement((MethodElement)element);
            }
        }
    }

    private void processMethodElement(MethodElement element) {
        String methodName = element.getName();
        ClassElement declaringType = element.getDeclaringType();
        originatingElements.add(declaringType);
        packages.add(declaringType.getPackageName());
        Map<String, Object> json = this.resolveClassData(declaringType.getName());
        List methods = json.computeIfAbsent("methods", s -> new ArrayList());
        List params = Arrays.stream(element.getParameters()).map(ParameterElement::getType).filter(Objects::nonNull).map(this::resolveName).collect(Collectors.toList());
        Map newMap = CollectionUtils.mapOf((Object[])new Object[]{NAME, methodName, "parameterTypes", params});
        if (!methods.contains(newMap)) {
            methods.add(newMap);
        }
    }

    private void processClasses(TypeHint.AccessType[] accessType, String ... introspectedClasses) {
        for (String introspectedClass : introspectedClasses) {
            for (TypeHint.AccessType type : accessType) {
                if (type == TypeHint.AccessType.ALL_PUBLIC) {
                    for (String aClass : introspectedClasses) {
                        this.addBean(aClass);
                    }
                    return;
                }
                Map<String, Object> json = this.resolveClassData(introspectedClass);
                json.put(NameUtils.camelCase((String)type.name().toLowerCase()), true);
            }
        }
    }

    public final void finish(VisitorContext visitorContext) {
        if (!this.executed && !this.isSubclass) {
            this.executed = true;
            this.generateNativeImageProperties(visitorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateNativeImageProperties(VisitorContext visitorContext) {
        List json;
        Optional projectDir = visitorContext.getProjectDir();
        File userReflectJsonFile = projectDir.map(projectPath -> Paths.get(projectPath.toString(), BASE_REFLECT_JSON).toFile()).orElse(null);
        if (userReflectJsonFile != null && userReflectJsonFile.exists()) {
            try {
                json = (List)MAPPER.readValue(userReflectJsonFile, (TypeReference)new TypeReference<List<Map>>(){});
            }
            catch (Throwable e) {
                visitorContext.fail("Error parsing base reflect.json: src/main/graal/reflect.json", null);
                return;
            }
        } else {
            json = new ArrayList();
        }
        if (CollectionUtils.isEmpty(classes) && CollectionUtils.isEmpty(arrays) && CollectionUtils.isEmpty(json)) {
            return;
        }
        try {
            String path = this.buildNativeImagePath(visitorContext);
            String reflectFile = path + REFLECTION_CONFIG_JSON;
            Optional generatedFile = visitorContext.visitMetaInfFile(reflectFile, originatingElements.toArray(Element.EMPTY_ELEMENT_ARRAY));
            generatedFile.ifPresent(gf -> {
                for (Map<String, Object> value : classes.values()) {
                    json.add(value);
                }
                for (String array : arrays) {
                    json.add(CollectionUtils.mapOf((Object[])new Object[]{NAME, "[L" + array.substring(0, array.length() - 2) + ";", ALL_DECLARED_CONSTRUCTORS, true}));
                }
                ObjectWriter writer = MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter());
                try (Writer w = gf.openWriter();){
                    visitorContext.info("Writing reflect-config.json file to destination: " + gf.getName());
                    writer.writeValue(w, (Object)json);
                }
                catch (IOException e) {
                    visitorContext.fail("Error writing reflect-config.json: " + e.getMessage(), null);
                }
            });
        }
        finally {
            packages.clear();
            classes.clear();
            arrays.clear();
            originatingElements.clear();
        }
    }

    private String buildNativeImagePath(VisitorContext visitorContext) {
        String group = (String)visitorContext.getOptions().get("micronaut.processing.group");
        String module = (String)visitorContext.getOptions().get("micronaut.processing.module");
        if (group != null && module != null) {
            return "native-image/" + group + "/" + module + "/";
        }
        String basePackage = packages.stream().distinct().min(Comparator.comparingInt(String::length)).orElse("io.micronaut");
        if (basePackage.startsWith("io.micronaut.")) {
            module = basePackage.substring("io.micronaut.".length()).replace('.', '-');
            basePackage = "io.micronaut";
        } else if (basePackage.contains(".")) {
            int i = basePackage.lastIndexOf(46);
            module = basePackage.substring(i + 1);
            basePackage = basePackage.substring(0, i);
        } else {
            module = basePackage;
        }
        return "native-image/" + basePackage + "/" + module + "/";
    }

    private Map<String, Object> resolveClassData(String introspectedClass) {
        return classes.computeIfAbsent(introspectedClass, s -> {
            HashMap<String, String> map = new HashMap<String, String>(5);
            map.put(NAME, (String)s);
            return map;
        });
    }
}

