/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.graal.reflect;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Import;
import io.micronaut.context.visitor.BeanImportVisitor;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectionConfig;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.graal.reflect.GraalReflectionMetadataWriter;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GraalTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = -200;
    private static final TypeHint.AccessType[] DEFAULT_ACCESS_TYPE = new TypeHint.AccessType[]{TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS};
    private final boolean isSubclass = this.getClass() != GraalTypeElementVisitor.class;
    private final Set<ClassElement> originatingElements = new HashSet<ClassElement>();

    public int getOrder() {
        return -200;
    }

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{ReflectiveAccess.class.getName(), TypeHint.class.getName(), Import.class.getName(), "javax.persistence.Entity", "jakarta.persistence.Entity", "javax.inject.Inject", Inject.class.getName(), ReflectionConfig.class.getName(), ReflectionConfig.ReflectionConfigList.class.getName()});
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void finish(VisitorContext visitorContext) {
        this.originatingElements.clear();
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!this.isSubclass && !element.hasStereotype(Deprecated.class)) {
            ClassElement enclosingType;
            if (this.originatingElements.contains(element)) {
                return;
            }
            LinkedHashMap<String, ReflectionConfigData> reflectiveClasses = new LinkedHashMap<String, ReflectionConfigData>();
            List values = element.getAnnotationValuesByType(ReflectionConfig.class);
            for (AnnotationValue value : values) {
                value.stringValue("type").ifPresent(n -> {
                    ReflectionConfigData data = this.resolveClassData((String)n, (Map<String, ReflectionConfigData>)reflectiveClasses);
                    data.accessTypes.addAll(Arrays.asList((TypeHint.AccessType[])value.enumValues("accessType", TypeHint.AccessType.class)));
                    data.methods.addAll(value.getAnnotations("methods"));
                    data.fields.addAll(value.getAnnotations("fields"));
                });
            }
            if (element.hasAnnotation(ReflectiveAccess.class)) {
                String beanName = element.getName();
                this.addBean(beanName, reflectiveClasses);
                element.getDefaultConstructor().ifPresent(constructor -> this.processMethodElement((MethodElement)constructor, (Map<String, ReflectionConfigData>)reflectiveClasses));
                this.resolveClassData(beanName + "[]", reflectiveClasses);
            }
            element.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(ann -> ann.hasAnnotation(ReflectiveAccess.class))).forEach(m -> this.processMethodElement((MethodElement)m, (Map<String, ReflectionConfigData>)reflectiveClasses));
            element.getEnclosedElements(ElementQuery.ALL_FIELDS.annotated(ann -> ann.hasAnnotation(ReflectiveAccess.class))).forEach(m -> this.processFieldElement((FieldElement)m, (Map<String, ReflectionConfigData>)reflectiveClasses));
            if (!element.isInner()) {
                element.getEnclosedElements(ElementQuery.ALL_INNER_CLASSES).forEach(c -> this.visitClass((ClassElement)c, context));
            }
            if (element.hasAnnotation(TypeHint.class)) {
                String[] introspectedClasses = element.stringValues(TypeHint.class);
                TypeHint typeHint = (TypeHint)element.synthesize(TypeHint.class);
                TypeHint.AccessType[] accessTypes = DEFAULT_ACCESS_TYPE;
                if (typeHint != null) {
                    accessTypes = typeHint.accessType();
                }
                this.processClasses(accessTypes, reflectiveClasses, introspectedClasses);
                this.processClasses(accessTypes, reflectiveClasses, element.getValue(TypeHint.class, "typeNames", String[].class).orElse(StringUtils.EMPTY_STRING_ARRAY));
            }
            if (element.hasAnnotation(Import.class)) {
                List beanElements = BeanImportVisitor.collectInjectableElements((ClassElement)element, (VisitorContext)context);
                for (ClassElement beanElement : beanElements) {
                    this.processBeanElement(reflectiveClasses, beanElement, true);
                }
            } else if (element.hasStereotype(Bean.class) || element.hasStereotype("javax.inject.Scope") || element.hasStereotype("javax.inject.Qualifier")) {
                this.processBeanElement(reflectiveClasses, element, false);
                MethodElement me = element.getPrimaryConstructor().orElse(null);
                if (me != null && me.isPrivate() && !me.hasAnnotation(ReflectiveAccess.class)) {
                    this.processMethodElement(me, reflectiveClasses);
                }
            }
            if (element.isInner() && (enclosingType = (ClassElement)element.getEnclosingType().orElse(null)) != null && enclosingType.hasAnnotation(ReflectiveAccess.class)) {
                String beanName = element.getName();
                this.addBean(beanName, reflectiveClasses);
                this.resolveClassData(beanName + "[]", reflectiveClasses);
            }
            if (!reflectiveClasses.isEmpty()) {
                this.originatingElements.add(element);
                AnnotationValue[] annotationValues = (AnnotationValue[])reflectiveClasses.values().stream().map(ReflectionConfigData::build).toArray(AnnotationValue[]::new);
                MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
                AnnotationValue av = AnnotationValue.builder(ReflectionConfig.ReflectionConfigList.class).values(annotationValues).build();
                annotationMetadata.addAnnotation(av.getAnnotationName(), av.getValues(), RetentionPolicy.RUNTIME);
                GraalReflectionMetadataWriter writer = new GraalReflectionMetadataWriter(element, (AnnotationMetadata)annotationMetadata);
                try {
                    writer.accept((ClassWriterOutputVisitor)context);
                }
                catch (IOException e) {
                    throw new ClassGenerationException("I/O error occurred during class generation: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processBeanElement(Map<String, ReflectionConfigData> reflectiveClasses, ClassElement beanElement, boolean isImport) {
        this.processBeanConstructor(reflectiveClasses, beanElement, isImport);
        this.processBeanMethods(reflectiveClasses, beanElement, isImport);
        this.processBeanFields(reflectiveClasses, beanElement, isImport);
    }

    private void processBeanFields(Map<String, ReflectionConfigData> reflectiveClasses, ClassElement beanElement, boolean isImport) {
        ElementQuery reflectiveFieldQuery = ElementQuery.ALL_FIELDS.onlyInstance().onlyInjected();
        if (isImport) {
            beanElement.getEnclosedElements(reflectiveFieldQuery.modifiers(elementModifiers -> !elementModifiers.contains(ElementModifier.PUBLIC))).forEach(e -> this.processFieldElement((FieldElement)e, reflectiveClasses));
        } else {
            beanElement.getEnclosedElements(reflectiveFieldQuery.modifiers(elementModifiers -> elementModifiers.contains(ElementModifier.PRIVATE))).forEach(e -> this.processFieldElement((FieldElement)e, reflectiveClasses));
        }
    }

    private void processBeanMethods(Map<String, ReflectionConfigData> reflectiveClasses, ClassElement beanElement, boolean isImport) {
        ElementQuery injectedMethodsThatNeedReflection = ElementQuery.ALL_METHODS.onlyInstance().onlyInjected();
        if (isImport) {
            Predicate<Set> nonPublicOnly = elementModifiers -> !elementModifiers.contains(ElementModifier.PUBLIC);
            beanElement.getEnclosedElements(injectedMethodsThatNeedReflection.modifiers(nonPublicOnly)).forEach(m -> this.processMethodElement((MethodElement)m, reflectiveClasses));
            beanElement.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance().modifiers(nonPublicOnly).annotated(ann -> ann.hasAnnotation(Executable.class))).forEach(m -> this.processMethodElement((MethodElement)m, reflectiveClasses));
        } else {
            Predicate<Set> privateOnly = elementModifiers -> elementModifiers.contains(ElementModifier.PRIVATE);
            beanElement.getEnclosedElements(injectedMethodsThatNeedReflection.modifiers(privateOnly)).forEach(m -> this.processMethodElement((MethodElement)m, reflectiveClasses));
            beanElement.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance().modifiers(privateOnly).annotated(ann -> ann.hasAnnotation(Executable.class))).forEach(m -> this.processMethodElement((MethodElement)m, reflectiveClasses));
        }
        beanElement.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(ann -> ann.hasAnnotation(ReflectiveAccess.class))).forEach(m -> this.processMethodElement((MethodElement)m, reflectiveClasses));
    }

    private void processBeanConstructor(Map<String, ReflectionConfigData> reflectiveClasses, ClassElement beanElement, boolean isImport) {
        MethodElement constructor = beanElement.getPrimaryConstructor().orElse(null);
        if (constructor != null && (constructor.hasAnnotation(ReflectiveAccess.class) || isImport && !constructor.isPublic() || !isImport && constructor.isPrivate())) {
            this.processMethodElement(constructor, reflectiveClasses);
        }
    }

    private void addBean(String beanName, Map<String, ReflectionConfigData> reflectiveClasses) {
        this.resolveClassData((String)beanName, reflectiveClasses).accessTypes.addAll(Arrays.asList(TypeHint.AccessType.ALL_PUBLIC_METHODS, TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS));
    }

    private void processFieldElement(FieldElement element, Map<String, ReflectionConfigData> classes) {
        ClassElement dt = element.getDeclaringType();
        ReflectionConfigData data = this.resolveClassData(this.resolveName(dt).getName(), classes);
        data.fields.add((AnnotationValue<ReflectionConfig.ReflectiveFieldConfig>)AnnotationValue.builder(ReflectionConfig.ReflectiveFieldConfig.class).member("name", element.getName()).build());
    }

    private AnnotationClassValue<?> resolveName(ClassElement classElement) {
        return new AnnotationClassValue(classElement.getCanonicalName());
    }

    private void processMethodElement(MethodElement element, Map<String, ReflectionConfigData> classes) {
        String methodName = element.getName();
        ClassElement declaringType = element.getDeclaringType();
        ReflectionConfigData data = this.resolveClassData(declaringType.getName(), classes);
        List<AnnotationClassValue> params = Arrays.stream(element.getParameters()).map(ParameterElement::getType).map(this::resolveName).collect(Collectors.toList());
        data.methods.add((AnnotationValue<ReflectionConfig.ReflectiveMethodConfig>)AnnotationValue.builder(ReflectionConfig.ReflectiveMethodConfig.class).member("name", methodName).member("parameterTypes", params.toArray(AnnotationClassValue.EMPTY_ARRAY)).build());
    }

    private void processClasses(TypeHint.AccessType[] accessType, Map<String, ReflectionConfigData> reflectiveClasses, String ... introspectedClasses) {
        for (TypeHint.AccessType accessType2 : accessType) {
            if (accessType2 != TypeHint.AccessType.ALL_PUBLIC) continue;
            for (String aClass : introspectedClasses) {
                this.addBean(aClass, reflectiveClasses);
            }
            return;
        }
        for (String string : introspectedClasses) {
            this.resolveClassData((String)string, reflectiveClasses).accessTypes.addAll(Arrays.asList(accessType));
        }
    }

    private ReflectionConfigData resolveClassData(String introspectedClass, Map<String, ReflectionConfigData> classes) {
        return classes.computeIfAbsent(introspectedClass, s -> new ReflectionConfigData(introspectedClass));
    }

    private static final class ReflectionConfigData {
        private final AnnotationClassValue<?> type;
        private final SortedSet<TypeHint.AccessType> accessTypes = new TreeSet<TypeHint.AccessType>();
        private final List<AnnotationValue<ReflectionConfig.ReflectiveMethodConfig>> methods = new ArrayList<AnnotationValue<ReflectionConfig.ReflectiveMethodConfig>>(30);
        private final List<AnnotationValue<ReflectionConfig.ReflectiveFieldConfig>> fields = new ArrayList<AnnotationValue<ReflectionConfig.ReflectiveFieldConfig>>(30);

        ReflectionConfigData(String type) {
            this.type = new AnnotationClassValue(type);
        }

        AnnotationValue<ReflectionConfig> build() {
            AnnotationValueBuilder builder = AnnotationValue.builder(ReflectionConfig.class).member("type", new AnnotationClassValue[]{this.type}).member("accessType", (Enum[])this.accessTypes.toArray(new TypeHint.AccessType[0]));
            if (!this.methods.isEmpty()) {
                builder.member("methods", this.methods.toArray(new AnnotationValue[0]));
            }
            if (!this.fields.isEmpty()) {
                builder.member("fields", this.fields.toArray(new AnnotationValue[0]));
            }
            return builder.build();
        }
    }
}

