/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.graal.reflect;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.graal.GraalReflectionConfigurer;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class GraalReflectionMetadataWriter
extends AbstractAnnotationMetadataWriter {
    private final String className;
    private final String classInternalName;

    public GraalReflectionMetadataWriter(ClassElement originatingElement, AnnotationMetadata annotationMetadata, VisitorContext visitorContext) {
        super(GraalReflectionMetadataWriter.resolveName(originatingElement), (Element)originatingElement, annotationMetadata, true, visitorContext);
        this.className = this.targetClassType.getClassName();
        this.classInternalName = this.targetClassType.getInternalName();
    }

    private static String resolveName(ClassElement originatingElement) {
        return originatingElement.getPackageName() + ".$" + originatingElement.getSimpleName() + "$ReflectConfig";
    }

    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.className, this.getOriginatingElements());){
            ClassWriter classWriter = this.generateClassBytes();
            outputStream.write(classWriter.toByteArray());
        }
        classWriterOutputVisitor.visitServiceDescriptor(GraalReflectionConfigurer.class, this.className, this.getOriginatingElement());
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        this.startService((ClassVisitor)classWriter, GraalReflectionMetadataWriter.getInternalName((String)GraalReflectionConfigurer.class.getName()), this.classInternalName, Type.getType(Object.class), new String[]{GraalReflectionMetadataWriter.getInternalName((String)GraalReflectionConfigurer.class.getName())});
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        this.writeConstructor(classWriter);
        this.writeGetAnnotationMetadataMethod(classWriter);
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        return classWriter;
    }

    private void writeConstructor(ClassWriter classWriter) {
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        this.invokeConstructor(cv, Object.class, new Class[0]);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
    }
}

