/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import javax.inject.Inject;

@ConfigurationProperties(value="micronaut.http.client")
@Primary
public class DefaultHttpClientConfiguration
extends HttpClientConfiguration {
    public static final String PREFIX = "micronaut.http.client";
    private final DefaultConnectionPoolConfiguration connectionPoolConfiguration;

    public DefaultHttpClientConfiguration() {
        this.connectionPoolConfiguration = new DefaultConnectionPoolConfiguration();
    }

    @Inject
    public DefaultHttpClientConfiguration(DefaultConnectionPoolConfiguration connectionPoolConfiguration, ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.connectionPoolConfiguration = connectionPoolConfiguration;
    }

    @Override
    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.connectionPoolConfiguration;
    }

    @Inject
    public void setClientSslConfiguration(@Nullable ClientSslConfiguration sslConfiguration) {
        if (sslConfiguration != null) {
            super.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
    }

    @ConfigurationProperties(value="pool")
    @Primary
    public static class DefaultConnectionPoolConfiguration
    extends HttpClientConfiguration.ConnectionPoolConfiguration {
    }
}

