/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.interceptor;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.BasicAuth;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.CustomHttpMethod;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestAttribute;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.RxHttpClientRegistry;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.interceptor.configuration.ClientVersioningConfiguration;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@BootstrapContextCompatible
public class HttpClientIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RxHttpClient.class);
    private static final MediaType[] DEFAULT_ACCEPT_TYPES = new MediaType[]{MediaType.APPLICATION_JSON_TYPE};
    private static final int HEADERS_INITIAL_CAPACITY = 3;
    private static final int ATTRIBUTES_INITIAL_CAPACITY = 1;
    private final BeanContext beanContext;
    private final Map<String, ClientVersioningConfiguration> versioningConfigurations = new ConcurrentHashMap<String, ClientVersioningConfiguration>(5);
    private final List<ReactiveClientResultTransformer> transformers;
    private final JsonMediaTypeCodec jsonMediaTypeCodec;
    private final RxHttpClientRegistry clientFactory;

    @Inject
    public HttpClientIntroductionAdvice(BeanContext beanContext, RxHttpClientRegistry clientFactory, JsonMediaTypeCodec jsonMediaTypeCodec, List<ReactiveClientResultTransformer> transformers) {
        this.clientFactory = clientFactory;
        this.jsonMediaTypeCodec = jsonMediaTypeCodec;
        this.beanContext = beanContext;
        this.transformers = transformers != null ? transformers : Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Object[] acceptTypes;
        String argumentName;
        if (!context.hasStereotype(Client.class)) {
            throw new IllegalStateException("Client advice called from type that is not annotated with @Client: " + context);
        }
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        Class declaringType = context.getDeclaringType();
        if (Closeable.class == declaringType || AutoCloseable.class == declaringType) {
            this.clientFactory.disposeClient(annotationMetadata);
            return null;
        }
        Optional httpMethodMapping = context.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        RxHttpClient httpClient = this.clientFactory.getClient(annotationMetadata);
        if (!context.hasStereotype(HttpMethodMapping.class) || httpClient == null) return context.proceed();
        AnnotationValue mapping = context.getAnnotation(HttpMethodMapping.class);
        String uri = (String)mapping.getRequiredValue(String.class);
        if (StringUtils.isEmpty((CharSequence)uri)) {
            uri = "/" + context.getMethodName();
        }
        Class annotationType = (Class)httpMethodMapping.get();
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)"");
        if (uri.length() != 1 || uri.charAt(0) != '/') {
            uriTemplate = uriTemplate.nest((CharSequence)uri);
        }
        Map paramMap = context.getParameterValueMap();
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        List uriVariables = uriTemplate.getVariableNames();
        Object body = null;
        Map parameters = context.getParameters();
        Argument[] arguments = context.getArguments();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(3);
        List headerAnnotations = context.getAnnotationValuesByType(Header.class);
        for (AnnotationValue headerAnnotation : headerAnnotations) {
            String headerName = headerAnnotation.stringValue("name").orElse(null);
            String headerValue = headerAnnotation.stringValue().orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)headerName) || !StringUtils.isNotEmpty((CharSequence)headerValue)) continue;
            headers.putIfAbsent(headerName, headerValue);
        }
        context.findAnnotation(Version.class).flatMap(AnnotationValue::stringValue).filter(StringUtils::isNotEmpty).ifPresent(version -> {
            ClientVersioningConfiguration configuration = this.getVersioningConfiguration(annotationMetadata);
            configuration.getHeaders().forEach(header -> headers.put((String)header, (String)version));
            configuration.getParameters().forEach(parameter -> queryParams.put((String)parameter, (String)version));
        });
        LinkedHashMap attributes = new LinkedHashMap(1);
        List attributeAnnotations = context.getAnnotationValuesByType(RequestAttribute.class);
        for (AnnotationValue attributeAnnotation : attributeAnnotations) {
            String attributeName = attributeAnnotation.stringValue("name").orElse(null);
            Object attributeValue = attributeAnnotation.getValue(Object.class).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)attributeName) || attributeValue == null) continue;
            attributes.put(attributeName, attributeValue);
        }
        ArrayList cookies = new ArrayList();
        ArrayList<Argument> bodyArguments = new ArrayList<Argument>();
        ConversionService conversionService = ConversionService.SHARED;
        BasicAuth basicAuth = null;
        for (Argument argument : arguments) {
            String parameterName;
            Object v2;
            argumentName = argument.getName();
            AnnotationMetadata argumentMetadata = argument.getAnnotationMetadata();
            MutableArgumentValue value2 = (MutableArgumentValue)parameters.get(argumentName);
            Object definedValue = value2.getValue();
            if (paramMap.containsKey(argumentName) && argumentMetadata.hasStereotype(Format.class) && (v2 = paramMap.get(argumentName)) != null) {
                paramMap.put(argumentName, conversionService.convert(v2, ConversionContext.of(String.class).with(argument.getAnnotationMetadata())));
            }
            if (definedValue == null) {
                definedValue = argument.getAnnotationMetadata().stringValue(Bindable.class, "defaultValue").orElse(null);
            }
            if (definedValue == null && !argument.isNullable()) {
                throw new IllegalArgumentException(String.format("Argument [%s] is null. Null values are not allowed to be passed to client methods (%s). Add a supported Nullable annotation type if that is the desired behavior", argument.getName(), context.getExecutableMethod().toString()));
            }
            if (argument.isAnnotationPresent(Body.class)) {
                body = definedValue;
                continue;
            }
            if (argumentMetadata.isAnnotationPresent(Header.class)) {
                String headerName = argumentMetadata.stringValue(Header.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)headerName)) {
                    headerName = NameUtils.hyphenate((String)argumentName);
                }
                String finalHeaderName = headerName;
                conversionService.convert(definedValue, String.class).ifPresent(o -> headers.put(finalHeaderName, (String)o));
                continue;
            }
            if (argumentMetadata.isAnnotationPresent(CookieValue.class)) {
                String cookieName = argumentMetadata.stringValue(CookieValue.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)cookieName)) {
                    cookieName = argumentName;
                }
                String finalCookieName = cookieName;
                conversionService.convert(definedValue, String.class).ifPresent(o -> cookies.add(Cookie.of((String)finalCookieName, (String)o)));
                continue;
            }
            if (argumentMetadata.isAnnotationPresent(QueryValue.class)) {
                parameterName = argumentMetadata.stringValue(QueryValue.class).orElse(null);
                boolean isExploded = uriTemplate.getVariables().stream().filter(v -> v.getName().equals(parameterName)).findFirst().map(UriMatchVariable::isExploded).orElse(false);
                if (isExploded) {
                    if (StringUtils.isEmpty((CharSequence)parameterName)) continue;
                    paramMap.put(parameterName, definedValue);
                    continue;
                }
                conversionService.convert(definedValue, ConversionContext.of(String.class).with(argumentMetadata)).ifPresent(o -> {
                    if (!StringUtils.isEmpty((CharSequence)parameterName)) {
                        paramMap.put(parameterName, o);
                        queryParams.put(parameterName, (String)o);
                    } else {
                        queryParams.put(argumentName, (String)o);
                    }
                });
                continue;
            }
            if (argumentMetadata.isAnnotationPresent(RequestAttribute.class)) {
                String attributeName = argumentMetadata.stringValue(RequestAttribute.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)attributeName)) {
                    attributeName = NameUtils.hyphenate((String)argumentName);
                }
                String finalAttributeName = attributeName;
                conversionService.convert(definedValue, Object.class).ifPresent(o -> attributes.put(finalAttributeName, o));
                continue;
            }
            if (argumentMetadata.isAnnotationPresent(PathVariable.class)) {
                parameterName = argumentMetadata.stringValue(PathVariable.class).orElse(null);
                conversionService.convert(definedValue, ConversionContext.of(String.class).with(argumentMetadata)).ifPresent(o -> {
                    if (!StringUtils.isEmpty((CharSequence)o)) {
                        paramMap.put(parameterName, o);
                    }
                });
                continue;
            }
            if (argument.getType() == BasicAuth.class) {
                basicAuth = (BasicAuth)paramMap.get(argument.getName());
                continue;
            }
            if (uriVariables.contains(argumentName)) continue;
            bodyArguments.add(argument);
        }
        HttpMethod httpMethod = HttpMethod.parse((String)annotationType.getSimpleName().toUpperCase());
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
            if (body == null && !bodyArguments.isEmpty()) {
                LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>();
                for (Argument argument : bodyArguments) {
                    argumentName = argument.getName();
                    MutableArgumentValue value3 = (MutableArgumentValue)parameters.get(argumentName);
                    bodyMap.put(argumentName, value3.getValue());
                }
                body = bodyMap;
            }
            if (body != null) {
                boolean variableSatisfied;
                boolean bl = variableSatisfied = uriVariables.isEmpty() || uriVariables.containsAll(paramMap.keySet());
                if (!variableSatisfied) {
                    if (body instanceof Map) {
                        for (Map.Entry entry : ((Map)body).entrySet()) {
                            String k = entry.getKey().toString();
                            Object v3 = entry.getValue();
                            if (v3 == null) continue;
                            paramMap.putIfAbsent(k, v3);
                        }
                    } else {
                        BeanMap beanMap = BeanMap.of(body);
                        for (Map.Entry entry : beanMap.entrySet()) {
                            Iterator k = (String)entry.getKey();
                            Object v4 = entry.getValue();
                            if (v4 == null) continue;
                            paramMap.putIfAbsent(k, v4);
                        }
                    }
                }
            }
        }
        uri = uriTemplate.expand(paramMap);
        uriVariables.forEach(queryParams::remove);
        String httpMethodName = context.stringValue(CustomHttpMethod.class, "method").orElse(httpMethod.name());
        MutableHttpRequest request = HttpRequest.create((HttpMethod)httpMethod, (String)this.appendQuery(uri, queryParams), (String)httpMethodName);
        if (body != null) {
            void var27_42;
            request.body(body);
            Object[] objectArray = MediaType.of((CharSequence[])context.stringValues(Produces.class));
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                MediaType[] mediaTypeArray = DEFAULT_ACCEPT_TYPES;
            }
            if (ArrayUtils.isNotEmpty((Object[])var27_42)) {
                request.contentType((MediaType)var27_42[0]);
            }
        }
        request.setAttribute((CharSequence)HttpAttributes.INVOCATION_CONTEXT, context);
        request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)this.resolveTemplate(annotationMetadata, uriTemplate.toString()));
        String string = this.getClientId(annotationMetadata);
        Argument<JsonError> errorType = annotationMetadata.classValue(Client.class, "errorType").map(Argument::of).orElse(HttpClient.DEFAULT_ERROR_TYPE);
        request.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)string);
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                request.header((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        cookies.forEach(arg_0 -> ((MutableHttpRequest)request).cookie(arg_0));
        if (!attributes.isEmpty()) {
            for (Map.Entry entry : attributes.entrySet()) {
                request.setAttribute((CharSequence)entry.getKey(), entry.getValue());
            }
        }
        if (ArrayUtils.isEmpty((Object[])(acceptTypes = MediaType.of((CharSequence[])context.stringValues(Consumes.class))))) {
            acceptTypes = DEFAULT_ACCEPT_TYPES;
        }
        if (basicAuth != null) {
            request.basicAuth((CharSequence)basicAuth.getUsername(), (CharSequence)basicAuth.getPassword());
        }
        ReturnType returnType = context.getReturnType();
        Class javaReturnType = returnType.getType();
        boolean isFuture = CompletionStage.class.isAssignableFrom(javaReturnType);
        final Class methodDeclaringType = declaringType;
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType) || isFuture) {
            void var38_63;
            void var37_76;
            boolean isSingle = returnType.isSingleResult() || returnType.isCompletable();
            Argument publisherArgument = returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            final Class argumentType = publisherArgument.getType();
            if (HttpResponse.class.isAssignableFrom(argumentType) || HttpStatus.class.isAssignableFrom(argumentType)) {
                isSingle = true;
            }
            if (!isSingle && httpClient instanceof StreamingHttpClient) {
                StreamingHttpClient streamingHttpClient = (StreamingHttpClient)((Object)httpClient);
                if (!Void.class.isAssignableFrom(argumentType)) {
                    request.accept((MediaType[])acceptTypes);
                }
                if (HttpResponse.class.isAssignableFrom(argumentType) || Void.class.isAssignableFrom(argumentType)) {
                    Publisher<HttpResponse<ByteBuffer<?>>> publisher = streamingHttpClient.exchangeStream(request);
                } else {
                    boolean isEventStream = Arrays.asList(acceptTypes).contains(MediaType.TEXT_EVENT_STREAM_TYPE);
                    if (isEventStream && streamingHttpClient instanceof SseClient) {
                        SseClient sseClient = (SseClient)((Object)streamingHttpClient);
                        if (publisherArgument.getType() == Event.class) {
                            Publisher publisher = sseClient.eventStream(request, publisherArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                        } else {
                            Flowable flowable = Flowable.fromPublisher(sseClient.eventStream(request, publisherArgument)).map(Event::getData);
                        }
                    } else {
                        boolean isJson = this.isJsonParsedMediaType((MediaType[])acceptTypes);
                        if (isJson) {
                            Publisher publisher = streamingHttpClient.jsonStream(request, publisherArgument);
                        } else {
                            Publisher<ByteBuffer<?>> byteBufferPublisher = streamingHttpClient.dataStream(request);
                            if (argumentType == ByteBuffer.class) {
                                Publisher<ByteBuffer<?>> publisher = byteBufferPublisher;
                            } else {
                                if (!conversionService.canConvert(ByteBuffer.class, argumentType)) throw new ConfigurationException("Cannot create the generated HTTP client's required return type, since no TypeConverter from ByteBuffer to " + argumentType + " is registered");
                                Flowable flowable = Flowable.fromPublisher(byteBufferPublisher).map(value -> conversionService.convert(value, argumentType).get());
                            }
                        }
                    }
                }
            } else if (Void.class.isAssignableFrom(argumentType) || Completable.class.isAssignableFrom(javaReturnType)) {
                Publisher publisher = httpClient.exchange(request, null, errorType);
            } else {
                request.accept((MediaType[])acceptTypes);
                if (HttpResponse.class.isAssignableFrom(argumentType)) {
                    Publisher publisher = httpClient.exchange(request, publisherArgument, errorType);
                } else {
                    Publisher publisher = httpClient.retrieve(request, publisherArgument, errorType);
                }
            }
            if (isFuture) {
                final CompletableFuture completableFuture = new CompletableFuture();
                var37_76.subscribe((Subscriber)new CompletionAwareSubscriber<Object>(){
                    AtomicReference<Object> reference = new AtomicReference();

                    protected void doOnSubscribe(Subscription subscription) {
                        subscription.request(1L);
                    }

                    protected void doOnNext(Object message) {
                        if (!Void.class.isAssignableFrom(argumentType)) {
                            this.reference.set(message);
                        }
                    }

                    protected void doOnError(Throwable t) {
                        HttpClientResponseException e;
                        if (t instanceof HttpClientResponseException && (e = (HttpClientResponseException)((Object)t)).getStatus() == HttpStatus.NOT_FOUND) {
                            completableFuture.complete(null);
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Client [" + methodDeclaringType.getName() + "] received HTTP error response: " + t.getMessage(), t);
                        }
                        completableFuture.completeExceptionally(t);
                    }

                    protected void doOnComplete() {
                        completableFuture.complete(this.reference.get());
                    }
                });
                return completableFuture;
            }
            Object t = conversionService.convert((Object)var37_76, javaReturnType).orElseThrow(() -> new HttpClientException("Cannot convert response publisher to Reactive type (Unsupported Reactive type): " + javaReturnType));
            for (ReactiveClientResultTransformer transformer : this.transformers) {
                Object object = transformer.transform(var38_63);
            }
            return var38_63;
        }
        BlockingHttpClient blockingHttpClient = httpClient.toBlocking();
        if (Void.TYPE != javaReturnType && httpMethod != HttpMethod.HEAD) {
            request.accept((MediaType[])acceptTypes);
        }
        if (HttpResponse.class.isAssignableFrom(javaReturnType)) {
            return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.exchange(request, returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT), errorType));
        }
        if (Void.TYPE != javaReturnType) return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.retrieve(request, returnType.asArgument(), errorType));
        return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.exchange(request, null, errorType));
    }

    private Object handleBlockingCall(Class returnType, Supplier<Object> supplier) {
        try {
            if (Void.TYPE == returnType) {
                supplier.get();
                return null;
            }
            return supplier.get();
        }
        catch (RuntimeException t) {
            if (t instanceof HttpClientResponseException && ((HttpClientResponseException)((Object)t)).getStatus() == HttpStatus.NOT_FOUND) {
                if (returnType == Optional.class) {
                    return Optional.empty();
                }
                if (HttpResponse.class.isAssignableFrom(returnType)) {
                    return ((HttpClientResponseException)((Object)t)).getResponse();
                }
                return null;
            }
            throw t;
        }
    }

    private ClientVersioningConfiguration getVersioningConfiguration(AnnotationMetadata annotationMetadata) {
        return this.versioningConfigurations.computeIfAbsent(this.getClientId(annotationMetadata), clientId -> this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)clientId)).orElseGet(() -> (ClientVersioningConfiguration)this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)"default")).orElseThrow(() -> new ConfigurationException("Attempt to apply a '@Version' to the request, but versioning configuration found neither for '" + clientId + "' nor '" + "default" + "' provided."))));
    }

    private boolean isJsonParsedMediaType(MediaType[] acceptTypes) {
        return Arrays.stream(acceptTypes).anyMatch(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE) || mediaType.getExtension().equals("json") || this.jsonMediaTypeCodec.getMediaTypes().contains(mediaType));
    }

    private String resolveTemplate(AnnotationMetadata annotationMetadata, String templateString) {
        String path = annotationMetadata.stringValue(Client.class, "path").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return path + templateString;
        }
        String value = this.getClientId(annotationMetadata);
        if (StringUtils.isNotEmpty((CharSequence)value) && value.startsWith("/")) {
            return value + templateString;
        }
        return templateString;
    }

    private String getClientId(AnnotationMetadata clientAnn) {
        return clientAnn.stringValue(Client.class).orElse(null);
    }

    private String appendQuery(String uri, Map<String, String> queryParams) {
        if (!queryParams.isEmpty()) {
            UriBuilder builder = UriBuilder.of((CharSequence)uri);
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            return builder.toString();
        }
        return uri;
    }
}

