/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.LifeCycle;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.hateoas.JsonError;
import java.io.Closeable;
import java.net.URL;
import java.util.Optional;
import org.reactivestreams.Publisher;

public interface HttpClient
extends Closeable,
LifeCycle<HttpClient> {
    public static final Argument<JsonError> DEFAULT_ERROR_TYPE = Argument.of(JsonError.class);

    public BlockingHttpClient toBlocking();

    public <I, O, E> Publisher<HttpResponse<O>> exchange(HttpRequest<I> var1, Argument<O> var2, Argument<E> var3);

    default public <I, O> Publisher<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType) {
        return this.exchange(request, bodyType, DEFAULT_ERROR_TYPE);
    }

    default public <I> Publisher<HttpResponse<ByteBuffer>> exchange(HttpRequest<I> request) {
        return this.exchange(request, ByteBuffer.class);
    }

    default public Publisher<HttpResponse<ByteBuffer>> exchange(String uri) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Class)ByteBuffer.class);
    }

    default public <O> Publisher<HttpResponse<O>> exchange(String uri, Class<O> bodyType) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)Argument.of(bodyType));
    }

    default public <I, O> Publisher<HttpResponse<O>> exchange(HttpRequest<I> request, Class<O> bodyType) {
        return this.exchange(request, Argument.of(bodyType));
    }

    default public <I, O, E> Publisher<O> retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        return Publishers.map(this.exchange(request, bodyType, errorType), response -> {
            if (bodyType.getType() == HttpStatus.class) {
                return response.getStatus();
            }
            Optional body = response.getBody();
            return body.orElseThrow(() -> new HttpClientResponseException("Empty body", (HttpResponse<?>)response));
        });
    }

    default public <I, O> Publisher<O> retrieve(HttpRequest<I> request, Argument<O> bodyType) {
        return this.retrieve(request, bodyType, DEFAULT_ERROR_TYPE);
    }

    default public <I, O> Publisher<O> retrieve(HttpRequest<I> request, Class<O> bodyType) {
        return this.retrieve(request, Argument.of(bodyType));
    }

    default public <I> Publisher<String> retrieve(HttpRequest<I> request) {
        return this.retrieve(request, String.class);
    }

    default public Publisher<String> retrieve(String uri) {
        return this.retrieve((HttpRequest)HttpRequest.GET((String)uri), (Class)String.class);
    }

    default public HttpClient refresh() {
        this.stop();
        return (HttpClient)this.start();
    }

    public static HttpClient create(@Nullable URL url) {
        return HttpClientConfiguration.createClient(url);
    }

    public static HttpClient create(@Nullable URL url, HttpClientConfiguration configuration) {
        return HttpClientConfiguration.createClient(url, configuration);
    }
}

