/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.bind;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.BasicAuth;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestAttribute;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.client.bind.AnnotatedClientArgumentRequestBinder;
import io.micronaut.http.client.bind.AnnotatedClientRequestBinder;
import io.micronaut.http.client.bind.ClientArgumentRequestBinder;
import io.micronaut.http.client.bind.ClientRequestBinder;
import io.micronaut.http.client.bind.HttpClientBinderRegistry;
import io.micronaut.http.client.bind.TypedClientArgumentRequestBinder;
import io.micronaut.http.client.bind.binders.AttributeClientRequestBinder;
import io.micronaut.http.client.bind.binders.HeaderClientRequestBinder;
import io.micronaut.http.client.bind.binders.VersionClientRequestBinder;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.uri.UriMatchVariable;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.coroutines.Continuation;

@Singleton
@Internal
public class DefaultHttpClientBinderRegistry
implements HttpClientBinderRegistry {
    private final Map<Class<? extends Annotation>, ClientArgumentRequestBinder<?>> byAnnotation = new LinkedHashMap();
    private final Map<Integer, ClientArgumentRequestBinder<?>> byType = new LinkedHashMap();
    private final Map<Class<? extends Annotation>, AnnotatedClientRequestBinder<?>> methodByAnnotation = new LinkedHashMap();

    protected DefaultHttpClientBinderRegistry(ConversionService<?> conversionService, List<ClientRequestBinder> binders, BeanContext beanContext) {
        this.byType.put(Argument.of(HttpHeaders.class).typeHashCode(), (context, uriContext, value, request) -> value.forEachValue((arg_0, arg_1) -> ((MutableHttpRequest)request).header(arg_0, arg_1)));
        this.byType.put(Argument.of(Cookies.class).typeHashCode(), (context, uriContext, value, request) -> request.cookies(value.getAll()));
        this.byType.put(Argument.of(Cookie.class).typeHashCode(), (context, uriContext, value, request) -> request.cookie(value));
        this.byType.put(Argument.of(BasicAuth.class).typeHashCode(), (context, uriContext, value, request) -> request.basicAuth((CharSequence)value.getUsername(), (CharSequence)value.getPassword()));
        this.byType.put(Argument.of(Locale.class).typeHashCode(), (context, uriContext, value, request) -> request.header((CharSequence)"Accept-Language", (CharSequence)value.toLanguageTag()));
        this.byAnnotation.put(QueryValue.class, (context, uriContext, value, request) -> {
            String parameterName = context.getAnnotationMetadata().stringValue(QueryValue.class).filter(StringUtils::isNotEmpty).orElse(context.getArgument().getName());
            UriMatchVariable uriVariable = uriContext.getUriTemplate().getVariables().stream().filter(v -> v.getName().equals(parameterName)).findFirst().orElse(null);
            if (uriVariable != null) {
                if (uriVariable.isExploded()) {
                    uriContext.setPathParameter(parameterName, value);
                } else {
                    String convertedValue2 = conversionService.convert(value, ConversionContext.STRING.with(context.getAnnotationMetadata())).filter(StringUtils::isNotEmpty).orElse(null);
                    if (convertedValue2 != null) {
                        uriContext.setPathParameter(parameterName, convertedValue2);
                    } else {
                        uriContext.setPathParameter(parameterName, value);
                    }
                }
            } else {
                conversionService.convert(value, ConversionContext.STRING.with(context.getAnnotationMetadata())).filter(StringUtils::isNotEmpty).ifPresent(convertedValue -> uriContext.addQueryParameter(parameterName, (String)convertedValue));
            }
        });
        this.byAnnotation.put(PathVariable.class, (context, uriContext, value, request) -> {
            String parameterName = context.getAnnotationMetadata().stringValue(PathVariable.class).filter(StringUtils::isNotEmpty).orElse(context.getArgument().getName());
            conversionService.convert(value, ConversionContext.STRING.with(context.getAnnotationMetadata())).filter(StringUtils::isNotEmpty).ifPresent(param -> uriContext.getPathParameters().put(parameterName, param));
        });
        this.byAnnotation.put(CookieValue.class, (context, uriContext, value, request) -> {
            String cookieName = context.getAnnotationMetadata().stringValue(CookieValue.class).filter(StringUtils::isNotEmpty).orElse(context.getArgument().getName());
            conversionService.convert(value, String.class).ifPresent(o -> request.cookie(Cookie.of((String)cookieName, (String)o)));
        });
        this.byAnnotation.put(Header.class, (context, uriContext, value, request) -> {
            AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
            String headerName = annotationMetadata.stringValue(Header.class).filter(StringUtils::isNotEmpty).orElse(NameUtils.hyphenate((String)context.getArgument().getName()));
            conversionService.convert(value, String.class).ifPresent(header -> request.getHeaders().set((CharSequence)headerName, (CharSequence)header));
        });
        this.byAnnotation.put(RequestAttribute.class, (context, uriContext, value, request) -> {
            AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
            String attributeName = annotationMetadata.stringValue(RequestAttribute.class).filter(StringUtils::isNotEmpty).orElse(NameUtils.hyphenate((String)context.getArgument().getName()));
            request.getAttributes().put((CharSequence)attributeName, value);
            conversionService.convert(value, String.class).ifPresent(v -> uriContext.getPathParameters().put(context.getArgument().getName(), v));
        });
        this.byAnnotation.put(Body.class, (context, uriContext, value, request) -> request.body(value));
        this.byAnnotation.put(RequestBean.class, (context, uriContext, value, request) -> {
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)context.getArgument().getType());
            for (BeanProperty beanProperty : introspection.getBeanProperties()) {
                this.findArgumentBinder(beanProperty.asArgument()).ifPresent(binder -> {
                    Object propertyValue = beanProperty.get(value);
                    if (propertyValue != null) {
                        binder.bind(context.with(beanProperty.asArgument()), uriContext, propertyValue, request);
                    }
                });
            }
        });
        this.methodByAnnotation.put(Header.class, new HeaderClientRequestBinder());
        this.methodByAnnotation.put(Version.class, new VersionClientRequestBinder(beanContext));
        this.methodByAnnotation.put(RequestAttribute.class, new AttributeClientRequestBinder());
        if (KotlinUtils.KOTLIN_COROUTINES_SUPPORTED) {
            this.byType.put(Argument.of(Continuation.class).typeHashCode(), (context, uriContext, value, request) -> {});
        }
        if (CollectionUtils.isNotEmpty(binders)) {
            for (ClientRequestBinder binder : binders) {
                this.addBinder(binder);
            }
        }
    }

    @Override
    public <T> Optional<ClientArgumentRequestBinder<?>> findArgumentBinder(@NonNull Argument<T> argument) {
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class annotationType = (Class)opt.get();
            ClientArgumentRequestBinder<?> binder = this.byAnnotation.get(annotationType);
            return Optional.ofNullable(binder);
        }
        Optional<ClientArgumentRequestBinder<?>> typeBinder = this.findTypeBinder(argument);
        if (typeBinder.isPresent()) {
            return typeBinder;
        }
        if (argument.isOptional()) {
            Argument typeArgument = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            return this.findTypeBinder(typeArgument);
        }
        return Optional.empty();
    }

    @Override
    public Optional<AnnotatedClientRequestBinder<?>> findAnnotatedBinder(@NonNull Class<?> annotationType) {
        return Optional.ofNullable(this.methodByAnnotation.get(annotationType));
    }

    public <T> void addBinder(ClientRequestBinder binder) {
        if (binder instanceof AnnotatedClientRequestBinder) {
            AnnotatedClientRequestBinder annotatedBinder = (AnnotatedClientRequestBinder)binder;
            this.methodByAnnotation.put(annotatedBinder.getAnnotationType(), annotatedBinder);
        } else if (binder instanceof AnnotatedClientArgumentRequestBinder) {
            AnnotatedClientArgumentRequestBinder annotatedRequestArgumentBinder = (AnnotatedClientArgumentRequestBinder)binder;
            Class annotationType = annotatedRequestArgumentBinder.getAnnotationType();
            this.byAnnotation.put(annotationType, annotatedRequestArgumentBinder);
        } else if (binder instanceof TypedClientArgumentRequestBinder) {
            TypedClientArgumentRequestBinder typedRequestArgumentBinder = (TypedClientArgumentRequestBinder)binder;
            this.byType.put(typedRequestArgumentBinder.argumentType().typeHashCode(), typedRequestArgumentBinder);
            List<Class<?>> superTypes = typedRequestArgumentBinder.superTypes();
            if (CollectionUtils.isNotEmpty(superTypes)) {
                for (Class<?> superType : superTypes) {
                    this.byType.put(Argument.of(superType).typeHashCode(), typedRequestArgumentBinder);
                }
            }
        }
    }

    private <T> Optional<ClientArgumentRequestBinder<?>> findTypeBinder(Argument<T> argument) {
        ClientArgumentRequestBinder<?> binder = this.byType.get(argument.typeHashCode());
        if (binder != null) {
            return Optional.of(binder);
        }
        return Optional.ofNullable(this.byType.get(Argument.of((Class)argument.getType()).typeHashCode()));
    }
}

