/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClientFactoryResolver;
import java.net.URL;
import java.util.Map;
import org.reactivestreams.Publisher;

public interface StreamingHttpClient
extends HttpClient {
    public <I> Publisher<ByteBuffer<?>> dataStream(HttpRequest<I> var1);

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(HttpRequest<I> var1);

    public <I> Publisher<Map<String, Object>> jsonStream(HttpRequest<I> var1);

    public <I, O> Publisher<O> jsonStream(HttpRequest<I> var1, Argument<O> var2);

    default public <I, O> Publisher<O> jsonStream(HttpRequest<I> request, Class<O> type) {
        return this.jsonStream(request, Argument.of(type));
    }

    public static StreamingHttpClient create(@Nullable URL url) {
        return StreamingHttpClientFactoryResolver.getFactory().createStreamingClient(url);
    }

    public static StreamingHttpClient create(@Nullable URL url, HttpClientConfiguration configuration) {
        return StreamingHttpClientFactoryResolver.getFactory().createStreamingClient(url, configuration);
    }
}

