/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientException;

@Internal
public final class HttpClientExceptionUtils {
    private HttpClientExceptionUtils() {
    }

    public static <E extends HttpClientException> E populateServiceId(E exc, @Nullable String clientId, @Nullable HttpClientConfiguration configuration) {
        if (clientId != null) {
            exc.setServiceId(clientId);
        } else if (configuration instanceof ServiceHttpClientConfiguration) {
            ServiceHttpClientConfiguration clientConfiguration = (ServiceHttpClientConfiguration)configuration;
            exc.setServiceId(clientConfiguration.getServiceId());
        }
        return exc;
    }
}

